/*
 * Decompiled with CFR 0.152.
 */
package ClientServer.ClientServer.client;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.KTextWindow;
import Utilities.SegmentUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class Client
extends Thread {
    private static KTextWindow clientWindow = null;
    public static boolean _lineFromServer = false;
    public static String error;
    public static final int DEFAULT_TIMEOUT = 5000;
    protected boolean kill = false;
    protected Socket socket = null;
    protected int localPortID = -1;
    protected PrintStream toServer = null;
    protected BufferedReader fromServer = null;
    protected String lineFromServer = new String();
    protected String serverAddress = "unknown";
    protected String sender = "unknown";
    protected String address = "unknown";
    protected boolean connected = false;
    public boolean isHoudini = false;
    private boolean isMayaMel = false;
    private boolean isMayaPython = false;
    private String helloStr = "Cutter";
    private static Hashtable<String, Object[]> tableOfOpenPorts;
    private int serverPort;

    static void setLog(String str) {
        if (clientWindow == null) {
            KTextWindow[] tmp = KTextWindow.addWindow(false, "Client Log");
            if (tmp == null || tmp.length > 0) {
                Cutter.setLog("    Error: Client.setLog() cannot get front window");
                return;
            }
            clientWindow = tmp[0];
            clientWindow.lockTitle(true);
            clientWindow.setSaveable(false);
            clientWindow.addVetoableChangeListener(new LogWindowListener());
            Dimension deskSize = KAbstractDesktop.getDesktopSize();
            Rectangle rect = new Rectangle();
            try {
                int x = Integer.parseInt(Preferences.get(Preferences.CLIENT_LOG_X));
                int y = Integer.parseInt(Preferences.get(Preferences.CLIENT_LOG_Y));
                int width = Integer.parseInt(Preferences.get(Preferences.CLIENT_LOG_WIDTH));
                int height = Integer.parseInt(Preferences.get(Preferences.CLIENT_LOG_HEIGHT));
                rect = new Rectangle(x, y, width, height);
            }
            catch (NumberFormatException e) {
                Cutter.setLog("    Exception:LogWindowListener.setLog()\n" + e.toString());
                rect = new Rectangle(400, 50, 300, 200);
            }
            clientWindow.setBounds(rect);
            clientWindow.setVisible(true);
            clientWindow.setSelected(true);
            clientWindow.getEditor().requestFocus();
        }
        clientWindow.prependText("\n******************************\n");
        clientWindow.prependText(str);
    }

    public static Client getOpenPort(String server, int port) {
        String key = "" + port;
        Object[] data = tableOfOpenPorts.get(key);
        if (data == null || data.length != 3) {
            return null;
        }
        String servStr = (String)data[0];
        if (servStr != null && servStr.equals(server)) {
            Client.addToTable(server, port, (Client)data[2]);
            return (Client)data[2];
        }
        return null;
    }

    private static void addToTable(String server, int port, Client client) {
        String key = "" + port;
        Object[] data = tableOfOpenPorts.remove(key);
        if (data != null && data.length != 3) {
            data = null;
        } else if (data != null && data.length == 3) {
            String servStr = (String)data[0];
            int counter = (Integer)data[1];
            Client cl = (Client)data[2];
            if (servStr != null && servStr.equals(server)) {
                data[0] = servStr;
                data[1] = counter + 1;
                data[2] = cl;
            } else {
                data = null;
            }
        }
        if (data == null) {
            data = new Object[]{server, 1, client};
        }
        tableOfOpenPorts.put(key, data);
    }

    private static int removeFromTable(String server, int port) {
        String key = "" + port;
        Object[] data = tableOfOpenPorts.remove(key);
        if (data == null || data.length != 3) {
            return 0;
        }
        String servStr = (String)data[0];
        int counter = (Integer)data[1];
        Client cl = (Client)data[2];
        if (servStr != null && !servStr.equals(server)) {
            tableOfOpenPorts.put(key, data);
            return 0;
        }
        if (counter > 0) {
            data = new Object[]{servStr, --counter, cl};
            tableOfOpenPorts.put(key, data);
            return counter;
        }
        return 0;
    }

    private static boolean removeFromTable(Client client) {
        Enumeration<String> e = tableOfOpenPorts.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object[] data = tableOfOpenPorts.remove(key);
            if (data == null || data.length != 3) continue;
            String servStr = (String)data[0];
            Client cl = (Client)data[2];
            if (cl != null && cl != client) {
                tableOfOpenPorts.put(key, data);
                continue;
            }
            if (cl == null || cl != client) continue;
            int counter = (Integer)data[1];
            if (--counter <= 0) {
                Cutter.setLog("    Info:Client.removeFromTable() - removing key \"" + key + "\"");
                return true;
            }
            data = new Object[]{servStr, counter, client};
            tableOfOpenPorts.put(key, data);
            Cutter.setLog("    Info:Client.removeFromTable() - decrementing counter to " + counter);
            return false;
        }
        return false;
    }

    public static int tableSize() {
        return tableOfOpenPorts.size();
    }

    public void close() {
        if (Client.removeFromTable(this)) {
            this.kill = true;
            this.toServer.println("goodbye");
        }
    }

    public Client(String recipientIP, int portID) throws Exception {
        this(recipientIP, portID, "Cutter");
    }

    public Client(String serverAddress, int serverPort, String helloStr) throws Exception {
        this.serverAddress = serverAddress;
        this.helloStr = helloStr;
        this.sender = Client.getLocalIP();
        this.serverPort = serverPort;
        Client.addToTable(serverAddress, serverPort, this);
        Cutter.setLog("    Info:Client.Client() - opening socket to: " + serverAddress + " on port: " + serverPort);
        try {
            this.address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            this.address = "unknown";
            return;
        }
        try {
            this.socket = new Socket();
            InetSocketAddress sa = new InetSocketAddress(serverAddress, serverPort);
            this.socket.connect(sa, 2000);
            this.toServer = new PrintStream(this.socket.getOutputStream(), true);
            this.fromServer = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            error = "Cannot locate a computer with the IP address \"" + serverAddress + "\". \nCheck the IP address of the computer from whom you wish to receive broadcasts.";
            throw e;
        }
        catch (Exception e) {
            error = "Cannot connect to \"" + serverAddress + "\" probably because \nCutter on that computer is either not broadcasting\non port \"" + serverPort + "\", or is not broadcasting at all!";
            throw e;
        }
        this.localPortID = this.socket.getLocalPort();
        error = null;
        this.socket.setReuseAddress(true);
    }

    @Override
    public void run() {
        String lineFromServer = "";
        while (!this.kill) {
            String ext;
            if (!this.isHoudini) {
                this.toServer.println(this.helloStr);
            } else {
                this.toServer.println("version");
                Monitor.setPanelText("hscript", "");
            }
            this.toServer.println("");
            try {
                lineFromServer = this.fromServer.readLine();
            }
            catch (IOException ex) {
                Cutter.setLog("    Exception:Client.run() 1 \n" + ex.toString());
            }
            if (this.isHoudini && lineFromServer != null) {
                Monitor.setPanelText("hscript", lineFromServer.trim() + "\n");
            }
            if (lineFromServer == null) {
                Cutter.setLog("    Info:Client.run() A setting kill to true");
                this.kill = true;
            }
            if ((ext = BBxt.getWindowExtension()) != null && ext.equalsIgnoreCase(".mel")) {
                this.isMayaMel = true;
            } else if (ext != null && ext.equalsIgnoreCase(".py")) {
                this.isMayaPython = true;
            }
            while (!this.kill && lineFromServer != null) {
                try {
                    lineFromServer = this.fromServer.readLine();
                    String trimmed = lineFromServer.replaceAll("\\s", "");
                    if (this.isMayaMel || this.isMayaPython && lineFromServer.trim().length() > 0) {
                        if (lineFromServer.contains("Cannot find procedure \"Cutter\"")) {
                            String msg = "Connected to Maya on port " + this.serverPort;
                            String str1 = "To display output from Maya use the -eo flag.\n";
                            String str2 = "commandPort -eo -n \":2222\";";
                            if (this.isMayaMel) {
                                Monitor.setPanelText("Mel", msg);
                                Monitor.appendPanelText("Mel", str1);
                                Monitor.appendPanelText("Mel", str2);
                                continue;
                            }
                            if (!this.isMayaPython) continue;
                            Monitor.setPanelText("Python", msg);
                            Monitor.appendPanelText("Python", str1);
                            Monitor.appendPanelText("Python", str2);
                            continue;
                        }
                        Segment seg = SegmentUtils.toSegment(trimmed);
                        if (seg != null && (trimmed.length() != 1 || seg == null || seg.array[seg.offset] != '\u0000')) {
                            if (this.isMayaMel) {
                                Monitor.appendPanelText("Mel", lineFromServer + "\n");
                            } else if (this.isMayaPython) {
                                Monitor.appendPanelText("Python", lineFromServer + "\n");
                            }
                        }
                    }
                    if (!this.isHoudini) continue;
                    Monitor.setPanelText("hscript", lineFromServer.trim() + "\n");
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:Client.run() 2 \n" + ex.toString());
                }
            }
        }
        this.terminate();
    }

    private void sendString(String str) {
        if (str == null) {
            return;
        }
        if (this.toServer != null) {
            this.toServer.println(str);
            this.toServer.println("");
        } else {
            Cutter.setLog("    Error:Client.sendString() - the PrintStream named toServer is null.");
        }
    }

    public void sendMelString(String str) {
        if (str == null) {
            return;
        }
        this.sendString(str);
        this.isMayaMel = true;
        this.isMayaPython = false;
        Monitor.setPanelText("Mel", "");
    }

    public void sendPythonString(String str) {
        if (str == null) {
            return;
        }
        this.sendString(str);
        this.isMayaPython = true;
        this.isMayaMel = false;
        Monitor.setPanelText("Python", "");
    }

    public void sendHoudiniString(String str) {
        if (str == null) {
            return;
        }
        this.sendString(str);
        this.isHoudini = true;
        Monitor.setPanelText("Houdini", "");
    }

    public void writeBytes(byte[] buf, int offset, int len) {
        if (buf == null) {
            this.toServer.println();
            return;
        }
        this.toServer.write(buf, offset, len);
    }

    private void terminate() {
        Client.removeFromTable(this.serverAddress, this.serverPort);
        this.toServer.println("");
        this.toServer.flush();
        this.toServer.close();
        this.connected = false;
        try {
            this.fromServer.close();
            this.socket.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Client.terminate()\n" + e.toString());
        }
    }

    public static String getLocalIP() {
        String out = "unknown";
        try {
            out = InetAddress.getLocalHost().getHostAddress();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Client.getLocalIP()\n\t" + e.toString());
            out = "unknown";
        }
        return out;
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: KClient.getLocalHostName()\n" + e.toString());
            return "";
        }
    }

    static {
        try {
            Field[] fields = new Field[]{Client.class.getDeclaredField("_lineFromServer")};
            Cutter.addDebug(Client.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: Client.static - " + ex.toString());
        }
        error = null;
        tableOfOpenPorts = new Hashtable();
    }

    static class LogWindowListener
    implements VetoableChangeListener {
        LogWindowListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            String name = e.getPropertyName();
            Object value = e.getNewValue();
            if (name.equals("closed") && (Boolean)value == Boolean.TRUE) {
                Rectangle rect = clientWindow.getBounds();
                Preferences.write(Preferences.CLIENT_LOG_X, rect.x);
                Preferences.write(Preferences.CLIENT_LOG_Y, rect.y);
                Preferences.write(Preferences.CLIENT_LOG_WIDTH, rect.width);
                Preferences.write(Preferences.CLIENT_LOG_HEIGHT, rect.height);
                clientWindow = null;
            }
        }
    }
}

