/*
 * Decompiled with CFR 0.152.
 */
package ClientServer.ClientServer.client;

import ClientServer.ClientServer.client.Client;
import ClientServer.ClientServer.client.PortEvent;
import ClientServer.ClientServer.server.PackageHeader;
import UI_Desktop.Cutter;
import UI_Window.KWindow.KAbstractWindow;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Vector;

public class KClient
extends Client {
    public static boolean _lineFromServer = false;
    private int dataBuffered = 0;
    private Vector dataList = new Vector();
    private KAbstractWindow window = null;

    public KClient(String serverAddress, int serverPort, String sender, KAbstractWindow window) throws Exception {
        super(serverAddress, serverPort);
        this.localPortID = this.socket.getLocalPort();
        this.window = window;
        this.handShake();
    }

    @Override
    public void run() {
        String lineFromServer = "";
        while (!this.kill) {
            try {
                lineFromServer = this.fromServer.readLine();
                while (lineFromServer != null && !this.kill) {
                    if (_lineFromServer) {
                        Cutter.setLog("KClient.run lineFromServer = " + lineFromServer);
                    }
                    if (lineFromServer != null && lineFromServer.length() > 10) {
                        PortEvent event = new PortEvent();
                        event.sender = PackageHeader.sender(lineFromServer);
                        event.address = PackageHeader.address(lineFromServer);
                        event.dataType = PackageHeader.dataType(lineFromServer);
                        event.syntaxType = PackageHeader.syntaxType(lineFromServer);
                        String str = PackageHeader.getStringData(lineFromServer);
                        if (event.dataType == 8 && str != null) {
                            event.data = str.toString();
                            this.window.portMessage(event);
                        }
                    }
                    lineFromServer = this.fromServer.readLine();
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:KClient.run()\n" + e.toString());
            }
        }
        this.terminate();
    }

    public void send(String data) {
        this.send(data, true);
    }

    public void send(String data, boolean doDuplicate) {
        String[] str = new String[]{"STRING", data};
        this.sendData(str, doDuplicate, true);
    }

    public void send(String[] data) {
        this.send(data, true);
    }

    public void send(String[] data, boolean doDuplicate) {
        String[] str = new String[data.length + 1];
        str[0] = "STRING";
        int n = 1;
        int i = 0;
        while (n < str.length) {
            str[n] = "" + data[i];
            ++n;
            ++i;
        }
        this.sendData(str, doDuplicate, true);
    }

    public static String compact(String senderName, String senderIP, String[] data, boolean doDuplicate) {
        String compactedStr = PackageHeader.makeHeader(senderName, senderIP, doDuplicate, data[0], true);
        for (int n = 1; n < data.length; ++n) {
            compactedStr = n < data.length - 1 ? compactedStr + data[n] + '\u001c' : compactedStr + data[n];
        }
        return compactedStr;
    }

    private boolean handShake() {
        try {
            String lineFromServer = this.fromServer.readLine();
            if (lineFromServer.equalsIgnoreCase("HI")) {
                this.toServer.println("HI");
                this.toServer.println("");
                this.toServer.flush();
                return true;
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Error:KClient.handShake()\n" + e);
        }
        return false;
    }

    private void sendData(String[] data, boolean doDuplicate, boolean doCompact) {
        try {
            while (!this.connected) {
                this.lineFromServer = this.fromServer.readLine();
                this.connected = true;
            }
            this.toServer.println("DATA");
            if (doCompact) {
                String str = KClient.compact(this.sender, this.address, data, doDuplicate);
                if (str != null) {
                    this.toServer.println(str);
                }
            } else {
                for (int n = 0; n < data.length; ++n) {
                    this.toServer.println(PackageHeader.makeHeader(this.sender, this.address, doDuplicate, data[0], false));
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error: sendData()" + e);
        }
        this.toServer.println("");
    }

    public void requestData() {
        this.toServer.println("DATA_REQUEST");
        this.toServer.println("");
    }

    public String sendTCPCommand(String command) {
        try {
            while (!this.connected) {
                this.lineFromServer = this.fromServer.readLine();
                this.connected = true;
            }
            this.toServer.println(command);
            this.toServer.println("");
            this.lineFromServer = this.fromServer.readLine();
        }
        catch (IOException e) {
            System.out.println("Error: sendTCPCommand()" + e);
        }
        return this.lineFromServer;
    }

    public String sendHTTPGET() {
        try {
            while (!this.connected) {
                this.lineFromServer = this.fromServer.readLine();
                this.connected = true;
            }
            this.toServer.println("GET / HTTP/1.0");
            this.toServer.println("");
        }
        catch (IOException e) {
            System.out.println("Error: sendHTTPGET()" + e);
        }
        return this.lineFromServer;
    }

    private void sendName() {
        this.toServer.println("SENDER");
        this.toServer.println(this.sender);
        this.toServer.flush();
    }

    private void sendAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            this.toServer.println("ADDRESS");
            this.toServer.println(address.getHostAddress());
            this.toServer.flush();
        }
        catch (IOException e) {
            System.out.println("Error: sendAddress()");
        }
    }

    public String getSender() {
        return this.sender;
    }

    public String getAddress() {
        return this.address;
    }

    private void terminate() {
        this.toServer.println("CLOSE");
        this.toServer.println("");
        this.toServer.flush();
        this.toServer.close();
        this.connected = false;
        try {
            this.fromServer.close();
            this.socket.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KClient.terminate()\n" + e.toString());
        }
    }

    static {
        try {
            Field[] fields = new Field[]{KClient.class.getDeclaredField("_lineFromServer")};
            Cutter.addDebug(KClient.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KClient.static - " + ex.toString());
        }
    }
}

