/*
 * Decompiled with CFR 0.152.
 */
package ClientServer.ClientServer.server;

import ClientServer.ClientServer.client.Client;
import ClientServer.ClientServer.server.ListeningThread;
import ClientServer.ClientServer.server.PackageHeader;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KTextWindow;
import Utilities.TextUtils;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.Vector;
import javax.swing.JOptionPane;

public class KServer
extends Thread {
    public static boolean _sendTextToAll = false;
    public volatile boolean canListenForClients = false;
    private ServerSocket serverSocket = null;
    private int port;
    private KTextWindow textFrame;
    private static Vector<String> listOfAddresses;
    private static Vector<ListeningThread> listOfListeners;
    public static final int defaultPortID = 1024;
    public static final int IMMEDIATE = 1;
    public static final int BUFFERED = 2;
    public static boolean useSystemOut;
    private String ourIP = "";
    private StringBuffer stringBuffer = new StringBuffer(1024);

    public static void remove(ListeningThread l) {
        listOfListeners.removeElement(l);
    }

    public static void remove(String address) {
        for (int n = 0; n < listOfAddresses.size(); ++n) {
            String item = listOfAddresses.elementAt(n);
            if (!item.equals(address)) continue;
            listOfAddresses.removeElementAt(n);
            return;
        }
    }

    public KServer(int listeningPort, KTextWindow frame) throws Exception {
        super("KServer");
        this.textFrame = frame;
        try {
            this.serverSocket = new ServerSocket(listeningPort);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KServer.constructor()\n" + e.toString());
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The port \"" + listeningPort + "\" is already in use.\nChoose another port number and\ntry broadcasting again.", "Error -  Cannot act as a Server", 0);
            throw e;
        }
        this.canListenForClients = true;
        this.serverSocket.setReuseAddress(true);
    }

    public void stopAll() {
        for (int n = 0; n < listOfListeners.size(); ++n) {
            KServer.listOfListeners.elementAt((int)n).stop = true;
            listOfListeners.elementAt(n).doStop();
        }
    }

    public void shutdown() {
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exeception:KServer.shutdown()\n" + e.toString());
        }
        this.canListenForClients = false;
    }

    @Override
    public void run() {
        this.ourIP = Client.getLocalIP();
        listOfListeners.removeAllElements();
        try {
            Cutter.setLog("    Info: KServer.run() - opening ListeningThread to listen for clients");
            while (this.canListenForClients) {
                ListeningThread lt = new ListeningThread(this.serverSocket.accept(), this.textFrame);
                listOfListeners.addElement(lt);
                lt.start();
            }
            Cutter.setLog("    Info: KServer.run() - closing server socket");
            this.serverSocket.close();
            this.canListenForClients = false;
            for (int n = 0; n < listOfListeners.size(); ++n) {
                KServer.listOfListeners.elementAt((int)n).stop = true;
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: KServer.run() - " + e);
        }
    }

    public int sendTextToAll(String srctext, String syntaxListenerClassName) {
        String[] data = new String[2];
        String text = PackageHeader.setStringsData(srctext);
        String dataType = "STRINGS";
        String out = PackageHeader.makeHeader(BBxt.getWindowTitle(), this.ourIP, true, dataType, true, syntaxListenerClassName) + text;
        if (_sendTextToAll) {
            Cutter.setLog("KServer.sendTextToAll() - raw text: " + srctext);
            Cutter.setLog("As asci codes: " + TextUtils.toAsciRepresentation(srctext));
            Cutter.setLog("After conversion by PackageHeader.setStringsData(): " + text);
            Cutter.setLog("As asci codes: " + TextUtils.toAsciRepresentation(text));
            Cutter.setLog("Entire package: " + out);
        }
        for (int n = 0; n < listOfListeners.size(); ++n) {
            ListeningThread thread = listOfListeners.elementAt(n);
            thread.sendTextToClient(out);
            if (!useSystemOut) continue;
            System.out.println("KServer.sendTextToAll raw text = " + text + "\nKServer.sendTextToAll raw package = " + out);
        }
        return listOfListeners.size();
    }

    public static void addAddress(String address) {
        for (int n = 0; n < listOfAddresses.size(); ++n) {
            String item = listOfAddresses.elementAt(n);
            if (!item.equals(address)) continue;
            return;
        }
        listOfAddresses.addElement(address);
    }

    public Vector getClients() {
        return listOfAddresses;
    }

    static {
        try {
            Field[] fields = new Field[]{KServer.class.getDeclaredField("_sendTextToAll")};
            Cutter.addDebug(KServer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KServer.static - " + ex.toString());
        }
        listOfAddresses = new Vector();
        listOfListeners = new Vector();
        useSystemOut = false;
    }
}

