/*
 * Decompiled with CFR 0.152.
 */
package ClientServer.ClientServer.server;

import ClientServer.ClientServer.client.Client;
import ClientServer.ClientServer.server.KServer;
import ClientServer.ClientServer.server.PackageHeader;
import ClientServer.ClientServer.server.PortEvent;
import ClientServer.ClientServer.server.PortListener;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Window.KWindow.KAbstractTextWindow;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.Socket;

public class ListeningThread
extends Thread {
    public static boolean _sendTextToClient = false;
    public static boolean _lineFromServer = false;
    private static final int UNKNOWN = 0;
    private static final int DATA = 1;
    private static final int WAIT = 2;
    private static final int RESUME = 3;
    private static final int CLOSE = 4;
    private Socket socket = null;
    private Object applet;
    private int action = 0;
    private String ourName = "";
    private String ourIP = "";
    private boolean addAddress = true;
    private BufferedReader fromClient = null;
    private PrintStream toClient = null;
    private KAbstractTextWindow textFrame;
    public volatile boolean stop = false;

    public ListeningThread(Socket socket, KAbstractTextWindow frame) {
        super("ListeningThread");
        this.textFrame = frame;
        this.socket = socket;
        this.ourName = BBxt.getWindowTitle();
        this.ourIP = Client.getLocalIP();
    }

    public void doStop() {
        this.stop = true;
    }

    @Override
    public void run() {
        try {
            this.fromClient = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.toClient = new PrintStream(new BufferedOutputStream(this.socket.getOutputStream(), 1024), false);
            String clientAddress = "";
            this.toClient.println("HI");
            this.toClient.println("HI");
            this.toClient.flush();
            String lineFromClient = this.fromClient.readLine();
            while (lineFromClient != null && !this.stop) {
                if (_lineFromServer) {
                    Cutter.setLog("ListeningThread.run() - lineFromClient: " + lineFromClient);
                }
                if (lineFromClient.equals("DATA_REQUEST")) {
                    String text = PackageHeader.setStringsData(this.textFrame.getText());
                    String syntaxListenerName = this.textFrame.getTextPane().getSyntaxListenerClassName(this.textFrame.getTextPane());
                    if (syntaxListenerName == null) {
                        syntaxListenerName = "UNKNOWN_SYNTAX";
                    }
                    String dataType = "STRINGS";
                    String out = PackageHeader.makeHeader(BBxt.getWindowTitle(), this.ourIP, true, dataType, true, syntaxListenerName) + text;
                    this.sendTextToClient(out);
                } else if (lineFromClient.equals("DATA")) {
                    this.action = 1;
                } else if (lineFromClient.equals("WAIT")) {
                    this.action = 2;
                } else if (lineFromClient.equals("CLOSE")) {
                    this.action = 4;
                    this.stop = true;
                }
                switch (this.action) {
                    case 1: {
                        lineFromClient = this.fromClient.readLine();
                        this.sendPortEvent(lineFromClient);
                        if (this.addAddress) {
                            this.addAddress = false;
                            clientAddress = PackageHeader.address(lineFromClient);
                            KServer.addAddress(clientAddress);
                        }
                        this.action = 0;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                lineFromClient = this.fromClient.readLine();
            }
            this.fromClient.close();
            this.toClient.close();
            this.socket.close();
            KServer.remove(clientAddress);
            KServer.remove(this);
        }
        catch (Exception e) {
            if (this.socket != null) {
                Cutter.setLog("    Exception:ListeningThread.run()\n         " + e.toString() + "\n         socket.toString() = " + this.socket.toString());
            }
            Cutter.setLog("    Exception:ListeningThread.run()\n         " + e.toString() + "\n         socket is null!");
        }
    }

    public void sendTextToClient(String str) {
        if (_sendTextToClient) {
            Cutter.setLog("ListeningThread.sendTextToClient() sending: " + str);
        }
        if (this.toClient == null) {
            Cutter.setLog("    Error:sendTextToClient() - toClient is null");
            return;
        }
        this.toClient.println(str);
        this.toClient.println("");
        this.toClient.flush();
    }

    public void sendPortEvent(String lineFromClient) {
        if (lineFromClient == null) {
            return;
        }
        PortEvent event = new PortEvent();
        event.sender = PackageHeader.sender(lineFromClient);
        event.address = PackageHeader.address(lineFromClient);
        if (PackageHeader.dataType(lineFromClient) == 4) {
            event.dataType = 4;
            Point[] point = PackageHeader.getPointData(lineFromClient);
            if (point.length == 1) {
                event.data = point[0];
            }
            ((PortListener)this.applet).portMessage(event);
        } else if (PackageHeader.dataType(lineFromClient) == 6) {
            event.dataType = 6;
            Point[] point = PackageHeader.getPointData(lineFromClient);
            if (point != null) {
                for (int n = 0; n < point.length; ++n) {
                    event.data = point;
                }
            }
            ((PortListener)this.applet).portMessage(event);
        } else if (PackageHeader.dataType(lineFromClient) == 5) {
            event.dataType = 5;
            Color[] color = PackageHeader.getColorData(lineFromClient);
            if (color.length == 1) {
                event.data = color[0];
            }
            ((PortListener)this.applet).portMessage(event);
        } else if (PackageHeader.dataType(lineFromClient) == 1) {
            event.dataType = 1;
            String str = PackageHeader.getStringData(lineFromClient);
            if (str == null) {
                return;
            }
            event.data = str;
            ((PortListener)this.applet).portMessage(event);
        }
    }

    static {
        try {
            Field[] fields = new Field[]{ListeningThread.class.getDeclaredField("_sendTextToClient"), ListeningThread.class.getDeclaredField("_lineFromServer")};
            Cutter.addDebug(ListeningThread.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ListeningThread.static - " + ex.toString());
        }
    }
}

