/*
 * Decompiled with CFR 0.152.
 */
package ClientServer.ClientServer.server;

import UI_Desktop.Cutter;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PackageHeader {
    public static boolean _getStringData = false;
    public static final char BAR = '\u001c';
    public static final char NEWLINE = '\u0010';
    public static final int NUM_HEADER_ITEMS = 7;
    private static final int SENDER = 0;
    private static final int ADDRESS = 1;
    private static final int DUPLICATE = 2;
    private static final int DATA_TYPE = 3;
    private static final int COMPACT = 4;
    private static final int SYNTAX_TYPE = 5;
    private static final int BEGIN = 6;
    public static final int UNKNOWN = 0;
    public static final int STRING = 1;
    public static final int INT = 2;
    public static final int DOUBLE = 3;
    public static final int POINT = 4;
    public static final int COLOR = 5;
    public static final int POINTS = 6;
    public static final int COLORS = 7;
    public static final int STRINGS = 8;
    public static final int TC = 9;
    public static final String UNKNOWN_TYPE = "UNKNOWN";
    public static final String STRING_TYPE = "STRING";
    public static final String INT_TYPE = "INT";
    public static final String DOUBLE_TYPE = "DOUBLE";
    public static final String POINT_TYPE = "POINT";
    public static final String COLOR_TYPE = "COLOR";
    public static final String POINTS_TYPE = "POINTS";
    public static final String COLORS_TYPE = "COLORS";
    public static final String STRINGS_TYPE = "STRINGS";
    public static final String TC_TYPE = "TC";
    public static final String UNKNOWN_SYNTAX = "UNKNOWN_SYNTAX";
    public static final String RIB_SYNTAX = "RIB";
    public static final String SL_SYNTAX = "SL";
    public static final String HTML_SYNTAX = "HTML";
    public static final String MEL_SYNTAX = "MEL";
    public static final String CPP_SYNTAX = "CPP";
    public static final String JAVA_SYNTAX = "JAVA";
    public static final String C_SYNTAX = "C";
    public static final String TCL_SYNTAX = "TCL";
    public static final String VFL_SYNTAX = "VFL";
    private static StringBuffer out;

    private static String sender(String[] header) {
        return header[0];
    }

    private static String address(String[] header) {
        return header[1];
    }

    private static String duplication(String[] header) {
        return header[2];
    }

    private static int dataType(String[] header) {
        if (header[3].equals(STRING_TYPE)) {
            return 1;
        }
        if (header[3].equals(INT_TYPE)) {
            return 2;
        }
        if (header[3].equals(DOUBLE_TYPE)) {
            return 3;
        }
        if (header[3].equals(POINT_TYPE)) {
            return 4;
        }
        if (header[3].equals(COLOR_TYPE)) {
            return 5;
        }
        if (header[3].equals(POINTS_TYPE)) {
            return 6;
        }
        if (header[3].equals(COLORS_TYPE)) {
            return 7;
        }
        if (header[3].equals(TC_TYPE)) {
            return 9;
        }
        return 0;
    }

    private static boolean compaction(String[] header) {
        return header[4].equals("COMPACT_TRUE");
    }

    public static synchronized String sender(String data) {
        return PackageHeader.getHeader(data)[0];
    }

    public static synchronized String address(String data) {
        return PackageHeader.getHeader(data)[1];
    }

    public static synchronized boolean duplication(String data) {
        return PackageHeader.getHeader(data)[2].equals("DUP_TRUE");
    }

    public static synchronized int dataType(String data) {
        if (data == null || data.length() == 0) {
            return 0;
        }
        String[] header = PackageHeader.getHeader(data);
        if (header == null) {
            return 0;
        }
        if (header[3].equals(STRING_TYPE)) {
            return 1;
        }
        if (header[3].equals(INT_TYPE)) {
            return 2;
        }
        if (header[3].equals(DOUBLE_TYPE)) {
            return 3;
        }
        if (header[3].equals(POINT_TYPE)) {
            return 4;
        }
        if (header[3].equals(COLOR_TYPE)) {
            return 5;
        }
        if (header[3].equals(POINTS_TYPE)) {
            return 6;
        }
        if (header[3].equals(COLORS_TYPE)) {
            return 7;
        }
        if (header[3].equals(STRINGS_TYPE)) {
            return 8;
        }
        if (header[3].equals(TC_TYPE)) {
            return 9;
        }
        return 0;
    }

    public static synchronized boolean compaction(String input) {
        return PackageHeader.getHeader(input)[4].equals("COMPACT_TRUE");
    }

    public static synchronized String syntaxType(String data) {
        if (data == null || data.length() == 0) {
            return UNKNOWN_SYNTAX;
        }
        String[] header = PackageHeader.getHeader(data);
        if (header == null || header.length < 6) {
            return UNKNOWN_SYNTAX;
        }
        return header[5];
    }

    public static synchronized String getStringData(String input) {
        int bodyBegin = input.lastIndexOf(28) + 1;
        String s = input.substring(bodyBegin).replace('\u0010', '\n');
        if (_getStringData) {
            Cutter.setLog("PackageHeader.getStringData() input:\n\t" + input);
            Cutter.setLog("Extracted body text:\n" + s);
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public static synchronized String setStringsData(String text) {
        text = TextUtils.remove(text, '\r');
        text = text.replace('\n', '\u0010');
        return text;
    }

    public static Point[] getPointData(String input) {
        StringTokenizer tokenizer = new StringTokenizer(input, "\u001c");
        int numTokens = tokenizer.countTokens();
        Point[] point = new Point[numTokens - 7];
        for (int n = 0; n < numTokens; ++n) {
            String str = tokenizer.nextToken();
            if (n < 7) continue;
            StringTokenizer tok = new StringTokenizer(str);
            point[n - 7] = new Point();
            point[n - 7].x = Integer.parseInt(tok.nextToken());
            point[n - 7].y = Integer.parseInt(tok.nextToken());
        }
        return point;
    }

    public static Color[] getColorData(String input) {
        StringTokenizer tokenizer = new StringTokenizer(input, "\u001c");
        int numTokens = tokenizer.countTokens();
        Color[] color = new Color[numTokens - 7];
        for (int n = 0; n < numTokens; ++n) {
            String str = tokenizer.nextToken();
            if (n < 7) continue;
            StringTokenizer tok = new StringTokenizer(str);
            int red = Integer.parseInt(tok.nextToken());
            int green = Integer.parseInt(tok.nextToken());
            int blue = Integer.parseInt(tok.nextToken());
            color[n - 7] = new Color(red, green, blue);
        }
        return color;
    }

    public static String[] getData(String input, boolean singleItem) {
        StringTokenizer tokenizer = new StringTokenizer(input, "\u001c");
        int numTokens = tokenizer.countTokens();
        String[] token = new String[numTokens];
        boolean compacted = PackageHeader.compaction(input);
        for (int n = 0; n < numTokens; ++n) {
            token[n] = new String(tokenizer.nextToken());
        }
        if (singleItem) {
            String compStr = "";
            int numItems = numTokens - 7;
            for (int j = 0; j < numItems; ++j) {
                compStr = j < numItems - 1 ? compStr + token[j + 7] + '\u001c' : compStr + token[j + 7];
            }
            String[] out = new String[]{compStr};
            return out;
        }
        return token;
    }

    public static String[] getHeader(String input) {
        String[] header = new String[7];
        try {
            StringTokenizer tokenizer = new StringTokenizer(input, "\u001c");
            int numTokens = tokenizer.countTokens();
            if (numTokens == 0) {
                return null;
            }
            for (int i = 0; i < 7; ++i) {
                String token = tokenizer.nextToken();
                if (token == null) continue;
                header[i] = token;
            }
        }
        catch (NoSuchElementException e) {
            header = null;
        }
        return header;
    }

    public static boolean hasValidHeader(String input) {
        return PackageHeader.getHeader(input).length == 7;
    }

    public static String toString(String input) {
        String[] header = PackageHeader.getHeader(input);
        String output = "";
        for (int n = 0; n < header.length; ++n) {
            output = output + header[n] + "" + '\u001c';
        }
        return output;
    }

    public static String makeHeader(String sender, String address, boolean doDuplicate, String dataType, boolean isCompact) {
        return PackageHeader.makeHeader(sender, address, doDuplicate, dataType, isCompact, UNKNOWN_SYNTAX);
    }

    public static String makeHeader(String sender, String address, boolean doDuplicate, String dataType, boolean isCompact, String syntaxType) {
        if (doDuplicate) {
            if (isCompact) {
                return sender + '\u001c' + address + '\u001c' + "DUP_TRUE" + '\u001c' + dataType + '\u001c' + "COMPACT_TRUE" + '\u001c' + syntaxType + '\u001c' + "BEGIN" + '\u001c';
            }
            return sender + '\u001c' + address + '\u001c' + "DUP_TRUE" + '\u001c' + dataType + '\u001c' + "COMPACT_FALSE" + '\u001c' + syntaxType + '\u001c' + "BEGIN" + '\u001c';
        }
        if (isCompact) {
            return sender + '\u001c' + address + '\u001c' + "DUP_FALSE" + '\u001c' + dataType + '\u001c' + "COMPACT_TRUE" + '\u001c' + syntaxType + '\u001c' + "BEGIN" + '\u001c';
        }
        return sender + '\u001c' + address + '\u001c' + "DUP_FALSE" + '\u001c' + dataType + '\u001c' + "COMPACT_FALSE" + '\u001c' + syntaxType + '\u001c' + "BEGIN" + '\u001c';
    }

    static {
        try {
            Field[] fields = new Field[]{PackageHeader.class.getDeclaredField("_getStringData")};
            Cutter.addDebug(PackageHeader.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: PackageHeader.static - " + ex.toString());
        }
        out = new StringBuffer();
    }
}

