/*
 * Decompiled with CFR 0.152.
 */
package History;

import History.HistoryListener;
import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class KAbstractHistory {
    private String lastTime;
    protected static final String CUTTER_DATA_STR = "CutterData";
    protected static final String CUTTER_HISTORIES_DIR_STR = "cutter_history";
    protected static final String COMMENT_STR = "Cutter History Data";
    public static int GLOBAL_MAX_ITEMS = 50;
    public static int GLOBAL_MAX_BYTES = 32000;
    protected HistoryItem privateData = null;
    private Rectangle prevHistoryRect = null;
    protected String author_original = "";
    protected int maxByteSize = GLOBAL_MAX_BYTES;
    protected int maxListSize = GLOBAL_MAX_ITEMS;
    protected Vector<HistoryListener> listOfHistoryListeners = new Vector();
    protected Vector<HistoryItem> listOfHistories = new Vector();
    protected int marker = 0;
    protected KAbstractWindow srcWindow = null;

    public abstract void add(Object var1);

    public abstract String[] getItemAt(int var1);

    public abstract String[] getPrev();

    public abstract String[] getNext();

    public KAbstractHistory(KAbstractWindow w) {
        this.srcWindow = w;
        try {
            this.maxByteSize = Integer.parseInt(Preferences.get(Preferences.DOCUMENT_HISTORY_MAXBYTES));
            this.maxListSize = Integer.parseInt(Preferences.get(Preferences.DOCUMENT_HISTORY_MAXCOUNT));
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Exception: KAbstractHistory.constructor " + e.toString());
            this.maxByteSize = GLOBAL_MAX_BYTES;
            this.maxListSize = GLOBAL_MAX_ITEMS;
        }
    }

    public void preDispose() {
        this.srcWindow = null;
    }

    public String getCatalog(KAbstractWindow window) {
        if (window == null) {
            System.out.println("KAbstractHistory.getCatalog() source window is null");
            return "Catelog entries not available (1)";
        }
        StringBuffer data = new StringBuffer();
        data.append("author.original\t\t" + this.getAuthor() + "\n");
        File file = window.getFile();
        if (file != null) {
            data.append("src.directory \t\t" + file.getParent() + "\n");
            data.append("src.file\t\t" + file.getName() + "\n");
        }
        data.append("history.directory \t" + file.getParent() + "/" + CUTTER_HISTORIES_DIR_STR + "\n");
        data.append("history.file\t\t" + TextUtils.removeExtension(file.getName()) + ".zip\n");
        data.append("history.maxitems\t" + this.maxListSize + "\n");
        data.append("history.maxbytes\t" + this.maxByteSize + "\n");
        Rectangle wind = window == null ? null : window.getBounds();
        Font font = null;
        if (window != null) {
            if (!(window instanceof KAbstractTextWindow)) {
                return "Catelog entries not available (2)";
            }
            KTextPane tp = ((KAbstractTextWindow)window).getTextPane();
            if (tp == null) {
                return "Catelog entries not available (3)";
            }
            font = tp.getFont();
            if (font == null) {
                return "Catelog entries not available (4)";
            }
        }
        if (wind != null) {
            Rectangle rect;
            data.append("src.window.x\t\t" + wind.x + "\n");
            data.append("src.window.y\t\t" + wind.y + "\n");
            data.append("src.window.width\t" + wind.width + "\n");
            data.append("src.window.height\t" + wind.height + "\n");
            if (font != null) {
                data.append("src.window.font.name\t" + font.getName() + "\n");
                data.append("src.window.font.size\t" + font.getSize() + "\n");
                if (font.getStyle() == 1) {
                    data.append("src.window.font.style\tbold\n");
                } else {
                    data.append("src.window.font.style\tplain\n");
                }
            }
            if ((rect = window.getHistoryWindowRect()) != null) {
                data.append("history.window.x\t" + rect.x + "\n");
                data.append("history.window.y\t" + rect.y + "\n");
                data.append("history.window.width\t" + rect.width + "\n");
                data.append("history.window.height\t" + rect.height + "\n");
            }
            if (window instanceof KAbstractTextWindow) {
                int tabsize = ((KAbstractTextWindow)window).getTabSize();
                data.append("src.window.tab.size\t" + tabsize + "\n");
            }
            if (window instanceof KTextWindow) {
                boolean isvis = ((KTextWindow)window).lineNumberingIsVisible();
                int flag = isvis ? 1 : 0;
                data.append("src.window.numbering.visible\t" + flag + "\n");
                String spanStr = ((KTextWindow)window).getMarkedLineSpans();
                if (spanStr != null && spanStr.trim().length() > 0) {
                    data.append("src.window.numbering.spans\t" + spanStr + "\n");
                }
            }
        }
        return data.toString();
    }

    public int getByteSize() {
        int total = 0;
        for (int n = 0; n < this.listOfHistories.size(); ++n) {
            HistoryItem item = this.listOfHistories.elementAt(n);
            if (item == null) continue;
            total += item.bytesize();
        }
        return total;
    }

    public int getSize() {
        return this.listOfHistories.size();
    }

    public int getMaxBytes() {
        return this.maxByteSize;
    }

    public void setMaxBytes(int size) {
        this.maxByteSize = size;
        this.trimToByteSize(size);
    }

    public void trimToByteSize(int bytesize) {
        this.maxByteSize = bytesize;
        while (this.getByteSize() > bytesize && this.listOfHistories.size() != 1) {
            this.listOfHistories.removeElementAt(0);
        }
        this.marker = this.listOfHistories.size() - 1;
        this.notifyListeners();
    }

    public void clear() {
        this.listOfHistories.clear();
    }

    public boolean removeFromTo(String from, String to) {
        int t;
        int f;
        if (this.getSize() <= 1) {
            return false;
        }
        try {
            f = Integer.parseInt(from);
            t = Integer.parseInt(to);
            f = f < 1 ? 1 : f;
            int n = t = t > this.getSize() ? this.getSize() : t;
            if (f > t) {
                int temp = t;
                t = f;
                f = temp;
            }
            if (t >= this.getSize()) {
                t = this.getSize() - 1;
            }
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Error: KHistory.removeFromTo() from = >" + from + "< to = >" + to + "<");
            return false;
        }
        for (int n = f - 1; n <= t - 1; ++n) {
            this.listOfHistories.removeElementAt(f - 1);
        }
        this.marker = this.getSize() - 1;
        this.notifyListeners();
        return true;
    }

    public void setMaxCount(int count) {
        if (count >= 0) {
            this.maxListSize = count;
            while (this.getSize() > this.maxListSize && this.listOfHistories.size() != 1) {
                this.listOfHistories.removeElementAt(0);
            }
            this.marker = this.listOfHistories.size() - 1;
            this.notifyListeners();
        }
    }

    public int getMaxCount() {
        return this.maxListSize;
    }

    public int getMarker() {
        return this.marker;
    }

    public boolean isAvailable() {
        if (this.listOfHistories.size() < 1) {
            return false;
        }
        HistoryItem item = this.listOfHistories.elementAt(0);
        return item != null && item.getText() != null;
    }

    public static String getHistoryFileNameFrom(File file) {
        if (file == null) {
            return null;
        }
        String parentDir = file.getParent();
        File out = new File(parentDir, CUTTER_HISTORIES_DIR_STR);
        out = new File(out, file.getName() + ".zip");
        return out.getPath();
    }

    protected void parsePrivateData() {
    }

    private String getAuthor() {
        String temp = "unknown";
        if (this.author_original.equals("")) {
            temp = Preferences.get(Preferences.EMAIL_ADDRESS);
        }
        if (temp.trim().length() == 0) {
            return "unknown";
        }
        return temp.trim();
    }

    protected boolean saveToZip(File file, byte[][] data, String[] time) {
        String zippath = KAbstractHistory.getHistoryFileNameFrom(file);
        File zipfile = new File(zippath);
        boolean duplicateNotNeeded = true;
        if (zipfile.exists()) {
            byte[] b = FileUtils.readAsBinary(zipfile.getPath());
            String path = zipfile.getPath();
            path = TextUtils.removeExtension(path);
            path = path + "_backup.zip";
        }
        int totalBytes = 0;
        try {
            FileOutputStream filestream = new FileOutputStream(zipfile);
            ZipOutputStream zipstream = new ZipOutputStream(filestream);
            zipstream.setComment(COMMENT_STR);
            zipstream.setLevel(9);
            for (int n = 0; n < data.length; ++n) {
                String copy = TextUtils.replace(time[n], ':', "_");
                ZipEntry zipentry = new ZipEntry(copy);
                zipentry.setMethod(8);
                zipstream.putNextEntry(zipentry);
                totalBytes += data[n].length;
                zipstream.write(data[n], 0, data[n].length);
                zipstream.closeEntry();
            }
            zipstream.close();
            filestream.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: KAbstractHistory.saveToZip() " + e.toString());
            return false;
        }
        return true;
    }

    public boolean restore(File zipfile) {
        if (zipfile == null || !zipfile.exists()) {
            Cutter.setLog("    Info:KAbstractHistory.restory() zipfile is null or does not exist");
            return false;
        }
        int n = 1;
        Vector listOfEntries = new Vector();
        try {
            ZipFile zip = new ZipFile(zipfile.getPath());
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipentry = e.nextElement();
                String time = zipentry.getName();
                time = TextUtils.replace(time, '_', ":");
                byte[] bytedata = new byte[(int)zipentry.getSize()];
                InputStream inputstream = zip.getInputStream(zipentry);
                int len = 0;
                for (int offset = 0; offset < bytedata.length && (len = inputstream.read(bytedata, offset, bytedata.length - offset)) >= 0; offset += len) {
                }
                inputstream.close();
                HistoryItem item = null;
                try {
                    item = new HistoryItem(bytedata, time);
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:KAbstractHistory.restore() - from " + zipfile.getPath() + "\n        history was not added. An item had a duplicate time stamp.\n        " + ex.toString());
                }
                if (item != null) {
                    this.listOfHistories.addElement(item);
                }
                ++n;
            }
        }
        catch (IOException e) {
            Cutter.setLog("    Error: KAbstractHistory.restore()\n    " + zipfile.getPath() + "\n    " + e.toString());
            zipfile.delete();
            return false;
        }
        this.privateData = this.listOfHistories.lastElement();
        if (this.privateData.getTime().equals(CUTTER_DATA_STR)) {
            this.listOfHistories.removeElementAt(this.getSize() - 1);
            this.marker = this.marker > 0 ? this.marker - 1 : this.marker;
        }
        this.parsePrivateData();
        this.notifyListeners();
        return true;
    }

    public boolean getOpenPolicy() {
        return false;
    }

    protected static String getDateStamp() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer date = new StringBuffer();
        date.append(calendar.get(10) + ".");
        date.append(calendar.get(12) + "_");
        date.append(calendar.get(13) + "_");
        date.append(calendar.get(14));
        if (calendar.get(9) == 0) {
            date.append("am");
        } else {
            date.append("pm");
        }
        date.append(" ");
        date.append(calendar.get(2) + 1 + ".");
        date.append(calendar.get(5) + ".");
        date.append(calendar.get(1));
        return date.toString();
    }

    public void addListener(HistoryListener l) {
        this.listOfHistoryListeners.addElement(l);
    }

    public void removeListener(HistoryListener l) {
        this.listOfHistoryListeners.removeElement(l);
    }

    public void notifyListeners() {
        for (int n = 0; n < this.listOfHistoryListeners.size(); ++n) {
            HistoryListener l = this.listOfHistoryListeners.elementAt(n);
            if (l == null) continue;
            l.historyEvent();
        }
    }

    public class HistoryItem {
        private byte[] item;
        private String time;

        public HistoryItem(byte[] item) throws Exception {
            this.item = item;
            this.time = KAbstractHistory.getDateStamp();
            KAbstractHistory.this.lastTime = this.time;
        }

        public HistoryItem(byte[] item, String time) throws Exception {
            this.item = item;
            this.time = time;
            KAbstractHistory.this.lastTime = this.time;
        }

        public int bytesize() {
            return this.item.length;
        }

        public String getText() {
            return new String(this.item);
        }

        public byte[] getBytes() {
            return this.item;
        }

        public String getTime() {
            return this.time;
        }
    }
}

