/*
 * Decompiled with CFR 0.152.
 */
package History;

import History.KAbstractHistory;
import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.Rectangle;
import java.io.File;
import java.util.Vector;
import javax.swing.DesktopManager;

public class KTextHistoryDB
extends KAbstractHistory {
    private static Vector<KTextHistoryDB> freelist = new Vector();

    public static void restoreTextDocumentFromHistoryZipFile() {
        File[] zipfile = KAbstractDesktop.openFileChooser(new KFileFilter("zip", "Cutter History Document"));
        if (zipfile == null) {
            return;
        }
        new KTextWindow(zipfile[0]);
    }

    public static synchronized void put(KTextHistoryDB item) {
        item.listOfHistories.removeAllElements();
        item.listOfHistories = null;
        item.listOfHistories = new Vector();
        item.listOfHistoryListeners.removeAllElements();
        item.srcWindow = null;
        freelist.addElement(item);
    }

    public static synchronized KTextHistoryDB getInstance(KAbstractTextWindow window) {
        File zipfile = null;
        KTextHistoryDB historyItem = null;
        if (freelist.size() > 0) {
            historyItem = freelist.elementAt(0);
            freelist.removeElementAt(0);
        }
        if (window.getFile() != null) {
            zipfile = new File(KTextHistoryDB.getHistoryFileNameFrom(window.getFile()));
        }
        if (historyItem == null) {
            if (zipfile != null && zipfile.exists()) {
                return new KTextHistoryDB(zipfile, window);
            }
            return new KTextHistoryDB(window);
        }
        if (zipfile != null && zipfile.exists()) {
            historyItem.srcWindow = window;
            historyItem.restore(zipfile);
        }
        return historyItem;
    }

    public KTextHistoryDB() {
        super(null);
    }

    private KTextHistoryDB(KAbstractTextWindow w) {
        super(w);
    }

    private KTextHistoryDB(File zipfile, KAbstractTextWindow w) {
        super(w);
        this.restore(zipfile);
        this.marker = this.listOfHistories.size() - 1;
    }

    @Override
    public void add(Object src) {
        if ((String)src != null && ((String)src).trim().length() != 0) {
            try {
                this.maxByteSize = Integer.parseInt(Preferences.get(Preferences.DOCUMENT_HISTORY_MAXBYTES));
                this.maxListSize = Integer.parseInt(Preferences.get(Preferences.DOCUMENT_HISTORY_MAXCOUNT));
            }
            catch (NumberFormatException e) {
                Cutter.setLog("    Exception: KTextHistoryDB.add() - cannot get pref sizes for history size " + e.toString());
                this.maxByteSize = GLOBAL_MAX_BYTES;
                this.maxListSize = GLOBAL_MAX_ITEMS;
            }
            if (this.getByteSize() >= this.maxByteSize && this.getSize() >= this.maxListSize) {
                this.listOfHistories.removeElementAt(0);
                if (this.getByteSize() >= this.maxByteSize) {
                    Cutter.setLog("    Info: KTextHistoryDB.add() - not adding " + this.getByteSize() + " exceeds " + this.maxByteSize);
                } else {
                    Cutter.setLog("    Info: KTextHistoryDB.add() - not adding " + this.getSize() + " exceeds " + this.maxListSize);
                }
            }
            KAbstractHistory.HistoryItem item = null;
            try {
                item = new KAbstractHistory.HistoryItem(((String)src).getBytes());
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: KTextHistoryDB.add() - history not added " + e.toString());
            }
            if (item != null) {
                this.listOfHistories.addElement(item);
            }
            this.notifyListeners();
        }
    }

    public boolean save(KAbstractWindow window) {
        File parentDir;
        File historyDir;
        if (window == null) {
            return false;
        }
        if (this.getSize() == 0) {
            return false;
        }
        byte[][] bytedata = new byte[this.getSize() + 1][];
        String[] time = new String[this.getSize() + 1];
        for (int n = 0; n < this.getSize(); ++n) {
            String[] rawdata = this.getItemAt(n);
            if (rawdata.length > this.maxByteSize) continue;
            bytedata[n] = rawdata[0].getBytes();
            time[n] = rawdata[1];
        }
        byte[] pdata = this.getCatalog(window).getBytes();
        if (pdata != null) {
            bytedata[n] = pdata;
            time[n] = "CutterData";
        }
        if (!(historyDir = new File(parentDir = window.getFile().getParentFile(), "cutter_history")).exists()) {
            historyDir.mkdir();
        }
        return this.saveToZip(window.getFile(), bytedata, time);
    }

    public boolean saveTo(KAbstractWindow window, File anotherZipFile) {
        File parentDir;
        File historyDir;
        if (anotherZipFile == null || window == null) {
            Cutter.setLog("    Error: KHistory.saveTo(File) input parameters are null");
            return false;
        }
        if (this.getSize() == 0) {
            return false;
        }
        byte[][] bytedata = new byte[this.getSize() + 1][];
        String[] time = new String[this.getSize() + 1];
        for (int n = 0; n < this.getSize(); ++n) {
            String[] rawdata = this.getItemAt(n);
            bytedata[n] = rawdata[0].getBytes();
            time[n] = rawdata[1];
        }
        byte[] pdata = this.getCatalog(window).getBytes();
        if (pdata != null) {
            bytedata[n] = pdata;
            time[n] = "CutterData";
        }
        if (!(historyDir = new File(parentDir = window.getFile().getParentFile(), "cutter_history")).exists()) {
            historyDir.mkdir();
        }
        return this.saveToZip(anotherZipFile, bytedata, time);
    }

    @Override
    public String[] getItemAt(int n) {
        if (n >= this.getSize() - 1) {
            n = this.getSize() - 1;
        }
        if (n < 0) {
            return null;
        }
        KAbstractHistory.HistoryItem item = (KAbstractHistory.HistoryItem)this.listOfHistories.elementAt(n);
        if (item == null) {
            return null;
        }
        String[] out = new String[]{item.getText(), item.getTime(), new String("" + (this.marker + 1)), new String("" + this.getSize())};
        return out;
    }

    @Override
    public String[] getPrev() {
        if (this.marker - 1 >= 0) {
            --this.marker;
        }
        KAbstractHistory.HistoryItem item = (KAbstractHistory.HistoryItem)this.listOfHistories.elementAt(this.marker);
        String[] out = new String[]{item.getText(), item.getTime(), new String("" + (this.marker + 1)), new String("" + this.getSize())};
        return out;
    }

    @Override
    public String[] getNext() {
        if (this.marker + 1 <= this.listOfHistories.size() - 1) {
            ++this.marker;
        }
        KAbstractHistory.HistoryItem item = null;
        try {
            item = (KAbstractHistory.HistoryItem)this.listOfHistories.elementAt(this.marker);
            if (item == null) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Cutter.setLog("    Exception:KTextHistoryDB.getNext() " + ex.toString());
            this.notifyListeners();
            return null;
        }
        String[] out = new String[]{item.getText(), item.getTime(), new String("" + (this.marker + 1)), new String("" + this.getSize())};
        return out;
    }

    public String[] getLastItem() {
        this.marker = this.listOfHistories.size() - 1;
        KAbstractHistory.HistoryItem item = null;
        try {
            item = (KAbstractHistory.HistoryItem)this.listOfHistories.elementAt(this.marker);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:KTextHistoryDB.getLastItem()\n              " + ex.toString());
            item = null;
        }
        if (item == null) {
            return null;
        }
        String[] out = new String[]{item.getText(), item.getTime(), new String("" + (this.marker + 1)), new String("" + this.getSize())};
        return out;
    }

    @Override
    protected void parsePrivateData() {
        int fontSize;
        if (this.privateData == null) {
            return;
        }
        String str = this.privateData.getText();
        if (str == null) {
            Cutter.setLog("    Warning:KAbstractHistory.parsePrivateDataTo() - privateData.getText() returned null.");
            return;
        }
        String[] line = TextUtils.tokenize(str, "\n");
        if (line == null) {
            Cutter.setLog("    Warning:KAbstractHistory.parsePrivateDataTo() - TextUtils.tokenize(data) returned null.");
            return;
        }
        DesktopManager manager = KAbstractDesktop.getDesktopManager();
        boolean winx = false;
        boolean winy = false;
        boolean winwidth = false;
        boolean winheight = false;
        boolean hisx = false;
        boolean hisy = false;
        boolean hiswidth = false;
        boolean hisheight = false;
        Rectangle wind = new Rectangle();
        Rectangle hist = new Rectangle();
        int tabSize = 4;
        int numberingVisibility = 0;
        String numberSpansStr = null;
        String fontName = "Default";
        String fontStyle = "plain";
        try {
            fontSize = Integer.parseInt(Preferences.get(Preferences.TEXT_FONT_SIZE));
            fontStyle = Preferences.get(Preferences.TEXT_FONT_WEIGHT);
            for (int n = 0; n < line.length; ++n) {
                String[] token = TextUtils.tokenize(line[n]);
                if (token == null || token.length != 2) continue;
                if (token[0].equals("src.window.x")) {
                    winx = true;
                    wind.x = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("src.window.y")) {
                    winy = true;
                    wind.y = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("src.window.width")) {
                    winwidth = true;
                    wind.width = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("src.window.height")) {
                    winheight = true;
                    wind.height = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.window.x")) {
                    hisx = true;
                    hist.x = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.window.y")) {
                    hisy = true;
                    hist.y = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.window.width")) {
                    hiswidth = true;
                    hist.width = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.window.height")) {
                    hisheight = true;
                    hist.height = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.maxitems")) {
                    this.maxListSize = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("history.maxbytes")) {
                    this.maxByteSize = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("author.original")) {
                    this.author_original = token[1];
                    continue;
                }
                if (token[0].equals("src.window.font.size")) {
                    fontSize = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("src.window.font.style")) {
                    fontStyle = token[1];
                    continue;
                }
                if (token[0].equals("src.window.font.name")) {
                    fontName = token[1];
                    continue;
                }
                if (token[0].equals("src.window.tab.size")) {
                    tabSize = Integer.parseInt(token[1]);
                    continue;
                }
                if (token[0].equals("src.window.numbering.visible")) {
                    numberingVisibility = Integer.parseInt(token[1]);
                    continue;
                }
                if (!token[0].equals("src.window.numbering.spans")) continue;
                numberSpansStr = token[1];
            }
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Exception:KAbstractHistory.parsePrivateData()" + e);
            return;
        }
        if (this.srcWindow == null) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Info:KAbstractHistory.parsePrivateDataTo() - srcWindow is null, therefore, not setting window data");
            }
            return;
        }
        if (winx && winy && winwidth && winheight) {
            this.srcWindow.resizeFrameTo(wind);
        }
        if (hisx && hisy && hiswidth && hisheight) {
            this.srcWindow.setHistoryWindowRect(hist);
        }
        if (this.srcWindow instanceof KTextWindow) {
            ((KTextWindow)this.srcWindow).setFontSize(fontSize);
            ((KTextWindow)this.srcWindow).setFontStyle(fontStyle);
            ((KTextWindow)this.srcWindow).setFontName(fontName);
            ((KTextWindow)this.srcWindow).setTabSize(tabSize);
            KTextPane textpane = ((KTextWindow)this.srcWindow).getTextPane();
            if (textpane != null) {
                textpane.setTabSize(tabSize);
            }
            if (numberingVisibility == 1) {
                ((KTextWindow)this.srcWindow).initLineNumberingVisibility(true);
            } else {
                ((KTextWindow)this.srcWindow).initLineNumberingVisibility(false);
            }
            if (numberSpansStr != null && numberSpansStr.trim().length() > 0) {
                ((KTextWindow)this.srcWindow).setMarkedLineSpans(numberSpansStr);
            }
        }
    }
}

