/*
 * Decompiled with CFR 0.152.
 */
package Preferences;

import Preferences.Cereal;
import Preferences.Preferences;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;

public class CerealRegistry
implements Serializable {
    public static final String WIN_CEREALS_DIRNAME = "win_cereals";
    public static final String LINUX_CEREALS_DIRNAME = "linux_cereals";
    public static final String OSX_CEREALS_DIRNAME = "osx_cereals";
    public static File currentOSCerealDir = null;
    private static Vector<Cereal> listOfCereals;

    public static synchronized void add(Cereal cereal) {
        for (int n = 0; n < listOfCereals.size(); ++n) {
            Cereal item = listOfCereals.elementAt(n);
            if (!item.getCerealName().equals(cereal.getCerealName())) continue;
            return;
        }
        listOfCereals.addElement(cereal);
    }

    public static synchronized void write() {
        for (int n = 0; n < listOfCereals.size(); ++n) {
            Cereal cereal = listOfCereals.elementAt(n);
            cereal.serializeSelf();
        }
    }

    static {
        File prefsDir = Preferences.prefsBaseDir;
        currentOSCerealDir = EnvUtils.isOSXEnvironment() ? new File(prefsDir, OSX_CEREALS_DIRNAME) : (EnvUtils.isWinEnvironment() ? new File(prefsDir, WIN_CEREALS_DIRNAME) : new File(prefsDir, LINUX_CEREALS_DIRNAME));
        if (!currentOSCerealDir.exists()) {
            FileUtils.makeDirectories(currentOSCerealDir);
        }
        listOfCereals = new Vector();
    }
}

