/*
 * Decompiled with CFR 0.152.
 */
package Preferences;

import ClientServer.ClientServer.client.Client;
import Preferences.LinuxPrefs;
import Preferences.OSXPrefs;
import Preferences.PreferencesListener;
import Preferences.WinPrefs;
import UI_Desktop.Cutter;
import UI_Script.Help.Url;
import UI_Script.Rib.RibTokenizer;
import UI_Window.KWindow.LogFrame;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;

public class Preferences
extends RibTokenizer {
    public static String OLD_PREFS_NAME = "cutter_prefs.ini";
    public static String PREFS_NAME = "cutter_prefs.ini";
    public static String PREFS_BACKUP_NAME = "cutter_prefs_backup.ini";
    public static String TMP_PREFS_BACKUP_NAME = "tmp.ini";
    private static Hashtable<String, String> table = new Hashtable();
    public static String name;
    public static final int UNKNOWN = 0;
    public static int minSize;
    public static final char SEPARATOR = '\u0010';
    public static final char SUBSTITUTE_BACKSLASH = '\u001d';
    public static final char SUBSTITUTE_QUOTATION = '\u001f';
    public static final char DUMMY_QUOTATION = '\u0081';
    private static int n;
    public static final int DESKTOP_BOUNDS;
    public static final int DESKTOP_DOCUMENT_LAYOUT;
    public static final int TOOL_RENDERMAN;
    public static final int TOOL_RENDERMAN_POSITION;
    public static final int TOOL_RENDERMAN_TEXTURE;
    public static final int TOOL_RENDERMAN_TEXTURE_POSITION;
    public static final int TOOL_RENDERMAN_TEXTURE_RECENT_PATHS;
    public static final int TOOL_RENDERMAN_PLACECAMERA;
    public static final int TOOL_RENDERMAN_PLACECAMERA_POSITION;
    public static final int TOOL_RENDERMAN_PLACECAMERA_YUP_FROMTO;
    public static final int TOOL_RENDERMAN_PLACECAMERA_ZUP_FROMTO;
    public static final int TOOL_RENDERMAN_QTVR;
    public static final int TOOL_RENDERMAN_QTVR_POSITION;
    public static final int TOOL_MATRIX;
    public static final int TOOL_MATRIX_POSITION;
    public static final int TOOL_DIRECTORY;
    public static final int TOOL_DIRECTORY_POSITION;
    public static final int TOOL_FIND;
    public static final int TOOL_FIND_POSITION;
    public static final int TOOL_FIND_SRC_DATA;
    public static final int TOOL_FIND_DEST_DATA;
    public static final int TOOL_FIND_BATCH_MODE;
    public static final int TOOL_FIND_BATCH_RECURSIVE;
    public static final int TOOL_SHAKE;
    public static final int TOOL_SHAKE_POSITION;
    public static final int TOOL_JAVA;
    public static final int TOOL_JAVA_POSITION;
    public static final int TOOL_C;
    public static final int TOOL_C_POSITION;
    public static final int TOOL_HTML;
    public static final int TOOL_HTML_POSITION;
    public static final int TOOL_PERL;
    public static final int TOOL_PERL_POSITION;
    public static final int TOOL_PREFS;
    public static final int TOOL_PREFS_POSITION;
    public static final int TOOL_HTML_SEARCH;
    public static final int TOOL_HTML_SEARCH_POSITION;
    public static final int TOOL_HTML_SEARCH_STRING;
    public static final int TOOL_HTML_SEARCH_PATH;
    public static final int TOOL_HTML_SEARCH_USER_DOCS;
    public static final int TOOL_HTML_SEARCH_RECURSE;
    public static final int TOOL_LPE;
    public static final int TOOL_LPE_POSITION;
    public static final int TOOL_LPE_WIDTH;
    public static final int TOOL_LPE_HEIGHT;
    public static final int TOOL_TIMEOUT;
    public static final int TOOL_TIMEOUT_POSITION;
    public static final int TOOL_TIMEOUT_PERIOD;
    public static final int TOOL_JOURNAL;
    public static final int TOOL_JOURNAL_POSITION;
    public static final int TOOL_JOURNAL_DIRECTORY;
    public static final int TOOL_JOURNAL_FAVORITES;
    public static final int TOOL_REMOTEBUILD;
    public static final int TOOL_REMOTEBUILD_POSITION;
    public static final int TOOL_REMOTEBUILD_SRC_CPP;
    public static final int TOOL_REMOTEBUILD_SRC_H;
    public static final int TOOL_REMOTEBUILD_SRC_ARGS;
    public static final int TOOL_REMOTEBUILD_ENABLED_IP_1;
    public static final int TOOL_REMOTEBUILD_DST_IP_1;
    public static final int TOOL_REMOTEBUILD_DST_CPP_DIR_1;
    public static final int TOOL_REMOTEBUILD_DST_H_DIR_1;
    public static final int TOOL_REMOTEBUILD_DST_ARGS_DIR_1;
    public static final int TOOL_REMOTEBUILD_WRITE_1;
    public static final int TOOL_REMOTEBUILD_ENABLED_IP_2;
    public static final int TOOL_REMOTEBUILD_DST_IP_2;
    public static final int TOOL_REMOTEBUILD_DST_CPP_DIR_2;
    public static final int TOOL_REMOTEBUILD_DST_H_DIR_2;
    public static final int TOOL_REMOTEBUILD_DST_ARGS_DIR_2;
    public static final int TOOL_REMOTEBUILD_WRITE_2;
    public static final int TOOL_DSO_SERVER;
    public static final int TOOL_DSO_SERVER_POSITION;
    public static final int TOOL_DSO_SERVER_DROPBOX_PATH;
    public static final int TOOL_DSO_SERVER_COMPILATION_PATH;
    public static final int TOOL_FTPSEND;
    public static final int TOOL_FTPSEND_POSITION;
    public static final int TOOL_FTPSEND_HOSTNAME;
    public static final int TOOL_FTPSEND_USERNAME;
    public static final int TOOL_FTPSEND_USERPASS;
    public static final int TOOL_FTPSEND_LOCAL_PWD;
    public static final int TOOL_FTPSEND_FILENAME;
    public static final int TOOL_FTPSEND_HOST_PWD;
    public static final int TOOL_FTPSEND_SEND_AS_HTML;
    public static final int TOOL_FTPSEND_SEND_AS_INDEX_HTML;
    public static final int TOOL_MOVER;
    public static final int TOOL_MOVER_POSITION;
    public static final int TOOL_MOVER_TAB1_SRC_DIR;
    public static final int TOOL_MOVER_TAB1_DEST_DIR;
    public static final int TOOL_MOVER_TAB1_MAX_DIR_SIZE;
    public static final int TOOL_MOVER_TAB1_MAX_FILE_SIZE;
    public static final int TOOL_MOVER_TAB1_NAME;
    public static final int TOOL_MOVER_TAB2_SRC_DIR;
    public static final int TOOL_MOVER_TAB2_DEST_DIR;
    public static final int TOOL_MOVER_TAB2_MAX_DIR_SIZE;
    public static final int TOOL_MOVER_TAB2_MAX_FILE_SIZE;
    public static final int TOOL_MOVER_TAB2_NAME;
    public static final int TOOL_MOVER_TAB3_SRC_DIR;
    public static final int TOOL_MOVER_TAB3_DEST_DIR;
    public static final int TOOL_MOVER_TAB3_MAX_DIR_SIZE;
    public static final int TOOL_MOVER_TAB3_MAX_FILE_SIZE;
    public static final int TOOL_MOVER_TAB3_NAME;
    public static final int TOOL_MOVER_TAB4_SRC_DIR;
    public static final int TOOL_MOVER_TAB4_DEST_DIR;
    public static final int TOOL_MOVER_TAB4_MAX_DIR_SIZE;
    public static final int TOOL_MOVER_TAB4_MAX_FILE_SIZE;
    public static final int TOOL_MOVER_TAB4_NAME;
    public static final int TOOL_MOVER_TAB5_SRC_DIR;
    public static final int TOOL_MOVER_TAB5_DEST_DIR;
    public static final int TOOL_MOVER_TAB5_MAX_DIR_SIZE;
    public static final int TOOL_MOVER_TAB5_MAX_FILE_SIZE;
    public static final int TOOL_MOVER_TAB5_NAME;
    public static final int WINDOW_LOG;
    public static final int WINDOW_LOG_POSITION;
    public static final int WINDOW_LOG_MAX_CHARS;
    public static final int TOOL_TABWINDOWS;
    public static final int TOOL_TABWINDOWS_POSITION;
    public static final int TOOL_ZIPPER;
    public static final int TOOL_ZIPPER_POSITION;
    public static final int TOOL_ZIPPER_ZIP_MAX_FILE_SIZE;
    public static final int TOOL_ZIPPER_ZIP_EXT_FILTERS;
    public static final int TOOL_ZIPPER_ZIP_FOLDERS_FILTER;
    public static final int TOOL_NET;
    public static final int TOOL_NET_POSITION;
    public static final int TOOL_NET_SENDFILES_FILE_STATES;
    public static final int TOOL_NET_SENDFILES_IP_STATES;
    public static final int TOOL_SCRIPT_CATALOGER;
    public static final int TOOL_SCRIPT_CATALOGER_POSITION;
    public static final int TOOL_SCRIPT_CATALOGER_SRC_DIR_PATH;
    public static final int TOOL_SCRIPT_CATALOGER_DST_DIR_PATH;
    public static final int TOOL_SCRIPT_CATALOGER_RECURSE;
    public static final int TOOL_RUNBAT;
    public static final int TOOL_RUNBAT_POSITION;
    public static final int TOOL_XPM;
    public static final int TOOL_XPM_POSITION;
    public static final int TOOL_XPM_FILES_OPEN;
    public static final int TOOL_RIF;
    public static final int TOOL_RIF_POSITION;
    public static final int TOOL_RIF_PATHS;
    public static final int TOOL_RIF_ARGS;
    public static final int TOOL_RIF_ENABLE;
    public static final int TOOL_RIF_RIBIN_PATH;
    public static final int TOOL_RIF_RIBOUT_PATH;
    public static final int TOOL_CCOMPILER;
    public static final int TOOL_CCOMPILER_POSITION;
    public static final int TOOL_CCOMPILER_INCLUDES;
    public static final int TOOL_CCOMPILER_LIBRARIES;
    public static final int TOOL_MONITOR_FONT_SIZE;
    public static final int TOOL_MONITOR_FONT_STYLE;
    public static final int TOOL_MONITOR_LOGFILE_WRITE;
    public static final int TOOL_SESSION;
    public static final int TOOL_SESSION_POSITION;
    public static final int RENDERER_DEFAULT;
    public static final int RENDERER_SHADOW_SIZE;
    public static final int RENDERER_SHADER_DATATYPE;
    public static final int RENDERER_SHADERS_CACHE;
    public static final int KEYFRAMER_RIB_SINGLE;
    public static final int PATH_USER_FRAMES;
    public static final int PATH_USER_RSL_SOURCE;
    public static final int PATH_USER_SHADERS;
    public static final int PATH_USER_TEXTURES;
    public static final int PATH_USER_ARCHIVES;
    public static final int PATH_USER_RIBS;
    public static final int PATH_USER_PTC;
    public static final int PATH_USER_BKM;
    public static final int PATH_USER_CPM;
    public static final int _PATH_PIXAR_BIN;
    public static final int PATH_PIXAR_SHADERS;
    public static final int PATH_PIXAR_TEXTURES;
    public static final int PIXAR_COMPILER_FLAGS_USER;
    public static final int PIXAR_RENDER_FLAGS_USER;
    public static final int PIXAR_COMPILER_FLAGS_USER_ENABLED;
    public static final int PIXAR_RENDER_FLAGS_USER_ENABLED;
    public static final int PIXAR_RENDER_RISMODE;
    public static final int PATH_PIXAR_RMS;
    public static final int PATH_PIXAR_RMS_DOCS_INDEX;
    public static final int PATH_PIXAR_PROSERVER;
    public static final int PATH_PIXAR_RENDERMAN_LEGACY_DOCS_INDEX;
    public static final int PATH_PIXAR_RENDERMAN_DOCS_INDEX;
    public static final int PATH_PIXAR_DOCS_SHADERS;
    public static final int PATH_PIXAR_DOCS_SHADERS_TOC;
    public static final int PATH_PIXAR_DOCS_SHADERS_EXT;
    public static final int PATH_PIXAR_DOCS_EXT;
    public static final int PATH_DEVKIT_PIXAR;
    public static final int PATH_DEVKIT_USER_INCLUDE_DIRECTORIES;
    public static final int PATH_DEVKIT_USER_LIB_DIRECTORIES;
    public static final int PATH_DEVKIT_USER_LIBS;
    public static final int PATH_DEVKIT_USER_OBJS;
    public static final int DEVKIT_USER_FLAGS;
    public static final int PIXAR_DEVKIT_PATTERN_BUILD_PATH;
    public static final int PIXAR_DEVKIT_BXDF_BUILD_PATH;
    public static final int PIXAR_DEVKIT_DISP_BUILD_PATH;
    public static final int PIXAR_DEVKIT_FILTERS_BUILD_PATH;
    public static final int PIXAR_DEVKIT_INTG_BUILD_PATH;
    public static final int PIXAR_DEVKIT_PROJ_BUILD_PATH;
    public static final int PIXAR_DEVKIT_RIF_BUILD_PATH;
    public static final int PIXAR_DEVKIT_PROCEDURAL_BUILD_PATH;
    public static final int PIXAR_DEVKIT_EXE_BUILD_PATH;
    public static final int CPP_MAKEFILE_CLEANUP;
    public static final int PIXAR_DEVKIT_POSTBUILD_SCRIPTNAME;
    public static final int PIXAR_DEVKIT_POST_BUILD_SCRIPTMODE;
    public static final int DEVKIT_VARYING_POINTER_PREFIX;
    public static final int DEVKIT_VARYING_POINTER_SUFFIX;
    public static final int DEVKIT_UNIFORM_POINTER_PREFIX;
    public static final int DEVKIT_UNIFORM_POINTER_SUFFIX;
    public static final int PATH_USER_PLUGINS;
    public static final int PATH_USER_ARGS;
    public static final int PATH_USER_RFM_INI;
    public static final int EXE_PIXAR_RENDER;
    public static final int EXE_PIXAR_COMPILE;
    public static final int EXE_PIXAR_SHADER_INFO;
    public static final int EXE_PIXAR_TEXTURE_MAKE;
    public static final int EXTENSION_PIXAR_SHADER;
    public static final int PATH_OSL_COMPILER_BIN;
    public static final int PATH_USER_OSL_SOURCE;
    public static final int PATH_USER_OSL_SHADERS;
    public static final int PATH_ARNOLD_BIN;
    public static final int PATH_USER_ARNOLD_OSL_SOURCE;
    public static final int PATH_USER_ARNOLD_OSL_SHADERS;
    public static final int PATH_USER_ARNOLD_OSL_INCLUDES;
    public static final int PATH_USER_ARNOLD_OSO_MTD_DUPLICATION;
    public static final int ARNOLD_DO_OSO_MTD_DUPLICATION;
    public static final int ARNOLD_OSL_MTD_STYLE;
    public static final int PATH_VRAY_BIN;
    public static final int PATH_USER_VRAY_OSL_SOURCE;
    public static final int PATH_USER_VRAY_OSL_SHADERS;
    public static final int OSL_COMPILE_KEYBOARD_SHORTCUT;
    public static final int PATH_BMRT_BIN;
    public static final int PATH_BMRT_SHADERS;
    public static final int PATH_BMRT_TEXTURES;
    public static final int BMRT_COMPILER_FLAGS_USER;
    public static final int BMRT_RENDER_FLAGS_USER;
    public static final int BMRT_COMPILER_FLAGS_USER_ENABLED;
    public static final int BMRT_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_BMRT_DOCS_SHADERS;
    public static final int PATH_BMRT_DOCS_SHADERS_TOC;
    public static final int PATH_BMRT_DOCS_SHADERS_EXT;
    public static final int EXE_BMRT_RENDER;
    public static final int EXE_BMRT_COMPILE;
    public static final int EXE_BMRT_SHADER_INFO;
    public static final int EXE_BMRT_TEXTURE_MAKE;
    public static final int EXTENSION_BMRT_SHADER;
    public static final int PATH_AIR_BIN;
    public static final int PATH_AIR_SHADERS;
    public static final int PATH_AIR_TEXTURES;
    public static final int AIR_COMPILER_FLAGS_USER;
    public static final int AIR_RENDER_FLAGS_USER;
    public static final int AIR_COMPILER_FLAGS_USER_ENABLED;
    public static final int AIR_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_AIR_DOCS_SHADERS;
    public static final int PATH_AIR_DOCS_SHADERS_TOC;
    public static final int PATH_AIR_DOCS_SHADERS_EXT;
    public static final int EXE_AIR_RENDER;
    public static final int EXE_AIR_COMPILE;
    public static final int EXE_AIR_SHADER_INFO;
    public static final int EXE_AIR_TEXTURE_MAKE;
    public static final int EXTENSION_AIR_SHADER;
    public static final int PATH_3DELIGHT_BIN;
    public static final int PATH_3DELIGHT_SHADERS;
    public static final int PATH_3DELIGHT_TEXTURES;
    public static final int DELIGHT_COMPILER_FLAGS_USER;
    public static final int DELIGHT_RENDER_FLAGS_USER;
    public static final int DELIGHT_COMPILER_FLAGS_USER_ENABLED;
    public static final int DELIGHT_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_3DELIGHT_DOCS_SHADERS;
    public static final int PATH_3DELIGHT_DOCS_SHADERS_TOC;
    public static final int PATH_3DELIGHT_DOCS_SHADERS_EXT;
    public static final int EXE_3DELIGHT_RENDER;
    public static final int EXE_3DELIGHT_COMPILE;
    public static final int EXE_3DELIGHT_SHADER_INFO;
    public static final int EXE_3DELIGHT_TEXTURE_MAKE;
    public static final int EXTENSION_3DELIGHT_SHADER;
    public static final int PATH_PIXIE_BIN;
    public static final int PATH_PIXIE_SHADERS;
    public static final int PATH_PIXIE_TEXTURES;
    public static final int PIXIE_COMPILER_FLAGS_USER;
    public static final int PIXIE_RENDER_FLAGS_USER;
    public static final int PIXIE_COMPILER_FLAGS_USER_ENABLED;
    public static final int PIXIE_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_PIXIE_DOCS_SHADERS;
    public static final int PATH_PIXIE_DOCS_SHADERS_TOC;
    public static final int PATH_PIXIE_DOCS_SHADERS_EXT;
    public static final int EXE_PIXIE_RENDER;
    public static final int EXE_PIXIE_COMPILE;
    public static final int EXE_PIXIE_SHADER_INFO;
    public static final int EXE_PIXIE_TEXTURE_MAKE;
    public static final int EXTENSION_PIXIE_SHADER;
    public static final int PATH_AQSIS_BIN;
    public static final int PATH_AQSIS_SHADERS;
    public static final int PATH_AQSIS_TEXTURES;
    public static final int AQSIS_COMPILER_FLAGS_USER;
    public static final int AQSIS_RENDER_FLAGS_USER;
    public static final int AQSIS_COMPILER_FLAGS_USER_ENABLED;
    public static final int AQSIS_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_AQSIS_DOCS_SHADERS;
    public static final int PATH_AQSIS_DOCS_SHADERS_TOC;
    public static final int PATH_AQSIS_DOCS_SHADERS_EXT;
    public static final int EXE_AQSIS_RENDER;
    public static final int EXE_AQSIS_COMPILE;
    public static final int EXE_AQSIS_SHADER_INFO;
    public static final int EXE_AQSIS_TEXTURE_MAKE;
    public static final int EXTENSION_AQSIS_SHADER;
    public static final int PATH_RENDERER_CUSTOM_NAME;
    public static final int PATH_RENDERER_CUSTOM_BIN;
    public static final int PATH_RENDERER_CUSTOM_SHADERS;
    public static final int PATH_RENDERER_CUSTOM_TEXTURES;
    public static final int RENDERMAN_CUSTOM_COMPILER_FLAGS_USER;
    public static final int RENDERMAN_CUSTOM_RENDER_FLAGS_USER;
    public static final int RENDERMAN_CUSTOM_COMPILER_FLAGS_USER_ENABLED;
    public static final int RENDERMAN_CUSTOM_RENDER_FLAGS_USER_ENABLED;
    public static final int PATH_RENDERER_CUSTOM_DOCS_SHADERS;
    public static final int PATH_RENDERER_CUSTOM_DOCS_SHADERS_TOC;
    public static final int PATH_RENDERER_CUSTOM_DOCS_SHADERS_EXT;
    public static final int EXE_RENDERER_CUSTOM_RENDER;
    public static final int EXE_RENDERER_CUSTOM_COMPILE;
    public static final int EXE_RENDERER_CUSTOM_SHADER_INFO;
    public static final int EXE_RENDERER_CUSTOM_TEXTURE_MAKE;
    public static final int EXTENSION_RENDERER_CUSTOM_SHADER;
    public static final int EMAIL_ADDRESS;
    public static final int SMTP_SERVER;
    public static final int SMTP_PORT;
    public static final int MAYA_PEER_ADDRESS;
    public static final int MAYA_PEER_PORT;
    public static final int CUTTER_CLIENT_ADDRESS;
    public static final int CUTTER_CLIENT_PORT;
    public static final int HOUDINI_PEER_ADDRESS;
    public static final int HOUDINI_PEER_PORT;
    public static final int TCP_LISTENER_PORT;
    public static final int TCP_TIMEOUT;
    public static final int CLIENT_LOG_X;
    public static final int CLIENT_LOG_Y;
    public static final int CLIENT_LOG_WIDTH;
    public static final int CLIENT_LOG_HEIGHT;
    public static final int WEB_BROWSER_PREFERRED;
    public static final int HTML_AUTO_CORRECT_IMAGE_NAMES;
    public static final int TOOL_RENDERMAN_QTVR_COLUMNS;
    public static final int TOOL_RENDERMAN_QTVR_ROWS;
    public static final int TOOL_RENDERMAN_QTVR_STARTVP;
    public static final int TOOL_RENDERMAN_QTVR_ENDVP;
    public static final int FRAME_COUNT;
    public static final int FRAME_SIZE;
    public static final int FRAME_NAME;
    public static final int TOOL_RENDERMAN_PRECISION_DECIMALPLACES;
    public static final int TOOL_RENDERMAN_LOG_FILE;
    public static final int TOOL_RENDERMAN_SLIM_FILE;
    public static final int TOOL_RENDERMAN_SLIM_SLO_COPY;
    public static final int TOOL_RENDERMAN_OSO_DUPLICATION;
    public static final int TOOL_RENDERMAN_OSO_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_PLUGIN_DUPLICATION;
    public static final int TOOL_RENDERMAN_PLUGIN_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_PATTERN_DUPLICATION;
    public static final int TOOL_RENDERMAN_PATTERN_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_BXDF_DUPLICATION;
    public static final int TOOL_RENDERMAN_BXDF_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_DISP_DUPLICATION;
    public static final int TOOL_RENDERMAN_DISP_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_FILTERS_DUPLICATION;
    public static final int TOOL_RENDERMAN_FILTERS_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_INTG_DUPLICATION;
    public static final int TOOL_RENDERMAN_INTG_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_PROJ_DUPLICATION;
    public static final int TOOL_RENDERMAN_PROJ_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_RIF_DUPLICATION;
    public static final int TOOL_RENDERMAN_RIF_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_EXE_DUPLICATION;
    public static final int TOOL_RENDERMAN_EXE_DUPLICATION_PATH;
    public static final int TOOL_RENDERMAN_RAT_SHADERS;
    public static final int TOOL_RENDERMAN_RMS_SHADERS;
    public static final int TOOL_RENDERMAN_RMS_MAYAIFF_IT;
    public static final int TOOL_RENDERMAN_COMPILER_FLAGS_ACTIVE;
    public static final int TOOL_RENDERMAN_RENDER_FLAGS_ACTIVE;
    public static final int TOOL_RENDERMAN_AUTO_RELOAD_SHADERS;
    public static final int TOOL_RENDERMAN_AUTO_SET_RENDERER;
    public static final int TOOL_RENDERMAN_AUTO_SET_VENDOR_RIBOPTION;
    public static final int PROCESS_LOG_X;
    public static final int PROCESS_LOG_Y;
    public static final int PROCESS_LOG_WIDTH;
    public static final int PROCESS_LOG_HEIGHT;
    public static final int PROCESS_TIMEOUT_PERIOD;
    public static final int TEXT_COLOR_RIB_COMMENT;
    public static final int TEXT_COLOR_RIB_STATEMENT;
    public static final int TEXT_COLOR_RIB_STRING;
    public static final int TEXT_COLOR_RIB_PLAIN;
    public static final int TEXT_COLOR_RLF_COMMENT;
    public static final int TEXT_COLOR_RLF_KEYWORD;
    public static final int TEXT_COLOR_RLF_STRING;
    public static final int TEXT_COLOR_RLF_RIB;
    public static final int TEXT_COLOR_RLF_ESCAPE;
    public static final int TEXT_COLOR_RLF_PLAIN;
    public static final int TEXT_COLOR_C_COMMENT;
    public static final int TEXT_COLOR_C_FUNCTION;
    public static final int TEXT_COLOR_C_DATATYPE;
    public static final int TEXT_COLOR_C_VARIABLE;
    public static final int TEXT_COLOR_C_STRING;
    public static final int TEXT_COLOR_C_PLAIN;
    public static final int TEXT_COLOR_SHK_COMMENT;
    public static final int TEXT_COLOR_SHK_FUNCTION;
    public static final int TEXT_COLOR_SHK_DATATYPE;
    public static final int TEXT_COLOR_SHK_GLOBAL;
    public static final int TEXT_COLOR_SHK_STRING;
    public static final int TEXT_COLOR_SHK_PLAIN;
    public static final int PATH_SHK_DOCS;
    public static final int PATH_SHK_BIN;
    public static final int TEXT_COLOR_OSL_COMMENT;
    public static final int TEXT_COLOR_OSL_FUNCTION;
    public static final int TEXT_COLOR_OSL_DATATYPE;
    public static final int TEXT_COLOR_OSL_VARIABLE;
    public static final int TEXT_COLOR_OSL_METADATA;
    public static final int TEXT_COLOR_OSL_STRING;
    public static final int TEXT_COLOR_OSL_PLAIN;
    public static final int TEXT_COLOR_SL_COMMENT;
    public static final int TEXT_COLOR_SL_FUNCTION;
    public static final int TEXT_COLOR_SL_DATATYPE;
    public static final int TEXT_COLOR_SL_VARIABLE;
    public static final int TEXT_COLOR_SL_SHADERTYPE;
    public static final int TEXT_COLOR_SL_STRING;
    public static final int TEXT_COLOR_SL_PLAIN;
    public static final int HOUDINI_SLO2OTL;
    public static final int HOUDINI_USER_SLO2OTL_PATH;
    public static final int HOUDINI_USER_VEX2OTL_PATH;
    public static final int HOUDINI_USER_VFL_SRC_PATH;
    public static final int HOUDINI_USER_VEX_DIR_PATH;
    public static final int TEXT_COLOR_VFL_COMMENT;
    public static final int TEXT_COLOR_VFL_FUNCTION;
    public static final int TEXT_COLOR_VFL_DATATYPE;
    public static final int TEXT_COLOR_VFL_VARIABLE;
    public static final int TEXT_COLOR_VFL_SHADERTYPE;
    public static final int TEXT_COLOR_VFL_STRING;
    public static final int TEXT_COLOR_VFL_PLAIN;
    public static final int PATH_VEX_DOCS;
    public static final int PATH_VFL_SHOP;
    public static final int PATH_HOUDINI_BIN;
    public static final int TEXT_COLOR_MI_COMMENT;
    public static final int TEXT_COLOR_MI_STATEMENT;
    public static final int TEXT_COLOR_MI_LINK;
    public static final int TEXT_COLOR_MI_INCLUDE;
    public static final int TEXT_COLOR_MI_STRING;
    public static final int TEXT_COLOR_MI_PLAIN;
    public static final int TEXT_COLOR_MIC_COMMENT;
    public static final int TEXT_COLOR_MIC_FUNCTION;
    public static final int TEXT_COLOR_MIC_DATATYPE;
    public static final int TEXT_COLOR_MIC_VARIABLE;
    public static final int TEXT_COLOR_MIC_SHADERTYPE;
    public static final int TEXT_COLOR_MIC_STRING;
    public static final int TEXT_COLOR_MIC_PLAIN;
    public static final int PATH_MIC_DOCS;
    public static final int PATH_USER_MIC_SRC;
    public static final int PATH_USER_MIC_SHADERS;
    public static final int PATH_USER_MIC_OBJS;
    public static final int PATH_USER_MIC_INCLUDES;
    public static final int PATH_MI_BIN;
    public static final int MI_TCP_STUBFILE_TIMEOUT;
    public static final int TEXT_COLOR_CPP_COMMENT;
    public static final int TEXT_COLOR_CPP_FUNCTION;
    public static final int TEXT_COLOR_CPP_DATATYPE;
    public static final int TEXT_COLOR_CPP_VARIABLE;
    public static final int TEXT_COLOR_CPP_STRING;
    public static final int TEXT_COLOR_CPP_PLAIN;
    public static final int PATH_CPP_COMPILER_BIN;
    public static final int PATH_CPP_VCVARSX86_AMD64_BAT;
    public static final int EXE_CPP_COMPILE;
    public static final int EXE_CPP_MAKE;
    public static final int EXE_CPP_FLAGS;
    public static final int TEXT_COLOR_MEL_COMMENT;
    public static final int TEXT_COLOR_MEL_FUNCTION;
    public static final int TEXT_COLOR_MEL_DATATYPE;
    public static final int TEXT_COLOR_MEL_USER_VARIABLE;
    public static final int TEXT_COLOR_MEL_COMMAND;
    public static final int TEXT_COLOR_MEL_STRING;
    public static final int TEXT_COLOR_MEL_PLAIN;
    public static final int PATH_MEL_DOCS;
    public static final int PATH_MEL_SCRIPTS;
    public static final int PATH_MEL_STRIP;
    public static final int PATH_ARNOLD_DEVKIT;
    public static final int PATH_ARNOLD_USER_SHADER_SRC;
    public static final int PATH_ARNOLD_USER_SHADER_DST;
    public static final int ARNOLD_RENDER_IPR;
    public static final int ARNOLD_DEVKIT_MTD_STYLE;
    public static final int PATH_ARNOLD_USER_AETEMPLATES;
    public static final int TEXT_COLOR_TCL_COMMENT;
    public static final int TEXT_COLOR_TCL_FUNCTION;
    public static final int TEXT_COLOR_TCL_USER_VARIABLE;
    public static final int TEXT_COLOR_TCL_STRING;
    public static final int TEXT_COLOR_TCL_PLAIN;
    public static final int PATH_TCL_DOCS;
    public static final int TEXT_COLOR_PERL_COMMENT;
    public static final int TEXT_COLOR_PERL_FUNCTION;
    public static final int TEXT_COLOR_PERL_USER_VARIABLE;
    public static final int TEXT_COLOR_PERL_STRING;
    public static final int TEXT_COLOR_PERL_PLAIN;
    public static final int PATH_PERL_DOCS;
    public static final int TEXT_COLOR_PYTHON_COMMENT;
    public static final int TEXT_COLOR_PYTHON_BUILT_IN;
    public static final int TEXT_COLOR_PYTHON_MODULE;
    public static final int TEXT_COLOR_PYTHON_FUNCTION;
    public static final int TEXT_COLOR_PYTHON_METHOD;
    public static final int TEXT_COLOR_PYTHON_STRING;
    public static final int TEXT_COLOR_PYTHON_CONSTANT;
    public static final int PATH_PYTHON_DOCS;
    public static final int PATH_PYSIDE2_DOCS;
    public static final int PYTHON_COMMAND;
    public static final int TEXT_COLOR_LPE_COMMENT;
    public static final int TEXT_COLOR_LPE_KEYWORD;
    public static final int TEXT_COLOR_LPE_EVENTYPE;
    public static final int TEXT_COLOR_LPE_SCATTERTYPE;
    public static final int TEXT_COLOR_LPE_RE_QUALIFIER;
    public static final int TEXT_COLOR_LPE_STRING;
    public static final int TEXT_COLOR_LPE_PLAIN;
    public static final int TEXT_COLOR_JAVA_COMMENT;
    public static final int TEXT_COLOR_JAVA_FUNCTION;
    public static final int TEXT_COLOR_JAVA_DATATYPE;
    public static final int TEXT_COLOR_JAVA_VARIABLE;
    public static final int TEXT_COLOR_JAVA_STRING;
    public static final int TEXT_COLOR_JAVA_PLAIN;
    public static final int TEXT_COLOR_HTML_COMMENT;
    public static final int TEXT_COLOR_HTML_TAG_IMAGE;
    public static final int TEXT_COLOR_HTML_PLAIN;
    public static final int TEXT_COLOR_HTML_STRING;
    public static final int TEXT_COLOR_HTML_TAG_HREF;
    public static final int TEXT_COLOR_HTML_TAG_GENERAL;
    public static final int TEXT_COLOR_TXT_PLAIN;
    public static final int TEXT_COLOR_SEE_COMMENT;
    public static final int TEXT_COLOR_SEE_FUNCTION;
    public static final int TEXT_COLOR_SEE_VARIABLE;
    public static final int TEXT_COLOR_SEE_STRING;
    public static final int TEXT_COLOR_SEE_PLAIN;
    public static final int SLIM_SIGNATURE_AUTHOR;
    public static final int SLIM_SIGNATURE_STUDIO;
    public static final int SLIM_SIGNATURE_PREFIX;
    public static final int SLIM_MAYA_IP;
    public static final int SLIM_MAYA_PORT;
    public static final int SLIM_STYLE;
    public static final int HYPERSHADE_NODE_DIR;
    public static final int HYPERSHADE_NODE_USER_MIN_ID;
    public static final int HYPERSHADE_NODE_USER_MAX_ID;
    public static final int HYPERSHADE_NODE_MAX_ID;
    public static final int TEXT_FONT_NAME;
    public static final int TEXT_TAB_SIZE;
    public static final int TEXT_FONT_SIZE;
    public static final int TEXT_FONT_WEIGHT;
    public static final int TEXT_COLOR_MAXLENGTH;
    public static final int TEXT_COLOR_ACTIVE;
    public static final int DOCUMENT_LAST_OPEN;
    public static final int DOCUMENT_RECENT_MAX;
    public static final int DOCUMENT_RECENT_PATHS;
    public static final int DOCUMENT_HISTORY_MAXCOUNT;
    public static final int DOCUMENT_HISTORY_MAXBYTES;
    public static final int DOCUMENT_HISTORY_ACTIVE;
    public static final int DOCUMENT_LAST_SESSION_PATHS;
    public static final int DOCUMENT_BACKGROUND_COLOR;
    public static final int DOCUMENT_CARET_COLOR;
    public static final int DOCUMENT_CARET_SELECTION_COLOR;
    public static final int DOCUMENT_SECONDARY_SELECTIONS_COLOR;
    public static final int DOCUMENT_CARET_DEFOCUSED_SELECTION_COLOR;
    public static final int DOCUMENT_LINENUMBERING_ACTIVE;
    public static final int DOCUMENT_TYPINGCOMPLETION_ACTIVE;
    public static final int DOCUMENT_RIGHT_MARGIN_WIDTH;
    public static final int DOCUMENT_RIGHT_MARGIN_COLOR;
    public static final int TEMPLATES_USER_DIR_PATH;
    public static final int CUTLETS_AUTHOR;
    public static final int GUI_SWING_THEME;
    public static final int UI_MENUBAR_SIZE;
    public static final int UI_DIR_PRESETS_APPENDED_PATHS;
    private static final Vector<PreferencesListener> listOfListeners;
    private static String[][] preference;
    public static File prefsBaseDir;
    private static File osxPrefFile;
    private static File winPrefFile;
    private static File linuxPrefFile;
    private static JFileChooser chooser;
    private static boolean firstWrite;
    private static int id;
    private static int counter;
    private static int maxcounter;
    static Vector<String> linesOfPrefs;
    private static String parentPWDPath;
    public static String user_shader_srcPath;
    public static String user_shadersPath;
    public static String user_texturesPath;
    public static String user_framesPath;

    public static String get_PREFS_PATH() {
        return "";
    }

    public static boolean init() {
        int n;
        Vector<String> linesOfText;
        prefsBaseDir = new File(FileUtils.getPWD(), "Cutter_Prefs");
        osxPrefFile = new File(prefsBaseDir, "osx.ini");
        winPrefFile = new File(prefsBaseDir, "win.ini");
        linuxPrefFile = new File(prefsBaseDir, "linux.ini");
        if (prefsBaseDir.exists() && !osxPrefFile.exists()) {
            linesOfText = new Vector<String>();
            for (n = 1; n < OSXPrefs.db.length; ++n) {
                linesOfText.addElement(OSXPrefs.db[n][0] + "\t\t\t" + '\"' + OSXPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, osxPrefFile);
        }
        if (prefsBaseDir.exists() && !winPrefFile.exists()) {
            linesOfText = new Vector();
            for (n = 1; n < WinPrefs.db.length; ++n) {
                linesOfText.addElement(WinPrefs.db[n][0] + "\t\t\t" + '\"' + WinPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, winPrefFile);
        }
        if (prefsBaseDir.exists() && !linuxPrefFile.exists()) {
            linesOfText = new Vector();
            for (n = 1; n < LinuxPrefs.db.length; ++n) {
                linesOfText.addElement(LinuxPrefs.db[n][0] + "\t\t\t" + '\"' + LinuxPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, linuxPrefFile);
        }
        if (!prefsBaseDir.exists()) {
            prefsBaseDir.mkdir();
            linesOfText = new Vector();
            for (n = 1; n < WinPrefs.db.length; ++n) {
                linesOfText.addElement(WinPrefs.db[n][0] + "\t\t\t" + '\"' + WinPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, new File(prefsBaseDir, "win.ini"));
            linesOfText.clear();
            for (n = 1; n < OSXPrefs.db.length; ++n) {
                linesOfText.addElement(OSXPrefs.db[n][0] + "\t\t\t" + '\"' + OSXPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, new File(prefsBaseDir, "osx.ini"));
            linesOfText.clear();
            for (n = 1; n < LinuxPrefs.db.length; ++n) {
                linesOfText.addElement(LinuxPrefs.db[n][0] + "\t\t\t" + '\"' + LinuxPrefs.db[n][1] + '\"');
            }
            Preferences.writeLines(linesOfText, new File(prefsBaseDir, "linux.ini"));
        }
        table.clear();
        preference = EnvUtils.isWinEnvironment() ? WinPrefs.db : (EnvUtils.isOSXEnvironment() ? OSXPrefs.db : LinuxPrefs.db);
        for (int n2 = 0; n2 < preference.length; ++n2) {
            table.put(preference[n2][0], preference[n2][1]);
        }
        try {
            new Preferences();
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception - Preferences.init() " + ex);
            return false;
        }
        if (table.size() == 0) {
            Cutter.setLog("    Error: Preferences.init() - no preferences in table");
            return false;
        }
        LogFrame.setMaxChars(Integer.parseInt(Preferences.get(WINDOW_LOG_MAX_CHARS)));
        return true;
    }

    private static File getOSPrefFile() {
        if (EnvUtils.isOSXEnvironment()) {
            return osxPrefFile;
        }
        if (EnvUtils.isWinEnvironment()) {
            return winPrefFile;
        }
        return linuxPrefFile;
    }

    private static Vector<String> readLines() {
        Vector<String> linesOfText = new Vector<String>();
        File osSpecificPrefFile = Preferences.getOSPrefFile();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(osSpecificPrefFile), 16256);
            while ((line = reader.readLine()) != null) {
                linesOfText.addElement(line);
            }
            reader.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Preferences.readLines()\n      " + e.toString());
            return null;
        }
        return linesOfText;
    }

    private Preferences() {
        Vector<String> lines = Preferences.readLines();
        for (int n = 0; n < lines.size(); ++n) {
            String line = lines.elementAt(n);
            int index = line.indexOf(34);
            int lastQuote = line.lastIndexOf(34);
            if (index == -1 || lastQuote == -1 || index == lastQuote) {
                Cutter.setLog("    Error:Preferences.Preferences() quotation error for line:\n            >" + line + "<");
                continue;
            }
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1, line.length() - 1).trim();
            table.remove(key);
            value = value.replace('\u001f', '\"');
            String[] tokens = TextUtils.tokenize(key, ".");
            if (tokens != null) {
                boolean doSubstitute = false;
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokens[i].trim().equalsIgnoreCase("path")) continue;
                    doSubstitute = true;
                }
                if (doSubstitute) {
                    value = value.replace('\\', '/');
                }
            }
            table.put(key, value);
        }
        table.put(preference[0][0], "true");
    }

    public static String getAll() {
        StringBuffer buffer = new StringBuffer();
        for (int n = 0; n < preference.length; ++n) {
            buffer.append(preference[n][0] + "");
            buffer.append("\t\"" + Preferences.get(n) + "\"\n");
        }
        return buffer.toString();
    }

    public static void save() {
        StringBuffer buffer = new StringBuffer();
        Vector<String> linesOfText = Preferences.readLines();
        int quoteBegin = -1;
        int quoteEnd = -1;
        boolean foundItem = false;
        if (linesOfText == null) {
            Cutter.setLog("    Error: Preferences.save() could not find an existing prefs.ini file");
            return;
        }
        for (int item = 1; item < preference.length; ++item) {
            String itemName = preference[item][0];
            String itemValue = Preferences.get(item);
            foundItem = false;
            for (int n = 0; n < linesOfText.size(); ++n) {
                String line = linesOfText.elementAt(n);
                if (line != null && line.trim().length() != 0 && TextUtils.contains(line, itemName, true)) {
                    int i;
                    for (i = 0; i < line.length(); ++i) {
                        if (line.charAt(i) != '\"') continue;
                        quoteBegin = ++i;
                        break;
                    }
                    for (i = quoteBegin; i < line.length(); ++i) {
                        if (line.charAt(i) != '\"') continue;
                        quoteEnd = i;
                        break;
                    }
                    if (quoteBegin == -1 || quoteEnd == -1) {
                        Cutter.setLog("    Error in Preferences.write(): cannot find " + preference[item]);
                        return;
                    }
                    buffer.setLength(0);
                    try {
                        buffer.append(line.substring(0, quoteBegin));
                        buffer.append(itemValue);
                        buffer.append(line.substring(quoteEnd, line.length()));
                    }
                    catch (Exception ex) {
                        Cutter.setLog("    Exception:Preferences.save() line >" + line + "< \n" + ex.toString());
                        continue;
                    }
                    linesOfText.removeElementAt(n);
                    linesOfText.insertElementAt(buffer.toString(), n);
                    foundItem = true;
                }
                if (foundItem) break;
            }
            if (foundItem) continue;
            linesOfText.addElement(preference[item][0] + "\t\t\t" + '\"' + itemValue + '\"');
        }
        Preferences.writeLines(linesOfText, Preferences.getOSPrefFile());
    }

    private static void writeLines(Vector lines, File out) {
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(out));
            for (int n = 0; n < lines.size(); ++n) {
                String line = (String)lines.elementAt(n);
                if (line == null || line.trim().length() <= 0) continue;
                fw.write(line);
                fw.newLine();
            }
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            Cutter.setLog("    IOException: Preferences.writeLines(): " + ex);
            Cutter.setLog("    Exception when writing the following lines.");
            Cutter.setLog(lines);
        }
    }

    public static Color getColor(int item) {
        String str = Preferences.get(item);
        if (str == null || str.trim().length() == 0) {
            return Color.black;
        }
        String[] s = TextUtils.tokenize(str);
        if (s.length < 3) {
            Cutter.setLog("    Error: Preferences.getColor() - wrong number of components for item \"" + preference[item][0] + "\"");
            return Color.black;
        }
        int[] val = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                val[i] = Integer.parseInt(s[i]);
                if (val[i] >= 0 && val[i] <= 255) continue;
                Cutter.setLog("    Error: Preferences.getColor() - wrong component out of range for item \"" + preference[item][0] + "\"");
                return Color.black;
            }
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Error: Preferences.getColor() - NumberFormatException for item \"" + preference[item][0] + "\"");
            return Color.black;
        }
        return new Color(val[0], val[1], val[2]);
    }

    public static void addListener(PreferencesListener item) {
        listOfListeners.addElement(item);
    }

    public static boolean write(int item, int value) {
        return Preferences.write(item, "" + value);
    }

    public static boolean write(int item, String value) {
        if (item == 0) {
            return false;
        }
        if (linesOfPrefs == null) {
            linesOfPrefs = Preferences.readLines();
        }
        if (linesOfPrefs == null) {
            return false;
        }
        boolean foundItem = false;
        for (int n = 0; n < linesOfPrefs.size() && !foundItem; ++n) {
            String line = linesOfPrefs.elementAt(n);
            if (line == null || line.trim().length() == 0 || !TextUtils.contains(line, preference[item][0], true)) continue;
            StringBuffer str = new StringBuffer();
            str.append(preference[item][0]);
            str.append("\t\t\"");
            str.append(value);
            str.append("\"");
            linesOfPrefs.removeElementAt(n);
            linesOfPrefs.insertElementAt(str.toString(), n);
            foundItem = true;
        }
        if (!foundItem) {
            Cutter.setLog("Preferences.write(item, value) - cannot find item: " + item + ", value: " + value);
            linesOfPrefs.addElement(preference[item][0] + "\t\t\t" + '\"' + value + '\"');
        }
        Preferences.writeLines(linesOfPrefs, Preferences.getOSPrefFile());
        table.remove(preference[item][0]);
        table.put(preference[item][0], value);
        return true;
    }

    public static String get(int item) {
        if (item > table.size()) {
            Cutter.setLog("    Error: Preferences.get() - item " + item + " is larger than the table of preferences!");
            return "";
        }
        if (table.get(preference[0][0]).equals("false")) {
            Cutter.setLog("    Error: Preferences.get() - the hashtable has not been initialized");
            Cutter.setLog("            preference[0][0] = >" + preference[0][0] + "<");
            return "";
        }
        String value = table.get(preference[item][0]);
        if (value == null) {
            return "";
        }
        String out = value;
        return (out = TextUtils.replace_USER_HOME(out)) == null ? "" : out;
    }

    public static void getTableOfItems() {
        StringBuffer buff = new StringBuffer();
        Enumeration<String> e = table.elements();
        while (e.hasMoreElements()) {
            Cutter.setLog(e.nextElement().toString());
        }
    }

    private static boolean upDatePrefName() {
        File oldPrefFile = new File(OLD_PREFS_NAME);
        File prefFile = new File(PREFS_NAME);
        File backupPrefFile = new File(PREFS_BACKUP_NAME);
        if (!prefFile.exists() || prefFile.length() < (long)minSize) {
            if (backupPrefFile.exists()) {
                Cutter.setLog("Preferences: couldn't use \"" + PREFS_NAME + "\" using \"" + PREFS_BACKUP_NAME + "\" instead.");
                if (FileUtils.copy(backupPrefFile, prefFile)) {
                    return true;
                }
            }
            if (oldPrefFile.exists()) {
                Cutter.setLog("Preferences: couldn't use \"" + PREFS_NAME + "\" using \"" + OLD_PREFS_NAME + "\" instead.");
                if (!oldPrefFile.renameTo(prefFile)) {
                    return false;
                }
                return FileUtils.copy(prefFile, backupPrefFile);
            }
        }
        return true;
    }

    public static void updateBackup() {
        File oldPrefFile = new File(OLD_PREFS_NAME);
        File backupPrefFile = new File(PREFS_BACKUP_NAME);
        File tmpFile = new File(TMP_PREFS_BACKUP_NAME);
        File prefFile = new File(PREFS_NAME);
        int length = (int)prefFile.length();
        char[] buffer = null;
        if (backupPrefFile.exists()) {
            backupPrefFile.renameTo(tmpFile);
            backupPrefFile.delete();
        }
        if (!Preferences.upDatePrefName()) {
            Preferences.save();
        }
        try {
            if (prefFile.exists() && length > minSize) {
                FileReader reader = new FileReader(prefFile);
                buffer = new char[length];
                if (reader.read(buffer, 0, length) != length) {
                    Cutter.setLog("    Error 1: Preferences.updateBackup() unable to read \"prefs.ini\"");
                    reader.close();
                    tmpFile.renameTo(backupPrefFile);
                    return;
                }
                reader.close();
            } else {
                Cutter.setLog("    Warning: Preferences.updateBackup() regenerating \"prefs.ini\"");
                Preferences.save();
                if (!prefFile.exists() || prefFile.length() < (long)minSize) {
                    Cutter.setLog("    Error 2: Preferences.updateBackup() unable to read \"prefs.ini\"");
                    tmpFile.renameTo(backupPrefFile);
                    return;
                }
            }
            if (buffer == null) {
                return;
            }
            FileWriter writer = new FileWriter(backupPrefFile);
            writer.write(buffer, 0, length);
            writer.close();
        }
        catch (FileNotFoundException fe) {
            Cutter.setLog("    Exception: Preferences.writeBackup()\n" + fe);
            return;
        }
        catch (IOException ie) {
            Cutter.setLog("    Exception: Preferences.writeBackup()\n" + ie);
            return;
        }
    }

    public static void deleteTmpFile() {
        File file = new File(TMP_PREFS_BACKUP_NAME);
        if (file.exists()) {
            file.delete();
            Cutter.setLog("Preferences.deleteFile(): successfully removed \"" + TMP_PREFS_BACKUP_NAME + "\"");
            return;
        }
        Cutter.setLog("Preferences.deleteFile(): unable to remove \"" + TMP_PREFS_BACKUP_NAME + "\" because it does not exist!");
    }

    public static int minSize() {
        int count = 0;
        for (int n = 0; n < preference.length; ++n) {
            count += preference[n][0].length();
            count += preference[n][1].length();
        }
        return count;
    }

    protected static boolean isItem(String str) {
        if (Preferences.isLiteral(str)) {
            return false;
        }
        return str.indexOf(46, 0) != -1;
    }

    public static void autoConfigRmanUserDirs(String addr) {
        String ipAddress = Client.getLocalIP();
        if (!ipAddress.startsWith(addr)) {
            return;
        }
    }

    static {
        minSize = 0;
        n = 1;
        DESKTOP_BOUNDS = n++;
        DESKTOP_DOCUMENT_LAYOUT = n++;
        TOOL_RENDERMAN = n++;
        TOOL_RENDERMAN_POSITION = n++;
        TOOL_RENDERMAN_TEXTURE = n++;
        TOOL_RENDERMAN_TEXTURE_POSITION = n++;
        TOOL_RENDERMAN_TEXTURE_RECENT_PATHS = n++;
        TOOL_RENDERMAN_PLACECAMERA = n++;
        TOOL_RENDERMAN_PLACECAMERA_POSITION = n++;
        TOOL_RENDERMAN_PLACECAMERA_YUP_FROMTO = n++;
        TOOL_RENDERMAN_PLACECAMERA_ZUP_FROMTO = n++;
        TOOL_RENDERMAN_QTVR = n++;
        TOOL_RENDERMAN_QTVR_POSITION = n++;
        TOOL_MATRIX = n++;
        TOOL_MATRIX_POSITION = n++;
        TOOL_DIRECTORY = n++;
        TOOL_DIRECTORY_POSITION = n++;
        TOOL_FIND = n++;
        TOOL_FIND_POSITION = n++;
        TOOL_FIND_SRC_DATA = n++;
        TOOL_FIND_DEST_DATA = n++;
        TOOL_FIND_BATCH_MODE = n++;
        TOOL_FIND_BATCH_RECURSIVE = n++;
        TOOL_SHAKE = n++;
        TOOL_SHAKE_POSITION = n++;
        TOOL_JAVA = n++;
        TOOL_JAVA_POSITION = n++;
        TOOL_C = n++;
        TOOL_C_POSITION = n++;
        TOOL_HTML = n++;
        TOOL_HTML_POSITION = n++;
        TOOL_PERL = n++;
        TOOL_PERL_POSITION = n++;
        TOOL_PREFS = n++;
        TOOL_PREFS_POSITION = n++;
        TOOL_HTML_SEARCH = n++;
        TOOL_HTML_SEARCH_POSITION = n++;
        TOOL_HTML_SEARCH_STRING = n++;
        TOOL_HTML_SEARCH_PATH = n++;
        TOOL_HTML_SEARCH_USER_DOCS = n++;
        TOOL_HTML_SEARCH_RECURSE = n++;
        TOOL_LPE = n++;
        TOOL_LPE_POSITION = n++;
        TOOL_LPE_WIDTH = n++;
        TOOL_LPE_HEIGHT = n++;
        TOOL_TIMEOUT = n++;
        TOOL_TIMEOUT_POSITION = n++;
        TOOL_TIMEOUT_PERIOD = n++;
        TOOL_JOURNAL = n++;
        TOOL_JOURNAL_POSITION = n++;
        TOOL_JOURNAL_DIRECTORY = n++;
        TOOL_JOURNAL_FAVORITES = n++;
        TOOL_REMOTEBUILD = n++;
        TOOL_REMOTEBUILD_POSITION = n++;
        TOOL_REMOTEBUILD_SRC_CPP = n++;
        TOOL_REMOTEBUILD_SRC_H = n++;
        TOOL_REMOTEBUILD_SRC_ARGS = n++;
        TOOL_REMOTEBUILD_ENABLED_IP_1 = n++;
        TOOL_REMOTEBUILD_DST_IP_1 = n++;
        TOOL_REMOTEBUILD_DST_CPP_DIR_1 = n++;
        TOOL_REMOTEBUILD_DST_H_DIR_1 = n++;
        TOOL_REMOTEBUILD_DST_ARGS_DIR_1 = n++;
        TOOL_REMOTEBUILD_WRITE_1 = n++;
        TOOL_REMOTEBUILD_ENABLED_IP_2 = n++;
        TOOL_REMOTEBUILD_DST_IP_2 = n++;
        TOOL_REMOTEBUILD_DST_CPP_DIR_2 = n++;
        TOOL_REMOTEBUILD_DST_H_DIR_2 = n++;
        TOOL_REMOTEBUILD_DST_ARGS_DIR_2 = n++;
        TOOL_REMOTEBUILD_WRITE_2 = n++;
        TOOL_DSO_SERVER = n++;
        TOOL_DSO_SERVER_POSITION = n++;
        TOOL_DSO_SERVER_DROPBOX_PATH = n++;
        TOOL_DSO_SERVER_COMPILATION_PATH = n++;
        TOOL_FTPSEND = n++;
        TOOL_FTPSEND_POSITION = n++;
        TOOL_FTPSEND_HOSTNAME = n++;
        TOOL_FTPSEND_USERNAME = n++;
        TOOL_FTPSEND_USERPASS = n++;
        TOOL_FTPSEND_LOCAL_PWD = n++;
        TOOL_FTPSEND_FILENAME = n++;
        TOOL_FTPSEND_HOST_PWD = n++;
        TOOL_FTPSEND_SEND_AS_HTML = n++;
        TOOL_FTPSEND_SEND_AS_INDEX_HTML = n++;
        TOOL_MOVER = n++;
        TOOL_MOVER_POSITION = n++;
        TOOL_MOVER_TAB1_SRC_DIR = n++;
        TOOL_MOVER_TAB1_DEST_DIR = n++;
        TOOL_MOVER_TAB1_MAX_DIR_SIZE = n++;
        TOOL_MOVER_TAB1_MAX_FILE_SIZE = n++;
        TOOL_MOVER_TAB1_NAME = n++;
        TOOL_MOVER_TAB2_SRC_DIR = n++;
        TOOL_MOVER_TAB2_DEST_DIR = n++;
        TOOL_MOVER_TAB2_MAX_DIR_SIZE = n++;
        TOOL_MOVER_TAB2_MAX_FILE_SIZE = n++;
        TOOL_MOVER_TAB2_NAME = n++;
        TOOL_MOVER_TAB3_SRC_DIR = n++;
        TOOL_MOVER_TAB3_DEST_DIR = n++;
        TOOL_MOVER_TAB3_MAX_DIR_SIZE = n++;
        TOOL_MOVER_TAB3_MAX_FILE_SIZE = n++;
        TOOL_MOVER_TAB3_NAME = n++;
        TOOL_MOVER_TAB4_SRC_DIR = n++;
        TOOL_MOVER_TAB4_DEST_DIR = n++;
        TOOL_MOVER_TAB4_MAX_DIR_SIZE = n++;
        TOOL_MOVER_TAB4_MAX_FILE_SIZE = n++;
        TOOL_MOVER_TAB4_NAME = n++;
        TOOL_MOVER_TAB5_SRC_DIR = n++;
        TOOL_MOVER_TAB5_DEST_DIR = n++;
        TOOL_MOVER_TAB5_MAX_DIR_SIZE = n++;
        TOOL_MOVER_TAB5_MAX_FILE_SIZE = n++;
        TOOL_MOVER_TAB5_NAME = n++;
        WINDOW_LOG = n++;
        WINDOW_LOG_POSITION = n++;
        WINDOW_LOG_MAX_CHARS = n++;
        TOOL_TABWINDOWS = n++;
        TOOL_TABWINDOWS_POSITION = n++;
        TOOL_ZIPPER = n++;
        TOOL_ZIPPER_POSITION = n++;
        TOOL_ZIPPER_ZIP_MAX_FILE_SIZE = n++;
        TOOL_ZIPPER_ZIP_EXT_FILTERS = n++;
        TOOL_ZIPPER_ZIP_FOLDERS_FILTER = n++;
        TOOL_NET = n++;
        TOOL_NET_POSITION = n++;
        TOOL_NET_SENDFILES_FILE_STATES = n++;
        TOOL_NET_SENDFILES_IP_STATES = n++;
        TOOL_SCRIPT_CATALOGER = n++;
        TOOL_SCRIPT_CATALOGER_POSITION = n++;
        TOOL_SCRIPT_CATALOGER_SRC_DIR_PATH = n++;
        TOOL_SCRIPT_CATALOGER_DST_DIR_PATH = n++;
        TOOL_SCRIPT_CATALOGER_RECURSE = n++;
        TOOL_RUNBAT = n++;
        TOOL_RUNBAT_POSITION = n++;
        TOOL_XPM = n++;
        TOOL_XPM_POSITION = n++;
        TOOL_XPM_FILES_OPEN = n++;
        TOOL_RIF = n++;
        TOOL_RIF_POSITION = n++;
        TOOL_RIF_PATHS = n++;
        TOOL_RIF_ARGS = n++;
        TOOL_RIF_ENABLE = n++;
        TOOL_RIF_RIBIN_PATH = n++;
        TOOL_RIF_RIBOUT_PATH = n++;
        TOOL_CCOMPILER = n++;
        TOOL_CCOMPILER_POSITION = n++;
        TOOL_CCOMPILER_INCLUDES = n++;
        TOOL_CCOMPILER_LIBRARIES = n++;
        TOOL_MONITOR_FONT_SIZE = n++;
        TOOL_MONITOR_FONT_STYLE = n++;
        TOOL_MONITOR_LOGFILE_WRITE = n++;
        TOOL_SESSION = n++;
        TOOL_SESSION_POSITION = n++;
        RENDERER_DEFAULT = n++;
        RENDERER_SHADOW_SIZE = n++;
        RENDERER_SHADER_DATATYPE = n++;
        RENDERER_SHADERS_CACHE = n++;
        KEYFRAMER_RIB_SINGLE = n++;
        PATH_USER_FRAMES = n++;
        PATH_USER_RSL_SOURCE = n++;
        PATH_USER_SHADERS = n++;
        PATH_USER_TEXTURES = n++;
        PATH_USER_ARCHIVES = n++;
        PATH_USER_RIBS = n++;
        PATH_USER_PTC = n++;
        PATH_USER_BKM = n++;
        PATH_USER_CPM = n++;
        _PATH_PIXAR_BIN = n++;
        PATH_PIXAR_SHADERS = n++;
        PATH_PIXAR_TEXTURES = n++;
        PIXAR_COMPILER_FLAGS_USER = n++;
        PIXAR_RENDER_FLAGS_USER = n++;
        PIXAR_COMPILER_FLAGS_USER_ENABLED = n++;
        PIXAR_RENDER_FLAGS_USER_ENABLED = n++;
        PIXAR_RENDER_RISMODE = n++;
        PATH_PIXAR_RMS = n++;
        PATH_PIXAR_RMS_DOCS_INDEX = n++;
        PATH_PIXAR_PROSERVER = n++;
        PATH_PIXAR_RENDERMAN_LEGACY_DOCS_INDEX = n++;
        PATH_PIXAR_RENDERMAN_DOCS_INDEX = n++;
        PATH_PIXAR_DOCS_SHADERS = n++;
        PATH_PIXAR_DOCS_SHADERS_TOC = n++;
        PATH_PIXAR_DOCS_SHADERS_EXT = n++;
        PATH_PIXAR_DOCS_EXT = n++;
        PATH_DEVKIT_PIXAR = n++;
        PATH_DEVKIT_USER_INCLUDE_DIRECTORIES = n++;
        PATH_DEVKIT_USER_LIB_DIRECTORIES = n++;
        PATH_DEVKIT_USER_LIBS = n++;
        PATH_DEVKIT_USER_OBJS = n++;
        DEVKIT_USER_FLAGS = n++;
        PIXAR_DEVKIT_PATTERN_BUILD_PATH = n++;
        PIXAR_DEVKIT_BXDF_BUILD_PATH = n++;
        PIXAR_DEVKIT_DISP_BUILD_PATH = n++;
        PIXAR_DEVKIT_FILTERS_BUILD_PATH = n++;
        PIXAR_DEVKIT_INTG_BUILD_PATH = n++;
        PIXAR_DEVKIT_PROJ_BUILD_PATH = n++;
        PIXAR_DEVKIT_RIF_BUILD_PATH = n++;
        PIXAR_DEVKIT_PROCEDURAL_BUILD_PATH = n++;
        PIXAR_DEVKIT_EXE_BUILD_PATH = n++;
        CPP_MAKEFILE_CLEANUP = n++;
        PIXAR_DEVKIT_POSTBUILD_SCRIPTNAME = n++;
        PIXAR_DEVKIT_POST_BUILD_SCRIPTMODE = n++;
        DEVKIT_VARYING_POINTER_PREFIX = n++;
        DEVKIT_VARYING_POINTER_SUFFIX = n++;
        DEVKIT_UNIFORM_POINTER_PREFIX = n++;
        DEVKIT_UNIFORM_POINTER_SUFFIX = n++;
        PATH_USER_PLUGINS = n++;
        PATH_USER_ARGS = n++;
        PATH_USER_RFM_INI = n++;
        EXE_PIXAR_RENDER = n++;
        EXE_PIXAR_COMPILE = n++;
        EXE_PIXAR_SHADER_INFO = n++;
        EXE_PIXAR_TEXTURE_MAKE = n++;
        EXTENSION_PIXAR_SHADER = n++;
        PATH_OSL_COMPILER_BIN = n++;
        PATH_USER_OSL_SOURCE = n++;
        PATH_USER_OSL_SHADERS = n++;
        PATH_ARNOLD_BIN = n++;
        PATH_USER_ARNOLD_OSL_SOURCE = n++;
        PATH_USER_ARNOLD_OSL_SHADERS = n++;
        PATH_USER_ARNOLD_OSL_INCLUDES = n++;
        PATH_USER_ARNOLD_OSO_MTD_DUPLICATION = n++;
        ARNOLD_DO_OSO_MTD_DUPLICATION = n++;
        ARNOLD_OSL_MTD_STYLE = n++;
        PATH_VRAY_BIN = n++;
        PATH_USER_VRAY_OSL_SOURCE = n++;
        PATH_USER_VRAY_OSL_SHADERS = n++;
        OSL_COMPILE_KEYBOARD_SHORTCUT = n++;
        PATH_BMRT_BIN = n++;
        PATH_BMRT_SHADERS = n++;
        PATH_BMRT_TEXTURES = n++;
        BMRT_COMPILER_FLAGS_USER = n++;
        BMRT_RENDER_FLAGS_USER = n++;
        BMRT_COMPILER_FLAGS_USER_ENABLED = n++;
        BMRT_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_BMRT_DOCS_SHADERS = n++;
        PATH_BMRT_DOCS_SHADERS_TOC = n++;
        PATH_BMRT_DOCS_SHADERS_EXT = n++;
        EXE_BMRT_RENDER = n++;
        EXE_BMRT_COMPILE = n++;
        EXE_BMRT_SHADER_INFO = n++;
        EXE_BMRT_TEXTURE_MAKE = n++;
        EXTENSION_BMRT_SHADER = n++;
        PATH_AIR_BIN = n++;
        PATH_AIR_SHADERS = n++;
        PATH_AIR_TEXTURES = n++;
        AIR_COMPILER_FLAGS_USER = n++;
        AIR_RENDER_FLAGS_USER = n++;
        AIR_COMPILER_FLAGS_USER_ENABLED = n++;
        AIR_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_AIR_DOCS_SHADERS = n++;
        PATH_AIR_DOCS_SHADERS_TOC = n++;
        PATH_AIR_DOCS_SHADERS_EXT = n++;
        EXE_AIR_RENDER = n++;
        EXE_AIR_COMPILE = n++;
        EXE_AIR_SHADER_INFO = n++;
        EXE_AIR_TEXTURE_MAKE = n++;
        EXTENSION_AIR_SHADER = n++;
        PATH_3DELIGHT_BIN = n++;
        PATH_3DELIGHT_SHADERS = n++;
        PATH_3DELIGHT_TEXTURES = n++;
        DELIGHT_COMPILER_FLAGS_USER = n++;
        DELIGHT_RENDER_FLAGS_USER = n++;
        DELIGHT_COMPILER_FLAGS_USER_ENABLED = n++;
        DELIGHT_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_3DELIGHT_DOCS_SHADERS = n++;
        PATH_3DELIGHT_DOCS_SHADERS_TOC = n++;
        PATH_3DELIGHT_DOCS_SHADERS_EXT = n++;
        EXE_3DELIGHT_RENDER = n++;
        EXE_3DELIGHT_COMPILE = n++;
        EXE_3DELIGHT_SHADER_INFO = n++;
        EXE_3DELIGHT_TEXTURE_MAKE = n++;
        EXTENSION_3DELIGHT_SHADER = n++;
        PATH_PIXIE_BIN = n++;
        PATH_PIXIE_SHADERS = n++;
        PATH_PIXIE_TEXTURES = n++;
        PIXIE_COMPILER_FLAGS_USER = n++;
        PIXIE_RENDER_FLAGS_USER = n++;
        PIXIE_COMPILER_FLAGS_USER_ENABLED = n++;
        PIXIE_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_PIXIE_DOCS_SHADERS = n++;
        PATH_PIXIE_DOCS_SHADERS_TOC = n++;
        PATH_PIXIE_DOCS_SHADERS_EXT = n++;
        EXE_PIXIE_RENDER = n++;
        EXE_PIXIE_COMPILE = n++;
        EXE_PIXIE_SHADER_INFO = n++;
        EXE_PIXIE_TEXTURE_MAKE = n++;
        EXTENSION_PIXIE_SHADER = n++;
        PATH_AQSIS_BIN = n++;
        PATH_AQSIS_SHADERS = n++;
        PATH_AQSIS_TEXTURES = n++;
        AQSIS_COMPILER_FLAGS_USER = n++;
        AQSIS_RENDER_FLAGS_USER = n++;
        AQSIS_COMPILER_FLAGS_USER_ENABLED = n++;
        AQSIS_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_AQSIS_DOCS_SHADERS = n++;
        PATH_AQSIS_DOCS_SHADERS_TOC = n++;
        PATH_AQSIS_DOCS_SHADERS_EXT = n++;
        EXE_AQSIS_RENDER = n++;
        EXE_AQSIS_COMPILE = n++;
        EXE_AQSIS_SHADER_INFO = n++;
        EXE_AQSIS_TEXTURE_MAKE = n++;
        EXTENSION_AQSIS_SHADER = n++;
        PATH_RENDERER_CUSTOM_NAME = n++;
        PATH_RENDERER_CUSTOM_BIN = n++;
        PATH_RENDERER_CUSTOM_SHADERS = n++;
        PATH_RENDERER_CUSTOM_TEXTURES = n++;
        RENDERMAN_CUSTOM_COMPILER_FLAGS_USER = n++;
        RENDERMAN_CUSTOM_RENDER_FLAGS_USER = n++;
        RENDERMAN_CUSTOM_COMPILER_FLAGS_USER_ENABLED = n++;
        RENDERMAN_CUSTOM_RENDER_FLAGS_USER_ENABLED = n++;
        PATH_RENDERER_CUSTOM_DOCS_SHADERS = n++;
        PATH_RENDERER_CUSTOM_DOCS_SHADERS_TOC = n++;
        PATH_RENDERER_CUSTOM_DOCS_SHADERS_EXT = n++;
        EXE_RENDERER_CUSTOM_RENDER = n++;
        EXE_RENDERER_CUSTOM_COMPILE = n++;
        EXE_RENDERER_CUSTOM_SHADER_INFO = n++;
        EXE_RENDERER_CUSTOM_TEXTURE_MAKE = n++;
        EXTENSION_RENDERER_CUSTOM_SHADER = n++;
        EMAIL_ADDRESS = n++;
        SMTP_SERVER = n++;
        SMTP_PORT = n++;
        MAYA_PEER_ADDRESS = n++;
        MAYA_PEER_PORT = n++;
        CUTTER_CLIENT_ADDRESS = n++;
        CUTTER_CLIENT_PORT = n++;
        HOUDINI_PEER_ADDRESS = n++;
        HOUDINI_PEER_PORT = n++;
        TCP_LISTENER_PORT = n++;
        TCP_TIMEOUT = n++;
        CLIENT_LOG_X = n++;
        CLIENT_LOG_Y = n++;
        CLIENT_LOG_WIDTH = n++;
        CLIENT_LOG_HEIGHT = n++;
        WEB_BROWSER_PREFERRED = n++;
        HTML_AUTO_CORRECT_IMAGE_NAMES = n++;
        TOOL_RENDERMAN_QTVR_COLUMNS = n++;
        TOOL_RENDERMAN_QTVR_ROWS = n++;
        TOOL_RENDERMAN_QTVR_STARTVP = n++;
        TOOL_RENDERMAN_QTVR_ENDVP = n++;
        FRAME_COUNT = n++;
        FRAME_SIZE = n++;
        FRAME_NAME = n++;
        TOOL_RENDERMAN_PRECISION_DECIMALPLACES = n++;
        TOOL_RENDERMAN_LOG_FILE = n++;
        TOOL_RENDERMAN_SLIM_FILE = n++;
        TOOL_RENDERMAN_SLIM_SLO_COPY = n++;
        TOOL_RENDERMAN_OSO_DUPLICATION = n++;
        TOOL_RENDERMAN_OSO_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_PLUGIN_DUPLICATION = n++;
        TOOL_RENDERMAN_PLUGIN_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_PATTERN_DUPLICATION = n++;
        TOOL_RENDERMAN_PATTERN_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_BXDF_DUPLICATION = n++;
        TOOL_RENDERMAN_BXDF_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_DISP_DUPLICATION = n++;
        TOOL_RENDERMAN_DISP_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_FILTERS_DUPLICATION = n++;
        TOOL_RENDERMAN_FILTERS_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_INTG_DUPLICATION = n++;
        TOOL_RENDERMAN_INTG_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_PROJ_DUPLICATION = n++;
        TOOL_RENDERMAN_PROJ_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_RIF_DUPLICATION = n++;
        TOOL_RENDERMAN_RIF_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_EXE_DUPLICATION = n++;
        TOOL_RENDERMAN_EXE_DUPLICATION_PATH = n++;
        TOOL_RENDERMAN_RAT_SHADERS = n++;
        TOOL_RENDERMAN_RMS_SHADERS = n++;
        TOOL_RENDERMAN_RMS_MAYAIFF_IT = n++;
        TOOL_RENDERMAN_COMPILER_FLAGS_ACTIVE = n++;
        TOOL_RENDERMAN_RENDER_FLAGS_ACTIVE = n++;
        TOOL_RENDERMAN_AUTO_RELOAD_SHADERS = n++;
        TOOL_RENDERMAN_AUTO_SET_RENDERER = n++;
        TOOL_RENDERMAN_AUTO_SET_VENDOR_RIBOPTION = n++;
        PROCESS_LOG_X = n++;
        PROCESS_LOG_Y = n++;
        PROCESS_LOG_WIDTH = n++;
        PROCESS_LOG_HEIGHT = n++;
        PROCESS_TIMEOUT_PERIOD = n++;
        TEXT_COLOR_RIB_COMMENT = n++;
        TEXT_COLOR_RIB_STATEMENT = n++;
        TEXT_COLOR_RIB_STRING = n++;
        TEXT_COLOR_RIB_PLAIN = n++;
        TEXT_COLOR_RLF_COMMENT = n++;
        TEXT_COLOR_RLF_KEYWORD = n++;
        TEXT_COLOR_RLF_STRING = n++;
        TEXT_COLOR_RLF_RIB = n++;
        TEXT_COLOR_RLF_ESCAPE = n++;
        TEXT_COLOR_RLF_PLAIN = n++;
        TEXT_COLOR_C_COMMENT = n++;
        TEXT_COLOR_C_FUNCTION = n++;
        TEXT_COLOR_C_DATATYPE = n++;
        TEXT_COLOR_C_VARIABLE = n++;
        TEXT_COLOR_C_STRING = n++;
        TEXT_COLOR_C_PLAIN = n++;
        TEXT_COLOR_SHK_COMMENT = n++;
        TEXT_COLOR_SHK_FUNCTION = n++;
        TEXT_COLOR_SHK_DATATYPE = n++;
        TEXT_COLOR_SHK_GLOBAL = n++;
        TEXT_COLOR_SHK_STRING = n++;
        TEXT_COLOR_SHK_PLAIN = n++;
        PATH_SHK_DOCS = n++;
        PATH_SHK_BIN = n++;
        TEXT_COLOR_OSL_COMMENT = n++;
        TEXT_COLOR_OSL_FUNCTION = n++;
        TEXT_COLOR_OSL_DATATYPE = n++;
        TEXT_COLOR_OSL_VARIABLE = n++;
        TEXT_COLOR_OSL_METADATA = n++;
        TEXT_COLOR_OSL_STRING = n++;
        TEXT_COLOR_OSL_PLAIN = n++;
        TEXT_COLOR_SL_COMMENT = n++;
        TEXT_COLOR_SL_FUNCTION = n++;
        TEXT_COLOR_SL_DATATYPE = n++;
        TEXT_COLOR_SL_VARIABLE = n++;
        TEXT_COLOR_SL_SHADERTYPE = n++;
        TEXT_COLOR_SL_STRING = n++;
        TEXT_COLOR_SL_PLAIN = n++;
        HOUDINI_SLO2OTL = n++;
        HOUDINI_USER_SLO2OTL_PATH = n++;
        HOUDINI_USER_VEX2OTL_PATH = n++;
        HOUDINI_USER_VFL_SRC_PATH = n++;
        HOUDINI_USER_VEX_DIR_PATH = n++;
        TEXT_COLOR_VFL_COMMENT = n++;
        TEXT_COLOR_VFL_FUNCTION = n++;
        TEXT_COLOR_VFL_DATATYPE = n++;
        TEXT_COLOR_VFL_VARIABLE = n++;
        TEXT_COLOR_VFL_SHADERTYPE = n++;
        TEXT_COLOR_VFL_STRING = n++;
        TEXT_COLOR_VFL_PLAIN = n++;
        PATH_VEX_DOCS = n++;
        PATH_VFL_SHOP = n++;
        PATH_HOUDINI_BIN = n++;
        TEXT_COLOR_MI_COMMENT = n++;
        TEXT_COLOR_MI_STATEMENT = n++;
        TEXT_COLOR_MI_LINK = n++;
        TEXT_COLOR_MI_INCLUDE = n++;
        TEXT_COLOR_MI_STRING = n++;
        TEXT_COLOR_MI_PLAIN = n++;
        TEXT_COLOR_MIC_COMMENT = n++;
        TEXT_COLOR_MIC_FUNCTION = n++;
        TEXT_COLOR_MIC_DATATYPE = n++;
        TEXT_COLOR_MIC_VARIABLE = n++;
        TEXT_COLOR_MIC_SHADERTYPE = n++;
        TEXT_COLOR_MIC_STRING = n++;
        TEXT_COLOR_MIC_PLAIN = n++;
        PATH_MIC_DOCS = n++;
        PATH_USER_MIC_SRC = n++;
        PATH_USER_MIC_SHADERS = n++;
        PATH_USER_MIC_OBJS = n++;
        PATH_USER_MIC_INCLUDES = n++;
        PATH_MI_BIN = n++;
        MI_TCP_STUBFILE_TIMEOUT = n++;
        TEXT_COLOR_CPP_COMMENT = n++;
        TEXT_COLOR_CPP_FUNCTION = n++;
        TEXT_COLOR_CPP_DATATYPE = n++;
        TEXT_COLOR_CPP_VARIABLE = n++;
        TEXT_COLOR_CPP_STRING = n++;
        TEXT_COLOR_CPP_PLAIN = n++;
        PATH_CPP_COMPILER_BIN = n++;
        PATH_CPP_VCVARSX86_AMD64_BAT = n++;
        EXE_CPP_COMPILE = n++;
        EXE_CPP_MAKE = n++;
        EXE_CPP_FLAGS = n++;
        TEXT_COLOR_MEL_COMMENT = n++;
        TEXT_COLOR_MEL_FUNCTION = n++;
        TEXT_COLOR_MEL_DATATYPE = n++;
        TEXT_COLOR_MEL_USER_VARIABLE = n++;
        TEXT_COLOR_MEL_COMMAND = n++;
        TEXT_COLOR_MEL_STRING = n++;
        TEXT_COLOR_MEL_PLAIN = n++;
        PATH_MEL_DOCS = n++;
        PATH_MEL_SCRIPTS = n++;
        PATH_MEL_STRIP = n++;
        PATH_ARNOLD_DEVKIT = n++;
        PATH_ARNOLD_USER_SHADER_SRC = n++;
        PATH_ARNOLD_USER_SHADER_DST = n++;
        ARNOLD_RENDER_IPR = n++;
        ARNOLD_DEVKIT_MTD_STYLE = n++;
        PATH_ARNOLD_USER_AETEMPLATES = n++;
        TEXT_COLOR_TCL_COMMENT = n++;
        TEXT_COLOR_TCL_FUNCTION = n++;
        TEXT_COLOR_TCL_USER_VARIABLE = n++;
        TEXT_COLOR_TCL_STRING = n++;
        TEXT_COLOR_TCL_PLAIN = n++;
        PATH_TCL_DOCS = n++;
        TEXT_COLOR_PERL_COMMENT = n++;
        TEXT_COLOR_PERL_FUNCTION = n++;
        TEXT_COLOR_PERL_USER_VARIABLE = n++;
        TEXT_COLOR_PERL_STRING = n++;
        TEXT_COLOR_PERL_PLAIN = n++;
        PATH_PERL_DOCS = n++;
        TEXT_COLOR_PYTHON_COMMENT = n++;
        TEXT_COLOR_PYTHON_BUILT_IN = n++;
        TEXT_COLOR_PYTHON_MODULE = n++;
        TEXT_COLOR_PYTHON_FUNCTION = n++;
        TEXT_COLOR_PYTHON_METHOD = n++;
        TEXT_COLOR_PYTHON_STRING = n++;
        TEXT_COLOR_PYTHON_CONSTANT = n++;
        PATH_PYTHON_DOCS = n++;
        PATH_PYSIDE2_DOCS = n++;
        PYTHON_COMMAND = n++;
        TEXT_COLOR_LPE_COMMENT = n++;
        TEXT_COLOR_LPE_KEYWORD = n++;
        TEXT_COLOR_LPE_EVENTYPE = n++;
        TEXT_COLOR_LPE_SCATTERTYPE = n++;
        TEXT_COLOR_LPE_RE_QUALIFIER = n++;
        TEXT_COLOR_LPE_STRING = n++;
        TEXT_COLOR_LPE_PLAIN = n++;
        TEXT_COLOR_JAVA_COMMENT = n++;
        TEXT_COLOR_JAVA_FUNCTION = n++;
        TEXT_COLOR_JAVA_DATATYPE = n++;
        TEXT_COLOR_JAVA_VARIABLE = n++;
        TEXT_COLOR_JAVA_STRING = n++;
        TEXT_COLOR_JAVA_PLAIN = n++;
        TEXT_COLOR_HTML_COMMENT = n++;
        TEXT_COLOR_HTML_TAG_IMAGE = n++;
        TEXT_COLOR_HTML_PLAIN = n++;
        TEXT_COLOR_HTML_STRING = n++;
        TEXT_COLOR_HTML_TAG_HREF = n++;
        TEXT_COLOR_HTML_TAG_GENERAL = n++;
        TEXT_COLOR_TXT_PLAIN = n++;
        TEXT_COLOR_SEE_COMMENT = n++;
        TEXT_COLOR_SEE_FUNCTION = n++;
        TEXT_COLOR_SEE_VARIABLE = n++;
        TEXT_COLOR_SEE_STRING = n++;
        TEXT_COLOR_SEE_PLAIN = n++;
        SLIM_SIGNATURE_AUTHOR = n++;
        SLIM_SIGNATURE_STUDIO = n++;
        SLIM_SIGNATURE_PREFIX = n++;
        SLIM_MAYA_IP = n++;
        SLIM_MAYA_PORT = n++;
        SLIM_STYLE = n++;
        HYPERSHADE_NODE_DIR = n++;
        HYPERSHADE_NODE_USER_MIN_ID = n++;
        HYPERSHADE_NODE_USER_MAX_ID = n++;
        HYPERSHADE_NODE_MAX_ID = n++;
        TEXT_FONT_NAME = n++;
        TEXT_TAB_SIZE = n++;
        TEXT_FONT_SIZE = n++;
        TEXT_FONT_WEIGHT = n++;
        TEXT_COLOR_MAXLENGTH = n++;
        TEXT_COLOR_ACTIVE = n++;
        DOCUMENT_LAST_OPEN = n++;
        DOCUMENT_RECENT_MAX = n++;
        DOCUMENT_RECENT_PATHS = n++;
        DOCUMENT_HISTORY_MAXCOUNT = n++;
        DOCUMENT_HISTORY_MAXBYTES = n++;
        DOCUMENT_HISTORY_ACTIVE = n++;
        DOCUMENT_LAST_SESSION_PATHS = n++;
        DOCUMENT_BACKGROUND_COLOR = n++;
        DOCUMENT_CARET_COLOR = n++;
        DOCUMENT_CARET_SELECTION_COLOR = n++;
        DOCUMENT_SECONDARY_SELECTIONS_COLOR = n++;
        DOCUMENT_CARET_DEFOCUSED_SELECTION_COLOR = n++;
        DOCUMENT_LINENUMBERING_ACTIVE = n++;
        DOCUMENT_TYPINGCOMPLETION_ACTIVE = n++;
        DOCUMENT_RIGHT_MARGIN_WIDTH = n++;
        DOCUMENT_RIGHT_MARGIN_COLOR = n++;
        TEMPLATES_USER_DIR_PATH = n++;
        CUTLETS_AUTHOR = n++;
        GUI_SWING_THEME = n++;
        UI_MENUBAR_SIZE = n++;
        UI_DIR_PRESETS_APPENDED_PATHS = n++;
        listOfListeners = new Vector();
        preference = null;
        prefsBaseDir = null;
        osxPrefFile = null;
        winPrefFile = null;
        linuxPrefFile = null;
        chooser = new JFileChooser();
        firstWrite = true;
        id = 1;
        counter = 1;
        maxcounter = 5;
        linesOfPrefs = null;
        parentPWDPath = FileUtils.getPWDParentFile().getPath();
        user_shader_srcPath = Url.join(parentPWDPath, Url.rman.user_shader_src_dirname);
        user_shadersPath = Url.join(parentPWDPath, Url.rman.user_shaders_dirname);
        user_texturesPath = Url.join(parentPWDPath, Url.rman.user_textures_dirname);
        user_framesPath = Url.join(parentPWDPath, Url.rman.user_frames_dirname);
    }
}

