/*
 * Decompiled with CFR 0.152.
 */
package Processes;

import Processes.ProcListener;
import Processes.ThreadedProcess;
import UI_Desktop.Cutter;
import UI_Tools.Monitor.Monitor;
import Utilities.EnvUtils;
import Utilities.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ProcessManager {
    public String panelName = "";
    private boolean silent = false;
    private boolean immediateMode = false;
    private File directory = null;
    private Vector listOfProcessListeners = new Vector();
    private boolean ignoreStreams = false;
    private boolean ignoreStdOutStream = false;
    private boolean ignoreStdErrStream = false;
    private static int processCount = 1;

    public ProcessManager() {
    }

    public ProcessManager(String panelName) {
        this.panelName = panelName;
    }

    public void ignoreStreams() {
        this.ignoreStreams = true;
    }

    public void ignoreStdOutStream() {
        this.ignoreStdOutStream = true;
    }

    public void ignoreStdErrStream() {
        this.ignoreStdErrStream = true;
    }

    public ThreadedProcess launch(String[] progarray, File procDir, boolean immediateMode, ProcListener listener, boolean silent, boolean trim) {
        return this.launch(progarray, null, procDir, immediateMode, listener, silent, trim);
    }

    public ThreadedProcess launch(String[] progarray, File procDir, boolean immediateMode, ProcListener listener, boolean silent) {
        return this.launch(progarray, null, procDir, immediateMode, listener, silent, true);
    }

    public ThreadedProcess launch(String[] progarray, String[] envVariables, File procDir, boolean immediateMode, ProcListener listener, boolean silent) {
        return this.launch(progarray, envVariables, procDir, immediateMode, listener, silent, true);
    }

    public ThreadedProcess launch(String[] progarray, String[] envVariables, File procDir, boolean immediateMode, ProcListener listener, boolean silent, boolean trim) {
        int last;
        String[] copy;
        this.immediateMode = immediateMode;
        this.silent = silent;
        boolean doEcho = true;
        progarray[0] = progarray[0].trim();
        if (progarray[0].equals("hcommand") && (copy = progarray)[last = progarray.length - 1].length() > 32) {
            copy[last] = copy[last].substring(0, 32);
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < progarray.length; ++n) {
            buf.append(progarray[n]).append("\n");
        }
        Monitor.echoCommand(buf.toString());
        if (!silent) {
            Monitor.setPanelText(this.panelName, "");
        }
        String timeStamp = "__________ [" + processCount + "] " + TextUtils.getTimeOfDay() + " __________";
        this.setMsg("");
        this.setMsg(timeStamp);
        if (!silent) {
            ++processCount;
        }
        final ThreadedProcess tp = new ThreadedProcess(this, envVariables, progarray, procDir, immediateMode, listener, trim);
        if (this.ignoreStreams) {
            tp.ignoreStreams();
        }
        if (this.ignoreStdOutStream) {
            tp.ignoreStdOutStream();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tp.start();
            }
        });
        return tp;
    }

    public synchronized void setMsg(String text) {
        this.setMsg(null, text);
    }

    public synchronized void setMsg(String targetPanelName, final String text) {
        String name;
        if (this.silent) {
            return;
        }
        String string = name = targetPanelName == null ? this.panelName : targetPanelName;
        if (text == null || text.trim().length() == 0) {
            Monitor.setPanelText(name, "");
            return;
        }
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                StringBuffer buff = new StringBuffer();
                char nextChar = '\u0000';
                Vector listOfBold = new Vector();
                boolean isManPage = false;
                boolean isDosPage = false;
                for (int n = 0; n < text.length(); ++n) {
                    nextChar = n + 1 < text.length() ? text.charAt(n + 1) : (char)'\u0000';
                    if (text.charAt(n) == '\u201a' && nextChar == '\u00f2' || text.charAt(n) == '\u201a') {
                        buff.append("\u2018");
                        continue;
                    }
                    if (text.charAt(n) == '\u00c4' && (nextChar == '\u00f2' || nextChar == '\u00f4')) {
                        buff.append("'");
                        continue;
                    }
                    if (text.charAt(n) >= '\u00b3') {
                        isDosPage = true;
                        buff.append(" ");
                        if (nextChar < '\u00b3') continue;
                        buff.append(" ");
                        ++n;
                        continue;
                    }
                    if (nextChar == '\b') {
                        isManPage = true;
                        ++n;
                        continue;
                    }
                    buff.append(text.charAt(n));
                }
                if (isDosPage) {
                    Monitor.setPanelText("Dos", "");
                    Monitor.appendPanelText("Dos", buff.append("\n").toString());
                    return;
                }
                if (isManPage) {
                    Monitor.setPanelText("Man Pages", "");
                    Monitor.appendPanelText("Man Pages", buff.append("\n").toString());
                    return;
                }
                Monitor.appendPanelText(name, buff.append("\n").toString());
            }
        });
    }

    public static void launchProcess(String command, StringBuffer out) {
        ProcessManager.launchProcess(command, out, true);
    }

    public static void launchProcess(String command) {
        command = command.trim();
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.destroy();
        }
        catch (IOException e) {
            Cutter.setLog("    Error:ProcessManager.launchProcess() using command >" + command + "<" + e);
        }
    }

    public static void launchProcess(String command, StringBuffer out, boolean useInputStream) {
        command = command.trim();
        StringBuffer tmp = new StringBuffer();
        try {
            int c;
            InputStream in;
            Process process = Runtime.getRuntime().exec(command);
            InputStream inputStream = in = useInputStream ? process.getInputStream() : process.getErrorStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            process.destroy();
        }
        catch (IOException e) {
            out.append(e.toString());
            Cutter.setLog("    Error:ProcessManager.launchProcess(1) using command >" + command + "<" + e);
        }
        out.append(tmp);
    }

    public void launchProcess(String cmd, String param, StringBuffer out, boolean useInputStream) {
        StringBuffer tmp = new StringBuffer();
        String[] progarray = new String[]{cmd.trim(), TextUtils.removeQuotes(param)};
        try {
            int c;
            InputStream in;
            Process process = Runtime.getRuntime().exec(progarray);
            InputStream inputStream = in = useInputStream ? process.getInputStream() : process.getErrorStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            process.destroy();
        }
        catch (IOException e) {
            out.append(e.toString());
        }
        out.append(tmp);
    }

    public void launchProcess(String cmd, String param, StringBuffer out) {
        StringBuffer tmp = new StringBuffer();
        String[] progarray = new String[]{cmd.trim(), TextUtils.removeQuotes(param)};
        try {
            int c;
            Process process = Runtime.getRuntime().exec(progarray);
            InputStream in = process.getInputStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            process.destroy();
        }
        catch (IOException e) {
            out.append(e.toString());
        }
        out.append(tmp);
    }

    public static void launchProcess(String[] progarray, StringBuffer out) {
        StringBuffer tmp = new StringBuffer();
        for (int n = 0; n < progarray.length; ++n) {
            progarray[n] = progarray[n].trim();
            progarray[n] = TextUtils.removeQuotes(progarray[n]);
        }
        try {
            int c;
            Process process = Runtime.getRuntime().exec(progarray);
            InputStream in = process.getErrorStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            process.destroy();
        }
        catch (IOException e) {
            out.append(e.toString());
            Cutter.setLog("    Error:ProcessManager.launchProcess(3) - " + e);
        }
        out.append(tmp);
    }

    public static void launchProcess(String[] progarray, StringBuffer out, boolean useInputStream) {
        StringBuffer tmp = new StringBuffer();
        for (int n = 0; n < progarray.length; ++n) {
            progarray[n] = progarray[n].trim();
            progarray[n] = TextUtils.removeQuotes(progarray[n]);
        }
        try {
            int c;
            InputStream in;
            Process process = Runtime.getRuntime().exec(progarray);
            InputStream inputStream = in = useInputStream ? process.getInputStream() : process.getErrorStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            process.destroy();
        }
        catch (IOException e) {
            out.append(e.toString());
            Cutter.setLog("    Error:ProcessManager.launchProcess(3) - " + e);
        }
        out.append(tmp);
    }

    public static void kill(String procName) {
        if (Cutter.input.nokill) {
            Cutter.setLog("    Info:ProcessManager.kill() - not killing " + procName + ". Nokill is set to true.");
            return;
        }
        Cutter.setLog("    Info:ProcessManager.kill() - " + procName);
        procName = procName.replace('\\', '/');
        int offset = procName.lastIndexOf(47);
        if (offset != -1) {
            procName = procName.substring(offset);
        }
        if (procName.equals("kill") || procName.equals("killall") || procName.equals("pskill")) {
            return;
        }
        if (procName.equals("renderdl") && Cutter.input.debug) {
            Cutter.setLog("    Debug:ProcessManager.kill() - not killing renderdl");
            return;
        }
        if (EnvUtils.isWinEnvironment()) {
            String[] arr = new String[]{"pskill", procName};
            ProcessManager.launchProcess(arr, new StringBuffer());
        } else {
            String[] arr = new String[]{"killall", procName};
            ProcessManager.launchProcess(arr, new StringBuffer());
        }
    }
}

