/*
 * Decompiled with CFR 0.152.
 */
package Processes;

import Processes.ProcListener;
import Processes.ProcessManager;
import Processes.ReadLineThread;
import UI_Desktop.Cutter;
import UI_Tools.Monitor.Monitor;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ThreadedProcess
extends Thread {
    private static Hashtable<String, ThreadedProcess> procTable = new Hashtable();
    private String[] progarray;
    private File procDir = null;
    private ReadLineThread stdErrThread = null;
    private ReadLineThread stdOutThread = null;
    private boolean reportImmediately;
    private Vector<ProcListener> listeners = new Vector();
    private ProcessManager manager = null;
    private Process process = null;
    private String uniqueID;
    private boolean ignoreStreams = false;
    private boolean ignoreStdOutStream = false;
    private boolean ignoreStdErrStream = false;
    private String[] envVariables = null;

    private static synchronized void addToProcList(String key, ThreadedProcess proc) {
        String procName = key;
        Enumeration<String> enumm = procTable.keys();
        while (enumm.hasMoreElements()) {
            String nom = enumm.nextElement();
            if (nom == null || !procName.equals(nom)) continue;
            ThreadedProcess.killProcWithID(nom);
        }
        procTable.put(key, proc);
    }

    public static void killProcWithID(String key) {
        if (Cutter.input.nokill) {
            Cutter.setLog("    Info:ThreadedProcess.killProcWithID() - not killing " + key + ". Nokill is set to true.");
            return;
        }
        ThreadedProcess tp = procTable.get(key);
        if (!key.endsWith("renderdl")) {
            Cutter.setLog("    Debug:ThreadedProcess.killProcWithID() not killing proc \"" + key + "\"");
            return;
        }
        if (tp != null) {
            Cutter.setLog("    Debug:ThreadedProcess.killProcWithID() killing proc \"" + key + "\"");
            if (tp != null && tp.stdErrThread != null) {
                tp.stdErrThread.doTerminate();
            }
            if (tp != null && tp.stdOutThread != null) {
                tp.stdOutThread.doTerminate();
            }
            if (tp.process != null) {
                tp.process.destroy();
            }
            tp.stdErrThread = null;
            tp.stdOutThread = null;
            procTable.remove(key);
        } else {
            Cutter.setLog("    Warning:ThreadedProcess.killProcWithID() could not find a process named \"" + key + "\"");
        }
    }

    private static void removeProcFromTable(String key) {
        procTable.remove(key);
    }

    private void ___THREADED_PROCESS__METHODS________() {
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public ThreadedProcess(ProcessManager manager, String[] envVariables, String[] arr, File dir, boolean immediate, ProcListener l) {
        this(manager, envVariables, arr, dir, immediate, l, true);
    }

    public ThreadedProcess(ProcessManager manager, String[] envVariables, String[] arr, File dir, boolean immediate, ProcListener l, boolean trim) {
        super("ThreadedProcess.name - " + arr[0]);
        this.manager = manager;
        this.envVariables = envVariables;
        this.progarray = new String[arr.length];
        this.procDir = dir;
        this.reportImmediately = immediate;
        if (l != null) {
            this.listeners.addElement(l);
        }
        for (int n = 0; n < this.progarray.length; ++n) {
            this.progarray[n] = trim ? arr[n].trim() : arr[n];
            this.progarray[n] = TextUtils.removeQuotes(this.progarray[n]);
        }
        this.setPriority(10);
        this.uniqueID = arr[0];
        ThreadedProcess.addToProcList(this.uniqueID, this);
    }

    public ThreadedProcess(ProcessManager manager, String[] arr, File dir, boolean immediate, ProcListener l) {
        super("ThreadedProcess.name - " + arr[0]);
        this.manager = manager;
        this.progarray = new String[arr.length];
        this.procDir = dir;
        this.reportImmediately = immediate;
        if (l != null) {
            this.listeners.addElement(l);
        }
        for (int n = 0; n < this.progarray.length; ++n) {
            this.progarray[n] = arr[n].trim();
            this.progarray[n] = TextUtils.removeQuotes(this.progarray[n]);
        }
        this.setPriority(10);
        this.uniqueID = arr[0];
        ThreadedProcess.addToProcList(this.uniqueID, this);
    }

    public void ignoreStreams() {
        this.ignoreStreams = true;
    }

    public void ignoreStdOutStream() {
        this.ignoreStdOutStream = true;
    }

    public void ignoreStdErrStream() {
        this.ignoreStdErrStream = true;
    }

    @Override
    public void run() {
        String stdErrLabel = this.progarray[0] + "-errors";
        String stdOutLabel = this.progarray[0] + "-process";
        StringBuffer msgOutBuf = new StringBuffer();
        StringBuffer stdErrBuf = new StringBuffer();
        StringBuffer stdOutBuf = new StringBuffer();
        try {
            this.process = Runtime.getRuntime().exec(this.progarray, null, this.procDir);
            InputStream inputStream = this.process.getInputStream();
            BufferedReader inputProcess = new BufferedReader(new InputStreamReader(inputStream));
            InputStream errorStream = this.process.getErrorStream();
            BufferedReader errorProcess = new BufferedReader(new InputStreamReader(errorStream));
            OutputStream outputStream = this.process.getOutputStream();
            PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            outputWriter.println("");
            outputWriter.flush();
            outputWriter.close();
            Vector<ProcListener> tmp = new Vector<ProcListener>();
            for (int n = 0; n < this.listeners.size(); ++n) {
                if (this.listeners.elementAt(n) == null) continue;
                tmp.addElement(this.listeners.elementAt(n));
            }
            if (this.reportImmediately) {
                tmp.addElement(Monitor.getInstance());
            }
            ProcListener[] pl = null;
            if (tmp.size() > 0) {
                pl = new ProcListener[tmp.size()];
                for (int n = 0; n < tmp.size(); ++n) {
                    pl[n] = (ProcListener)tmp.elementAt(n);
                }
            }
            this.stdErrThread = new ReadLineThread(this.manager.panelName, errorProcess, stdErrBuf, stdErrLabel, pl);
            this.stdOutThread = new ReadLineThread(this.manager.panelName, inputProcess, stdOutBuf, stdOutLabel, pl);
            this.fireProcessStarted();
            boolean startStdOutStream = true;
            boolean startStdErrStream = true;
            if (this.ignoreStreams) {
                startStdOutStream = false;
                startStdErrStream = false;
            }
            if (this.ignoreStdOutStream) {
                startStdOutStream = false;
            }
            if (Cutter.input.ignoreStdOutStream) {
                startStdOutStream = false;
            }
            if (this.ignoreStdErrStream) {
                startStdErrStream = false;
            }
            if (Cutter.input.ignoreStdErrStream) {
                startStdErrStream = false;
            }
            if (startStdOutStream) {
                this.stdOutThread.start();
            }
            if (startStdErrStream) {
                this.stdErrThread.start();
            }
            int result = this.process.waitFor();
            if (!this.progarray[0].equalsIgnoreCase("ray")) {
                ThreadedProcess.sleep(1000L);
            }
            msgOutBuf.append(stdErrBuf).append(stdOutBuf);
            errorStream.close();
            errorProcess.close();
            inputStream.close();
            inputProcess.close();
            this.process.destroy();
            this.process = null;
            this.stdErrThread = null;
            this.stdOutThread = null;
        }
        catch (Exception e) {
            Cutter.setLog("    Debug:ThreadedProcess.run()\n        " + e.toString());
        }
        ThreadedProcess.removeProcFromTable(this.uniqueID);
        if (!this.reportImmediately) {
            this.manager.setMsg(msgOutBuf.toString());
        }
        this.fireProcessFinished();
    }

    private void fireProcessStarted() {
        Monitor.getInstance().processStarted(this.manager.panelName, this.progarray, this.uniqueID);
        for (int n = 0; n < this.listeners.size(); ++n) {
            this.listeners.elementAt(n).processStarted(this.progarray[0], this.progarray, this.uniqueID);
        }
    }

    private void fireProcessFinished() {
        Monitor.getInstance().processFinished(this.progarray);
        for (int n = 0; n < this.listeners.size(); ++n) {
            this.listeners.elementAt(n).processFinished(this.progarray);
        }
    }

    private void writeLogFile(String errors, String msgs, String stats) {
        try {
            final File logfile = new File(FileUtils.getPWD(), "rman_monitor.log");
            final StringBuffer log = new StringBuffer();
            log.append("RenderMan log generated by Cutter version " + Cutter.version + " for file:\n" + this.progarray[this.progarray.length - 1] + "\non:");
            String[] time = DateTimeUtils.getDateTime();
            log.append(time[0] + " at " + time[1] + "\n\n");
            log.append("======= Error Messages ========\n");
            log.append(errors.length() == 0 ? "No errors" : errors);
            log.append("\n");
            log.append("======= Non Error Messages ========\n");
            if (stats.trim().length() > 0) {
                log.append(stats + "\n");
            }
            log.append(msgs.length() == 0 ? "No messages" : msgs);
            Thread logger = new Thread(){

                @Override
                public void run() {
                    FileUtils.writeFile(logfile, log.toString());
                }
            };
            SwingUtilities.invokeLater(logger);
        }
        catch (NullPointerException ex) {
            Cutter.setLog("    Error: MonitorPanel.ProcessInfoThread().run " + ex);
        }
    }
}

