/*
 * Decompiled with CFR 0.152.
 */
package Session;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DateTimeUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SessionManager {
    private static String ITEM_SEPARATOR = "---";
    private static String SESSION_SEPARATOR = "===================================";
    public static int MAX_SESSIONS = 50;
    private static String UNKNOWN_PATH = "unknown";
    private static String UNKNOWN_TIME = "unknown";
    private static String UNKNOWN_VERSION = "unknown";
    private static String WINDOWS_SESSION_NAME = "win_sessions.txt";
    private static String OSX_SESSION_NAME = "osx_sessions.txt";
    private static String LINUX_SESSION_NAME = "linux_sessions.txt";
    private String date = "";
    private Hashtable<String, DocDBItem> tableOfDBItems = new Hashtable();
    private static SessionManager instance = null;

    public static SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
            SessionManager.instance.date = SessionManager.getTimeStamp();
        }
        return instance;
    }

    public File[] getCurrentDirectories() {
        if (this.tableOfDBItems.isEmpty()) {
            return null;
        }
        Vector<File> v = new Vector<File>();
        Enumeration<DocDBItem> e = this.tableOfDBItems.elements();
        while (e.hasMoreElements()) {
            DocDBItem item = e.nextElement();
            String opened = item.openedPath;
            String closed = item.closedPath;
            String path = opened.equals(UNKNOWN_PATH) ? closed : opened;
            if (path.equals(UNKNOWN_PATH)) continue;
            v.addElement(new File(path).getParentFile());
        }
        if (this.tableOfDBItems.isEmpty()) {
            return null;
        }
        File[] out = new File[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (File)v.elementAt(n);
        }
        return out;
    }

    public DocDBItem opened(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        DocDBItem item = new DocDBItem(path);
        item.opened = SessionManager.getTimeStamp();
        KAbstractWindow w = KAbstractDesktop.getWindowWithPath(path);
        File f = null;
        if (w != null && w instanceof KAbstractTextWindow) {
            f = ((KAbstractTextWindow)w).getFile();
        }
        if (f == null) {
            return null;
        }
        item.openedBytes = f.length();
        this.tableOfDBItems.put(path, item);
        return item;
    }

    public void parent(String path, String parent) {
        if (path == null || path.trim().length() == 0) {
            return;
        }
        if (parent == null || parent.trim().length() == 0) {
            return;
        }
        DocDBItem obj = this.tableOfDBItems.get(path);
        if (obj == null) {
            return;
        }
        DocDBItem item = obj;
        item.parentPath = parent;
    }

    public void saved(String path) {
        DocDBItem item;
        DocDBItem obj = this.tableOfDBItems.get(path);
        if (obj == null) {
            item = this.opened(path);
            if (path != null && item != null) {
                this.tableOfDBItems.put(path, item);
            }
        } else {
            item = obj;
        }
        if (item != null) {
            ++item.saved;
        }
    }

    public void closed(String path) {
        DocDBItem item;
        if (path == null) {
            return;
        }
        DocDBItem obj = this.tableOfDBItems.get(path);
        if (obj == null) {
            item = this.opened(path);
            if (item == null) {
                return;
            }
            this.tableOfDBItems.put(path, item);
        } else {
            item = obj;
        }
        item.closed = SessionManager.getTimeStamp();
        item.closedPath = path;
        KAbstractWindow w = KAbstractDesktop.getWindowWithPath(path);
        File f = null;
        if (w != null && w instanceof KAbstractTextWindow) {
            f = ((KAbstractTextWindow)w).getFile();
        }
        if (f != null) {
            item.closedBytes = f.length();
        }
    }

    private static String getTimeStamp() {
        int last;
        String[] dt = DateTimeUtils.getDateTime();
        String dayStr = DateTimeUtils.getDayOfWeek(dt[0]);
        String month = UNKNOWN_TIME;
        String[] dateTok = TextUtils.tokenize(dt[0], '.');
        if (dateTok.length == 3) {
            month = DateTimeUtils.getMonthOfYear(Integer.parseInt(dateTok[0]));
        }
        if ((last = dt[1].lastIndexOf(58)) != -1) {
            dt[1] = dt[1].substring(0, last);
        }
        return dayStr + " " + dateTok[1] + " " + month + " " + dateTok[2] + " at " + dt[1] + " " + dt[2];
    }

    private File getSessionFile() {
        File f = FileUtils.getPWDFile();
        if (f == null) {
            Cutter.setLog("    Error:SessionsManager.getSessionFile() - FileUtils.getPWDFile() returned null");
            return null;
        }
        String sessionFileName = WINDOWS_SESSION_NAME;
        if (EnvUtils.isLinuxEnvironment()) {
            sessionFileName = LINUX_SESSION_NAME;
        } else if (EnvUtils.isOSXEnvironment()) {
            sessionFileName = OSX_SESSION_NAME;
        }
        f = new File(f, "Cutter_Prefs");
        f = new File(f, sessionFileName);
        if (!f.exists()) {
            Cutter.setLog("    Info: SessionManager.getSessionFile() - \"" + sessionFileName + "\" does not exist.");
        }
        return f;
    }

    public String readFromFile() {
        this.handleLegacyFile();
        File f = this.getSessionFile();
        if (f == null) {
            Cutter.setLog("    Info: SessionManager.readFromFile() - FileUtils.getSessionFile() returned null");
            return "";
        }
        return FileUtils.read(f);
    }

    private void handleLegacyFile() {
        File f = FileUtils.getPWDFile();
        if (f == null || !f.exists()) {
            return;
        }
        File prefDir = new File(f, "Cutter_Prefs");
        File oldDoc = new File(prefDir, "sessions.txt");
        String sessionFileName = WINDOWS_SESSION_NAME;
        if (EnvUtils.isLinuxEnvironment()) {
            sessionFileName = LINUX_SESSION_NAME;
        } else if (EnvUtils.isOSXEnvironment()) {
            sessionFileName = OSX_SESSION_NAME;
        }
        File newDoc = new File(prefDir, sessionFileName);
        if (oldDoc.exists() && !newDoc.exists()) {
            FileUtils.copy(oldDoc, newDoc);
            Cutter.setLog("    Info:SessionManager.handleLegacyFile() - old sessions.txt copied to \"" + sessionFileName + "\"");
            oldDoc.delete();
        }
        if (oldDoc.exists() && newDoc.exists()) {
            oldDoc.delete();
        }
    }

    public void writeToFile() {
        StringBuffer text = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        String s = this.readFromFile();
        if (s != null && s.trim().length() > 0) {
            text.append(s);
        }
        Enumeration<DocDBItem> e = this.tableOfDBItems.elements();
        while (e.hasMoreElements()) {
            DocDBItem item = e.nextElement();
            String txt = item.toString();
            if (txt == null) continue;
            temp.append(txt);
        }
        if (temp.length() == 0) {
            return;
        }
        text.append(SESSION_SEPARATOR).append("\n");
        text.append("DATE: ").append(SessionManager.getTimeStamp()).append("\n");
        text.append("VERSION: ").append(Cutter.version).append("\n");
        text.append(temp);
        String[] sessions = this.getSessionsAsStrings(text.toString(), MAX_SESSIONS);
        if (sessions == null) {
            return;
        }
        text.setLength(0);
        for (int n = 0; n < sessions.length; ++n) {
            text.append(SESSION_SEPARATOR).append("\n");
            text.append(sessions[n]);
        }
        File f = this.getSessionFile();
        if (f == null) {
            Cutter.setLog("    Error:SessionManager.writeToFile() - Cannot write to sessions.txt. FileUtils.getSessionFile() returned null");
            return;
        }
        FileUtils.writeFile(f, text.toString());
    }

    public String[] getSessionsAsStrings(String text, int max) {
        int ignore;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        String[] lines = TextUtils.tokenize(text, '\n');
        StringBuffer tmp = new StringBuffer();
        Vector<String> listOfSessions = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (line.equals(SESSION_SEPARATOR)) {
                if (tmp.length() > 0) {
                    listOfSessions.addElement(tmp.toString());
                }
                tmp.setLength(0);
                continue;
            }
            if (line.trim().length() <= 0) continue;
            tmp.append(line).append("\n");
        }
        if (tmp.length() > 0) {
            listOfSessions.addElement(tmp.toString());
        }
        if ((ignore = listOfSessions.size() - max) < 0) {
            ignore = 0;
        }
        String[] out = new String[listOfSessions.size() - ignore];
        int i = 0;
        for (int n = 0; n < listOfSessions.size(); ++n) {
            if (n < ignore) continue;
            out[i++] = (String)listOfSessions.elementAt(n);
        }
        return out;
    }

    public DocDBItem[] _parse(String text) {
        String[] blocks = TextUtils.tokenize(text, SESSION_SEPARATOR);
        System.out.println("blocks size = " + blocks.length);
        for (int n = 0; n < blocks.length; ++n) {
            System.out.println(">>" + blocks[n] + "<<");
        }
        return null;
    }

    public SessionDBItem[] getDBFromDisk() {
        String str = this.readFromFile();
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        String[] sessions = this.getSessionsAsStrings(str.toString(), MAX_SESSIONS);
        if (sessions.length == 0) {
            return null;
        }
        Vector<SessionDBItem> listOfSessions = new Vector<SessionDBItem>();
        for (int n = 0; n < sessions.length; ++n) {
            String[] lines;
            String[] blocks = TextUtils.chop(sessions[n], ITEM_SEPARATOR);
            if (blocks.length == 0 || (lines = TextUtils.tokenize(blocks[0], '\n')).length != 2) continue;
            String dateStr = lines[0].trim();
            String versStr = lines[1].trim();
            dateStr = dateStr.startsWith("DATE:") ? dateStr.substring(5).trim() : UNKNOWN_TIME;
            versStr = versStr.startsWith("VERSION:") ? versStr.substring(8).trim() : UNKNOWN_VERSION;
            SessionDBItem sessionDBItem = new SessionDBItem(dateStr, versStr);
            for (int i = 1; i < blocks.length; ++i) {
                DocDBItem dbItem = this.DBItemFromString(blocks[i]);
                if (dbItem == null) continue;
                sessionDBItem.docs.addElement(dbItem);
            }
            listOfSessions.addElement(sessionDBItem);
        }
        SessionDBItem[] out = new SessionDBItem[listOfSessions.size()];
        for (int n = 0; n < listOfSessions.size(); ++n) {
            out[n] = (SessionDBItem)listOfSessions.elementAt(n);
        }
        return out;
    }

    public DocDBItem DBItemFromString(String block) {
        String[] lines = TextUtils.tokenize(block, '\n');
        if (lines.length != 7) {
            Cutter.setLog("    Error:SessionManager.DBItemFromString() - could not find 7 lines in\n" + block + "\n");
            return null;
        }
        DocDBItem out = new DocDBItem();
        out.openedPath = lines[0].substring(11).trim();
        out.closedPath = lines[1].substring(11).trim();
        out.opened = lines[2].substring(9).trim();
        out.closed = lines[3].substring(9).trim();
        out.openedBytes = Long.parseLong(lines[4].substring(12).trim());
        out.closedBytes = Long.parseLong(lines[5].substring(12).trim());
        out.saved = Integer.parseInt(lines[5].substring(12).trim());
        return out;
    }

    public SessionDBItem[] cullNonExistingFiles(SessionDBItem[] inputDB) {
        if (inputDB == null) {
            return null;
        }
        Vector<SessionDBItem> listOfSessions = new Vector<SessionDBItem>();
        Vector<DocDBItem> listOfDocDBItems = new Vector<DocDBItem>();
        for (int n = 0; n < inputDB.length; ++n) {
            SessionDBItem session = inputDB[n];
            boolean sessionIsValid = false;
            for (int i = 0; i < session.docs.size(); ++i) {
                DocDBItem docItem = session.docs.elementAt(i);
                File f = new File(docItem.closedPath);
                if (!f.exists()) continue;
                listOfDocDBItems.addElement(docItem);
                sessionIsValid = true;
            }
            if (!sessionIsValid) continue;
            SessionDBItem temp = new SessionDBItem(session.date, session.version);
            for (int j = 0; j < listOfDocDBItems.size(); ++j) {
                temp.docs.addElement((DocDBItem)listOfDocDBItems.elementAt(j));
            }
            listOfSessions.addElement(temp);
        }
        if (listOfSessions.size() == 0) {
            return null;
        }
        SessionDBItem[] outputDB = new SessionDBItem[listOfSessions.size()];
        for (int n = 0; n < outputDB.length; ++n) {
            outputDB[n] = (SessionDBItem)listOfSessions.elementAt(n);
        }
        return outputDB;
    }

    public class DocDBItem {
        public String opened = SessionManager.access$000();
        public String closed = SessionManager.access$000();
        public long openedBytes = 0L;
        public long closedBytes = 0L;
        public int saved = 0;
        public String openedPath = SessionManager.access$000();
        public String closedPath = SessionManager.access$000();
        public String parentPath = null;
        public String parent = SessionManager.access$000();
        public String child = SessionManager.access$000();

        public DocDBItem() {
        }

        public DocDBItem(String path) {
            this.openedPath = path;
            this.closedPath = path;
        }

        public String toString() {
            if (this.openedPath.equals(UNKNOWN_PATH)) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(ITEM_SEPARATOR).append("\n");
            if (this.parentPath == null) {
                buf.append("openedPath: ").append(this.openedPath).append("\n");
            } else {
                buf.append("openedPath: ").append(this.parentPath).append("\n");
            }
            buf.append("closedPath: ").append(this.closedPath).append("\n");
            buf.append("openedAt: ").append(this.opened).append("\n");
            buf.append("closedAt: ").append(this.closed).append("\n");
            buf.append("openedBytes: ").append(this.openedBytes).append("\n");
            buf.append("closedBytes: ").append(this.closedBytes).append("\n");
            buf.append("saved: ").append(this.saved).append("\n");
            return buf.toString();
        }
    }

    public class SessionDBItem {
        public String date = null;
        public String version = null;
        public Vector<DocDBItem> docs = new Vector();

        public SessionDBItem(String date, String version) {
            this.date = date;
            this.version = version;
        }
    }
}

