/*
 * Decompiled with CFR 0.152.
 */
package UI_Actions;

import UI_BBXT.BBxt;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.Position;

public class ReverseStringsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    @Override
    public void actionPerformed(ActionEvent e) {
        int end;
        KAbstractWindow w = KAbstractDesktop.getFrontWindow();
        if (!(w instanceof KTextWindow)) {
            return;
        }
        int begin = BBxt.getSelectionStart();
        if (begin == (end = BBxt.getSelectionEnd()) || begin == -1 && end == -1) {
            return;
        }
        KTextWindow window = (KTextWindow)w;
        KTextPane textpane = window.getTextPane();
        Position[][] p = textpane.getLines(begin, end);
        if (p == null || p.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < p.length; ++n) {
            String[] token;
            String str = BBxt.getSelection(p[n][0].getOffset(), p[n][1].getOffset());
            if (str == null || str.length() == 0 || (token = TextUtils.tokenize(str)) == null || token.length == 0) continue;
            sb.setLength(0);
            for (int j = token.length - 1; j >= 0; --j) {
                if (token[j].length() <= 2 && token[j].endsWith(".")) continue;
                if (token[j].endsWith(",")) {
                    token[j] = token[j].substring(0, token[j].length() - 1);
                }
                sb.append(token[j] + " ");
            }
            out.append(sb.toString().trim() + "\n");
        }
        BBxt.setSelection(begin, end);
        BBxt.paste(out.toString());
    }
}

