/*
 * Decompiled with CFR 0.152.
 */
package UI_BBXT;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.LinuxCommands;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Comment;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Mel.MelListener;
import UI_Script.Osl.OslTokenizer;
import UI_Script.Python.PythonListener;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Script.See.SeeListener;
import UI_Script.Syntax;
import UI_Script.SyntaxListener;
import UI_Script.Tcl.TclTokenizer;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTextPane;
import UI_Text.KTextPane.KWordHiliter;
import UI_Text.Style.KStyleContext;
import UI_Tools.Find.FindTool;
import UI_Tools.Find.FindToolListener;
import UI_Tools.KTools;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.HTMLWindow;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.BrowserUtils;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.NumberUtils;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import kernal.Tokenizers.FindReplaceTokenizer;
import kernal.Tokenizers.Tokenizer;

public class BBxt {
    public static final String[] dos = new String[]{"assoc", "at", "attrib", "break", "cacls", "call", "cd", "chcp", "chdir", "chkdsk", "chkntfs", "cls", "cmd", "color", "comp", "compact", "convert", "copy", "date", "del", "dir", "diskcomp", "diskcopy", "doskey", "echo", "endlocal", "erase", "exit", "fc", "find", "findstr", "for", "format", "ftype", "goto", "graftabl", "help", "if", "label", "md", "mkdir", "mode", "more", "move", "path", "pause", "popd", "print", "prompt", "pushd", "rd", "recover", "rem", "ren", "rename", "replace", "rmdir", "set", "setlocal", "shift", "sort", "start", "subst", "time", "title", "tree", "type", "ver", "verify", "vol", "xcopy", "ftp"};
    public static boolean _JTextComp_pasteNoRemove = true;
    public static boolean _JTextPane_replaceSelection = true;
    private static FindReplaceTokenizer findReplaceTokenizer;

    public static KAbstractWindow frontWindow() {
        return KAbstractDesktop.getFrontWindow();
    }

    public static void newDocument(String title) {
        KTextWindow.addWindow(title);
    }

    public static void newDocument(String title, StringBuffer text) {
        KTextWindow.addWindow(title, text.toString(), true, true, true, true);
    }

    public static void newDocument(String title, String text) {
        KTextWindow.addWindow(title, text, true, true, true, true);
    }

    public static void newDocument(File file) {
        System.gc();
        KAbstractWindow window = KAbstractDesktop.getWindowWithFile(file);
        if (window == null) {
            if (KTextWindow.okToOpenFile(file)) {
                KTextWindow.addWindow(file, true, true, true, true);
            }
        } else {
            KAbstractDesktop.toFront(window);
        }
    }

    public static void newDocument(URL url) {
        URLConnection connection = null;
        StringBuffer buff = new StringBuffer();
        try {
            String str;
            connection = url.openConnection();
            Object obj = connection.getContent();
            if (obj == null || !(obj instanceof InputStream)) {
                Cutter.setLog("    Error: BBxt.newDocument(URL) - object returned from url connection is not of class InputStream");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)obj));
            LineNumberReader lnr = new LineNumberReader(reader);
            while ((str = lnr.readLine()) != null) {
                buff.append(str).append('\n');
            }
            lnr.close();
            reader.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: BBxt.newDocument(URL)\n" + e.toString());
            return;
        }
        String path = url.getPath();
        if (path == null) {
            Cutter.setLog("    Error: BBxt.newDocument(URL) url.getPath() return null");
            return;
        }
        int index = path.lastIndexOf(47);
        if (index == -1) {
            Cutter.setLog("    Error: BBxt.newDocument(URL) - cannot find the last occurance of '/' ");
            return;
        }
        String name = path.substring(index + 1);
        String[] parts = TextUtils.tokenize(name, ".");
        if (parts == null) {
            Cutter.setLog("    Error: BBxt.newDocument(URL) - cannot find the name of the url file");
            return;
        }
        name = parts.length == 1 ? parts[0] : (parts.length > 1 ? parts[0] + "." + parts[1] : "untitled");
        BBxt.newDocument(name, buff);
    }

    public static void iconifyAllTextWindows() {
        KAbstractWindow[] aw = KAbstractDesktop.getAllWindows();
        if (aw != null) {
            for (int n = 0; n < aw.length; ++n) {
                if (aw[n].isIcon()) continue;
                aw[n].iconifySelf();
            }
        }
    }

    public static void deIconifyAllTextWindows() {
        KAbstractWindow[] aw = KAbstractDesktop.getAllWindows();
        if (aw != null) {
            for (int n = 0; n < aw.length; ++n) {
                if (!aw[n].isIcon()) continue;
                aw[n].deIconifySelf();
            }
        }
    }

    public static int getSelectionLength() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return -1;
        }
        return textpane.getSelectionEnd() - textpane.getSelectionStart();
    }

    public static boolean isSelection() {
        return BBxt.getSelectionLength() > 0;
    }

    public static int getSelectionStart() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return -1;
        }
        return textpane.getSelectionStart();
    }

    public static int getSelectionEnd() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return -1;
        }
        return textpane.getSelectionEnd();
    }

    public static String getSelection() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        int endOffset = textpane.getSelectionEnd();
        int startOffset = textpane.getSelectionStart();
        int length = endOffset - startOffset;
        try {
            return textpane.getDocument().getText(startOffset, length);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: BBxt.getSelection() " + e);
            return null;
        }
    }

    public static Segment getSelection(Segment segment) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        Document document = textpane.getDocument();
        if (segment == null) {
            segment = new Segment();
        }
        try {
            int length = textpane.getSelectionEnd() - textpane.getSelectionStart();
            document.getText(textpane.getSelectionStart(), length, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: BBxt.getSelection(Segment)" + ex);
            return null;
        }
        return segment;
    }

    public static String getSelection(int begin, int end) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        int length = end - begin;
        try {
            return textpane.getDocument().getText(begin, length);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: BBxt.getSelection(int, int) " + e);
            return null;
        }
    }

    public static String getSelectionFromAbstractTextWindow(KAbstractTextWindow window) {
        if (window == null) {
            Cutter.setLog("    Error:BBxt.getSelection(KAbstractTextWindow window) - window is null!");
            return null;
        }
        KTextPane textpane = window.getTextPane();
        if (textpane == null) {
            Cutter.setLog("    Error:BBxt.getSelection(KAbstractTextWindow window) - windows textpane is null!");
            return null;
        }
        int length = textpane.getSelectionEnd() - textpane.getSelectionStart();
        if (length == 0) {
            return window.getText();
        }
        String selection = null;
        try {
            selection = textpane.getDocument().getText(textpane.getSelectionStart(), length);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception:BBxt.getSelection(KAbstractTextWindow window) " + e);
            return null;
        }
        return selection;
    }

    public static void setSelection(int selectionStart, int selectionEnd) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            KAbstractWindow w = BBxt.frontWindow();
            if (w != null) {
                Cutter.setLog("    Info: BBxt.setSelection() - JEditorPane for window \"" + w.getTitle() + "\" is null");
            } else {
                Cutter.setLog("    Info: BBxt.setSelection() - BBxt.frontWindow() return null");
            }
            return;
        }
        textpane.setSelectionStart(selectionStart);
        textpane.setSelectionEnd(selectionEnd);
        textpane.requestFocus();
    }

    public static void setEditable(boolean flag) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        if (Cutter.input.debug) {
            Cutter.setLog("BBxt.setEditable() calling textpane.setEditable()");
        }
        textpane.setEditable(flag);
    }

    public static boolean isEditable() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        return textpane.isEditable();
    }

    public static void setCursor(Cursor type) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        textpane.setCursor(type);
    }

    public static KCaret getKCaret() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return null;
        }
        return ((KTextPane)textpane).getKCaret();
    }

    public static String selectWord() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        if (textpane instanceof KTextPane) {
            return ((KTextPane)textpane).selectWord();
        }
        return null;
    }

    public static void selectAll() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        textpane.setSelectionStart(0);
        textpane.setSelectionEnd(textpane.getDocument().getLength());
    }

    public static void autoHiliteError(File file, String info) {
        if (info == null || info.length() == 0) {
            return;
        }
        String[] tokens = TextUtils.tokenize(info);
        if (tokens == null) {
            return;
        }
        KAbstractWindow window = KAbstractDesktop.getWindowOfClass("UI_Window.KWindow.KTextWindow");
        String numStr = null;
        for (int n = 0; n < tokens.length; ++n) {
            if (!tokens[n].equalsIgnoreCase("line") || n + 1 >= tokens.length) continue;
            numStr = tokens[n + 1];
            break;
        }
        String tail = null;
        Pattern pattern = Pattern.compile("([^0-9]*)([0-9]*)([^0-9]*)");
        if (numStr != null && numStr.contains(".")) {
            String[] t = TextUtils.tokenize(numStr, ".");
            numStr = t[0];
        } else if (file != null && numStr == null) {
            for (int n = 0; n < tokens.length; ++n) {
                Pattern pat;
                Matcher mm;
                tail = null;
                if (tokens[n].startsWith(file.getName()) && tokens[n].length() > file.getName().length()) {
                    tail = tokens[n].substring(file.getName().length());
                } else if (tokens[n].startsWith(file.getPath()) && tokens[n].length() > file.getPath().length()) {
                    tail = tokens[n].substring(file.getPath().length());
                }
                if (tail != null) {
                    Matcher m;
                    String[] s;
                    if (tail.contains(":") && (s = TextUtils.tokenize(tail, ":")) != null && s.length > 1) {
                        tail = s[0];
                    }
                    if ((m = pattern.matcher(tail)).matches() && m.groupCount() >= 3) {
                        numStr = m.group(2).trim();
                    }
                }
                if (numStr != null || !(mm = (pat = Pattern.compile(".*:(([0-9]+))[^0-9]*")).matcher(info)).matches() || mm.groupCount() <= 1) continue;
                numStr = mm.group(1).trim();
            }
        }
        File toBecomeFront = null;
        if (numStr == null && tokens.length > 0) {
            Matcher m;
            int offset = tokens[0].indexOf(40);
            String head = null;
            if (offset != -1 && new File(head = tokens[0].substring(0, offset)).exists() && (m = pattern.matcher(tail = tokens[0].substring(offset))).matches() && m.groupCount() >= 3) {
                numStr = m.group(2).trim();
                toBecomeFront = new File(head);
                KAbstractWindow w = KAbstractDesktop.getWindowWithFile(toBecomeFront);
                if (w == null) {
                    BBxt.newDocument(toBecomeFront);
                }
            }
        }
        if (numStr != null) {
            int lineNum;
            numStr = TextUtils.trimInt(numStr);
            try {
                lineNum = Integer.parseInt(numStr);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (toBecomeFront != null) {
                window = KAbstractDesktop.getWindowWithFile(toBecomeFront);
            }
            KAbstractDesktop.toFront(window, true);
            BBxt.hilitLineNumber(lineNum);
            final int num = lineNum;
            final KAbstractWindow win = window;
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (win != null) {
                            BBxt.hilitLineNumber(num);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void cut() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null) {
            textpane.cut();
        } else {
            Cutter.setLog("BBxt.cut couldn't find textpane for front window");
        }
    }

    public static void copy() {
        JEditorPane textpane = KTools.getFocusedEditorPane();
        if (textpane == null) {
            textpane = BBxt.getTextPane(BBxt.frontWindow());
        }
        if (textpane != null) {
            textpane.copy();
        } else {
            Cutter.setLog("    Error:BBxt.copy couldn't find textpane for front window");
        }
    }

    public static void copyToClipboard(String str, ClipboardOwner owner) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(str), owner);
    }

    public static String copyFromClipboard() {
        Object isIgnored;
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable trans = cb.getContents(isIgnored = new Object());
        if (trans == null) {
            Cutter.setLog("    Info:BBxt.copyFromClipboard() nothing on the clipboard.");
            return null;
        }
        Object obj = null;
        try {
            obj = trans.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:BBxt.copyFromClipboard() - \n\t\t" + ex.toString());
            return null;
        }
        return obj instanceof String ? (String)obj : null;
    }

    public static void paste() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null) {
            String str = BBxt.copyFromClipboard();
            if (str == null) {
                Cutter.setLog("    Error:BBxt.paste() - BBxt.copyFromClipboard() returned null");
                return;
            }
            if (str.length() > 0 && BBxt.getSelectionLength() > 0) {
                SyntaxListener.ignoreRemoveUpdate = true;
                BBxt.paste(str);
                return;
            }
            if (str.length() > 0 && str.trim().length() == 0) {
                textpane.paste();
                return;
            }
            String[] tok = TextUtils.tokenize(str, "\n");
            if (tok != null && tok.length == 1 && tok[0].length() > 2 && Character.isLetter(tok[0].charAt(0)) && tok[0].charAt(1) == ':' || tok[0].charAt(0) == '\\' && tok[0].charAt(1) == '\\') {
                str = str.replace('\\', '/');
                BBxt.paste(str);
            } else {
                textpane.paste();
            }
        }
    }

    public static void paste(final String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        final JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        final Document document = textpane.getDocument();
        try {
            if (BBxt.getSelectionLength() > 0) {
                document.remove(BBxt.getSelectionStart(), BBxt.getSelectionLength());
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.insertString(textpane.getCaretPosition(), s, null);
                        }
                        catch (BadLocationException ex) {
                            Cutter.setLog("    Error: BBxt.paste(String) - " + ex.getMessage());
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: BBxt.paste(String) - " + ex.getMessage());
        }
    }

    public static boolean isSaved() {
        if (BBxt.getWindowFile() == null) {
            return false;
        }
        String title = BBxt.getWindowTitle();
        return !title.endsWith("*");
    }

    public static void save() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null || !window.getTouched()) {
            return;
        }
        window.saveFile(1);
    }

    public static int[] _find(String str, boolean ignoreCase, boolean wholeWord, int beginOffset) {
        KAbstractWindow w = KAbstractDesktop.getFrontWindow();
        if (w == null) {
            return null;
        }
        JEditorPane textpane = null;
        if (w instanceof HTMLWindow) {
            HTMLWindow cfr_ignored_0 = (HTMLWindow)w;
            textpane = HTMLWindow.editorPane;
        } else if (w instanceof KTextWindow) {
            textpane = ((KTextWindow)w).getTextPane();
        }
        if (textpane == null) {
            return null;
        }
        int length = textpane.getDocument().getLength();
        if (length == 0 || str == null || str.length() == 0) {
            return null;
        }
        int begin = beginOffset == -1 ? textpane.getSelectionEnd() : beginOffset;
        int offset = -1;
        int[] out = new int[2];
        Segment segment = new Segment();
        try {
            textpane.getDocument().getText(begin, length - begin, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KCaret.getSegment(int,int)" + ex);
        }
        if (segment == null) {
            return null;
        }
        findReplaceTokenizer.setBuffer(segment);
        out = TextUtils.containsWhiteSpace(str) ? findReplaceTokenizer.searchFor(str, ignoreCase, false) : findReplaceTokenizer.searchFor(str, ignoreCase, wholeWord);
        if (out == null) {
            return null;
        }
        out[0] = out[0] + begin;
        out[1] = out[1] + begin;
        return out;
    }

    public static int _replaceAll(String str, FindToolListener tool, boolean ignoreCase, boolean wholeWord) {
        return BBxt.replaceAll(str, tool.getReplacementText(), ignoreCase, wholeWord);
    }

    public static int replaceAll(String str, String destStr, boolean ignoreCase, boolean wholeWord) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (!(textpane instanceof KTextPane)) {
            return 0;
        }
        int[] offset = BBxt._find(str, ignoreCase, wholeWord, 0);
        if (offset == null) {
            Cutter.setLog("        BBxt.find - couldn't find");
            return 0;
        }
        Document document = textpane.getDocument();
        int length = document.getLength();
        int destLngth = 0;
        int counter = 0;
        int begin = offset[0];
        while (begin < length) {
            try {
                document.remove(begin, offset[1] - offset[0]);
                document.insertString(begin, destStr, null);
                destLngth = destStr.length();
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception: BBxt.replaceAll(String) - " + ex.getMessage());
            }
            length = document.getLength();
            findReplaceTokenizer.setBuffer(DocumentUtils.getSegment(textpane.getDocument(), begin += destLngth, length - begin));
            offset = findReplaceTokenizer.searchFor(str, ignoreCase, wholeWord);
            if (offset == null) {
                return counter;
            }
            begin += offset[0];
            ++counter;
        }
        return counter;
    }

    public static boolean findNext() {
        if (FindTool.init().canFindNext()) {
            return FindTool.init().doFind(BBxt.getSelectionEnd(), false);
        }
        if (FindTool.init().canFind()) {
            return FindTool.init().doFind(BBxt.getSelectionEnd(), false);
        }
        if (!FindTool.init().isVisible()) {
            FindTool.init().setVisible(true);
        }
        return false;
    }

    public static boolean replaceFind() {
        if (FindTool.init().canReplaceFind()) {
            return FindTool.init().doReplaceFind();
        }
        return false;
    }

    public static boolean findAndReplace(String target, String replacement) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        Document document = textpane.getDocument();
        Segment segment = DocumentUtils.getSegment(document, 0, document.getLength());
        if (segment == null) {
            return false;
        }
        RegExpUtils re = new RegExpUtils();
        boolean doIgnoreCase = false;
        boolean doWholeWord = true;
        String regexp = re.encodeAsRE(target, doIgnoreCase, doWholeWord);
        if (!re.checkPattern(regexp)) {
            Cutter.setLog("    Warning:BBxt.findAndReplace() - \"" + regexp + "\" is not a valid regex pattern");
            return false;
        }
        String[] parts = null;
        int diff = 0;
        int absBegin = -1;
        int absEnd = -1;
        int selectionStart = BBxt.getSelectionStart();
        BBxt.suspendSyntaxColoration();
        try {
            parts = segment.toString().split(regexp, 2);
            if (parts != null && parts.length > 1) {
                int part0Length = parts[0].length();
                int part1Length = parts[1].length();
                diff = segment.count - (part0Length + part1Length);
                int beginOffset = parts[0].length();
                absBegin = beginOffset + 0;
                absEnd = absBegin + diff;
                document.remove(absBegin, target.length());
                document.insertString(absBegin, replacement, null);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:BBxt.findAndReplace()\n          " + e.toString());
            return false;
        }
        BBxt.resumeSyntaxColoration();
        BBxt.parseAll();
        BBxt.setSelection(selectionStart, selectionStart);
        return true;
    }

    public static boolean canReplaceText() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        return textpane instanceof KTextPane;
    }

    public static int removeWackyCharacters() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane instanceof KTextPane) {
            String src = BBxt.getWindowText();
            if (src == null || src.length() == 0) {
                return 0;
            }
            StringBuffer purgedBuf = new StringBuffer(src.length());
            for (int n = 0; n < src.length(); ++n) {
                char c = src.charAt(n);
                if (c < '\t' || c > '\u007f') continue;
                purgedBuf.append(c);
            }
            if (purgedBuf.length() == 0) {
                return 0;
            }
            BBxt.selectAll();
            BBxt.replaceSelection(purgedBuf.toString());
        }
        return 0;
    }

    public static int replaceSelection(String text) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            Cutter.setLog("BBxt.replaceSelection() textpane is null");
            return -1;
        }
        textpane.replaceSelection(text);
        return textpane.getSelectionEnd();
    }

    public static boolean insertStringAt(Document document, int begin, int lngth, String destStr) {
        try {
            document.remove(begin, lngth);
            document.insertString(begin, destStr, null);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception: BBxt.replaceAll(String) - " + ex.getMessage());
            return false;
        }
        return true;
    }

    public static void applyStyle(Style style) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        Document document = textpane.getDocument();
        if (!(document instanceof DefaultStyledDocument)) {
            return;
        }
        if (document.getLength() == 0) {
            ((DefaultStyledDocument)document).setLogicalStyle(0, style);
        } else {
            for (int n = 0; n < BBxt.countLineBreaks(); ++n) {
                ((DefaultStyledDocument)document).setLogicalStyle(n, style);
            }
        }
    }

    public static Comment[] getComments() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return null;
        }
        KTextPane kp = (KTextPane)textpane;
        return kp.getComments();
    }

    public static void removeComments() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        if (BBxt.getSelectionLength() == 0) {
            return;
        }
        if (textpane instanceof KTextPane) {
            ((KTextPane)textpane).removeComments();
        }
    }

    public static void addComments() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        if (BBxt.getSelectionLength() == 0) {
            return;
        }
        if (textpane instanceof KTextPane) {
            ((KTextPane)textpane).addComments();
        }
    }

    public static Font getFont() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return KStyleContext.defaultFont;
        }
        return textpane.getFont();
    }

    public static void setFont(Font f) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null) {
            textpane.setFont(f);
        }
    }

    public static void setTabSize(int size) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null && textpane instanceof KTextPane) {
            ((KTextPane)textpane).setTabSize(size);
            KAbstractTextWindow atw = ((KTextPane)textpane).getFrame();
            atw.setTabSize(size);
        }
    }

    public static void setMarkedStyle(int line) {
        KTextWindow win = BBxt.getTextWindow();
        if (win != null) {
            win.setMarkedStyle(line);
        }
    }

    public static KTextWindow getTextWindow() {
        KAbstractTextWindow atw;
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null && textpane instanceof KTextPane && (atw = ((KTextPane)textpane).getFrame()) != null && atw instanceof KTextWindow) {
            return (KTextWindow)atw;
        }
        return null;
    }

    public static KTextWindow getTextWindow(KTextPane textpane) {
        if (textpane == null) {
            return null;
        }
        KAbstractTextWindow atw = textpane.getFrame();
        if (atw != null && atw instanceof KTextWindow) {
            return (KTextWindow)atw;
        }
        return null;
    }

    public static boolean lineNumberingIsVisible() {
        KTextWindow win = BBxt.getTextWindow();
        if (win == null) {
            return false;
        }
        return win.lineNumberingIsVisible();
    }

    public static void showLineNumbering(boolean flag) {
        KTextWindow win = BBxt.getTextWindow();
        if (win == null) {
            return;
        }
        win.showLineNumbering(flag);
    }

    public static int getDefaultTabSize() {
        String txt = Preferences.get(Preferences.TEXT_TAB_SIZE);
        int defaultSize = 4;
        if (txt.trim().length() == 0) {
            return defaultSize;
        }
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: BBxt.getDefaultTabSize() - cannot get pref");
            return defaultSize;
        }
    }

    public static int getTabSize() {
        KAbstractWindow aw = BBxt.frontWindow();
        if (aw == null) {
            Cutter.setLog("    Error: BBxt.getTabSize() - frontWindow is null!");
            String txt = Preferences.get(Preferences.TEXT_TAB_SIZE);
            if (txt.trim().length() == 0) {
                return 4;
            }
            return Integer.parseInt(txt);
        }
        if (aw instanceof KAbstractTextWindow) {
            KAbstractTextWindow atw = (KAbstractTextWindow)aw;
            return atw.getTabSize();
        }
        return 4;
    }

    public static int getMarginWidth() {
        String str = Preferences.get(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH);
        return NumberUtils.strToInt(str, 100);
    }

    public static void setMarginWidth(int width) {
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        for (int n = 0; n < windows.length; ++n) {
            KAbstractWindow win = windows[n];
            if (win == null || !(win instanceof KTextWindow)) continue;
            ((KTextWindow)win).setMarginWidth(width);
        }
    }

    public static int getDocumentLength() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return -1;
        }
        return textpane.getDocument().getLength();
    }

    public static int countLineBreaks(Segment segment) {
        boolean uptoCaret = true;
        return BBxt.countLineBreaks(segment, uptoCaret);
    }

    public static int countLineBreaks(Segment segment, boolean uptoCaret) {
        if (segment == null) {
            return 0;
        }
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return 0;
        }
        int line = 1;
        int total = uptoCaret ? textpane.getCaretPosition() : segment.length();
        for (int n = 0; n < total; ++n) {
            if (segment.array[segment.offset + n] != '\n') continue;
            ++line;
        }
        return line;
    }

    public static int countLineTabs() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return 0;
        }
        int numTabs = 0;
        int position = textpane.getCaretPosition();
        if (position == 0) {
            return 0;
        }
        int[] offset = DocumentUtils.getElementOffsets(textpane.getDocument(), position);
        int length = position - offset[1];
        Segment segment = DocumentUtils.getSegment(textpane.getDocument(), offset[1], length);
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\t') continue;
            ++numTabs;
        }
        return numTabs;
    }

    public static int getLineNumberAtOffset(int offset) {
        Segment segment = BBxt.getWindowText(new Segment());
        if (segment == null) {
            Cutter.setLog("    Error: BBxt.getLineNumberAtOffset() - segment is null");
            return -1;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] == '\n') {
                ++line;
            }
            if (n != offset) continue;
            return line;
        }
        return line;
    }

    public static int[] getOffsetsOfLine(int lineNumber) {
        Segment segment = BBxt.getWindowText(new Segment());
        if (segment == null) {
            Cutter.setLog("BBxt.getOffsetsOfLine() segment is null");
            return null;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\n' || ++line != lineNumber) continue;
            return DocumentUtils.getElementOffsets(BBxt.getTextPane(BBxt.frontWindow()).getDocument(), n);
        }
        return null;
    }

    public static int[] getOffsetsOfLine(Segment segment, int lineNumber) {
        if (segment == null) {
            Cutter.setLog("BBxt.getOffsetsOfLine() segment is null");
            return null;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\n' || ++line != lineNumber) continue;
            return DocumentUtils.getElementOffsets(BBxt.getTextPane(BBxt.frontWindow()).getDocument(), n);
        }
        return null;
    }

    public static void hilitLineNumber(int lineNumber) {
        int[] offset = BBxt.getOffsetsOfLine(lineNumber);
        if (offset == null) {
            return;
        }
        BBxt.setSelection(offset[1], offset[2] - 1);
    }

    public static int countLineBreaks() {
        Segment segment = BBxt.getWindowText(new Segment());
        if (segment == null) {
            Cutter.setLog("BBxt.countLineBreaks() segment is null");
            return 0;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\n') continue;
            ++line;
        }
        return line;
    }

    public static ActionListener reloadDocAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Cutter.setLog("    Debug:BBxt.reloadDocAction() has been called.");
                BBxt.reReadFromFile();
            }
        };
    }

    public static void reReadFromFile() {
        BBxt.reReadFromFile(true);
    }

    public static void reReadFromFile(boolean doWarn) {
        File f = BBxt.getWindowFile();
        if (f == null) {
            String[] msg = new String[]{"The document has not been saved and, tberefore,", "cannot be reloaded from file.\n"};
            DialogUtils.showInfoMessage("Document Not Saved", msg);
            return;
        }
        String str = FileUtils.read(f);
        if (str == null) {
            Cutter.setLog("    Error:BBxt.reReadFromFile() - FileUtils.read() returned null.");
            return;
        }
        if (!doWarn) {
            BBxt.selectAll();
            BBxt.paste(str);
            BBxt.parseAll();
            return;
        }
        String[] msg = new String[]{"\nThis action will replace the existing text.", "Do you wish to proceed?\n"};
        if (DialogUtils.confirm("Reload Text", "ignored", msg)) {
            JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
            KTextWindow tw = BBxt.getTextWindow();
            if (tw != null) {
                tw.addToHistory();
            }
            BBxt.selectAll();
            BBxt.paste(str);
            BBxt.parseAll();
        }
    }

    public static JEditorPane getTextPane(KAbstractWindow window) {
        if (window == null) {
            return null;
        }
        if (window instanceof KTextWindow) {
            return ((KTextWindow)window).getTextPane();
        }
        if (window instanceof HTMLWindow) {
            HTMLWindow cfr_ignored_0 = (HTMLWindow)window;
            return HTMLWindow.editorPane;
        }
        if (window instanceof KTextHistoryWindow) {
            return ((KTextHistoryWindow)window).getTextPane();
        }
        return null;
    }

    public static JEditorPane getTextPane() {
        return BBxt.getTextPane(BBxt.frontWindow());
    }

    public static Document getWindowDocument() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        return textpane.getDocument();
    }

    public static String getTextFromWindowWithFile(File file) {
        if (file == null) {
            return null;
        }
        KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(file);
        if (kaw == null || !(kaw instanceof KTextWindow)) {
            return null;
        }
        JEditorPane textpane = BBxt.getTextPane(kaw);
        if (textpane == null) {
            Cutter.setLog("BBxt.getTextFromWindowWithFile() textpane is null");
            return null;
        }
        Document document = textpane.getDocument();
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception: BBxt.getTextFromWindowWithFile()" + ex);
            return null;
        }
    }

    public static String getWindowText() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            Cutter.setLog("BBxt.getWindowText() textpane is null");
            return null;
        }
        Document document = textpane.getDocument();
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception: BBxt.getWindowText()" + ex);
            return null;
        }
    }

    public static Segment getWindowText(Segment segment) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        Document document = textpane.getDocument();
        return DocumentUtils.getSegment(document, 0, document.getLength());
    }

    public static Segment getWindowText(int offset) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        return DocumentUtils.getSegment(textpane.getDocument(), offset);
    }

    public static Segment getWindowText(int begin, int end) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        Document doc = textpane.getDocument();
        if (doc == null) {
            return null;
        }
        if (end == -1) {
            end = doc.getLength();
        }
        return DocumentUtils.getSegment(doc, begin, end - begin);
    }

    public static File getWindowFile() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return null;
        }
        return window.getFile();
    }

    public static boolean setWindowFile(File file) {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return false;
        }
        window.setFile(file);
        return true;
    }

    public static String getWindowExtension() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        if (!(textpane instanceof KTextPane)) {
            return null;
        }
        String title = BBxt.frontWindow().getTitle();
        if ((title = TextUtils.remove(title, '*')).endsWith(" [NOT EDITABLE]")) {
            int len = " [NOT EDITABLE]".length();
            title = title.substring(0, title.length() - len).trim();
        }
        return FileUtils.getExtension(title);
    }

    public static KAbstractHelp getHelper() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        if (textpane instanceof KTextPane) {
            return ((KTextPane)textpane).helper;
        }
        return null;
    }

    public static String getWindowTitle() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return "";
        }
        return window.getTitle();
    }

    public static File getFrontWindowFile() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return null;
        }
        return window.getFile();
    }

    public static String getFileExt() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return null;
        }
        File f = window.getFile();
        if (f == null) {
            return null;
        }
        String ext = FileUtils.getExtension(f);
        return ext == null || ext.length() < 2 ? null : ext.substring(1);
    }

    public static String getCopyNoComments() {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return null;
        }
        JEditorPane jed = BBxt.getTextPane();
        if (jed instanceof KTextPane) {
            KTextPane textpane = (KTextPane)jed;
            return textpane.getCopyNoComments();
        }
        Cutter.setLog("    Error: BBxt.getCopyNoComments() Front window is not an instance of the KTextPane class!");
        return null;
    }

    public static void addToHistory() {
        if (BBxt.frontWindow() != null) {
            BBxt.frontWindow().addToHistory();
        }
    }

    public static boolean hasHistory() {
        if (BBxt.frontWindow() == null) {
            return false;
        }
        if (BBxt.frontWindow() instanceof KAbstractTextWindow) {
            return ((KAbstractTextWindow)BBxt.frontWindow()).hasHistory();
        }
        return false;
    }

    public static void openHistoryWindow() {
        if (BBxt.frontWindow() == null) {
            Cutter.setLog("BBxt.openHistoryWindow() - frontWindow() returned null");
            return;
        }
        if (BBxt.frontWindow() instanceof KAbstractTextWindow) {
            ((KAbstractTextWindow)BBxt.frontWindow()).viewHistory();
        } else {
            Cutter.setLog("BBxt.openHistoryWindow() - frontWindow() is not a KAbstractTextWindow");
        }
    }

    public static boolean isDosCommand(String str) {
        for (int n = 0; n < dos.length; ++n) {
            if (!str.equalsIgnoreCase(dos[n])) continue;
            return true;
        }
        return false;
    }

    public static void execute() {
        BBxt.execute(false);
    }

    public static void execute(boolean shiftDown) {
        KAbstractWindow window = BBxt.frontWindow();
        if (!(window instanceof KTextWindow) && !(window instanceof KTextHistoryWindow)) {
            return;
        }
        JEditorPane textpane = BBxt.getTextPane(window);
        if (textpane == null) {
            Cutter.setLog("    Error:BBxt.execute() - cannot find the front window");
            return;
        }
        Document document = textpane.getDocument();
        String str = BBxt.getSelection();
        if (str != null && str.length() >= 2) {
            boolean treatAsCommand;
            String[] items;
            boolean containsNewLine;
            String[] lines = TextUtils.tokenize(str, "\n");
            SyntaxListener sl = textpane instanceof KTextPane ? ((KTextPane)textpane).getSyntaxListener() : null;
            Comment[] cmnts = textpane instanceof KTextPane ? ((KTextPane)textpane).getComments() : null;
            StringBuffer lineBuf = new StringBuffer();
            if (sl != null && lines != null && cmnts != null) {
                for (int n = 0; n < lines.length; ++n) {
                    PlainDocument d = new PlainDocument();
                    try {
                        d.insertString(0, lines[n] + "\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    for (int i = 0; i < cmnts.length; ++i) {
                        int len = d.getLength();
                        sl.removeComments(d, cmnts[i], false, 0, len);
                    }
                    try {
                        lineBuf.append(d.getText(0, d.getLength()).trim() + " ");
                        continue;
                    }
                    catch (BadLocationException be) {
                        Cutter.setLog("    Exception:BBxt.execute()\n" + be.toString());
                    }
                }
                str = lineBuf.toString().trim();
            }
            if (str.startsWith("file:") || str.startsWith("http") || str.startsWith("www.")) {
                Cutter.setLog("    Info:BBxt.execute() - selection is considered to be a URL = >" + str + "<");
                BrowserUtils.open(str);
                return;
            }
            String[] tokens = TextUtils.tokenize(str);
            boolean bl = containsNewLine = str.indexOf(10) != -1;
            if (!containsNewLine && tokens != null && tokens.length > 0 && BBxt.isDosCommand(tokens[0]) && EnvUtils.isWinEnvironment()) {
                String[] items2 = new String[]{"C:\\WINDOWS\\system32\\cmd", "/C", str};
                Cutter.setLog("    Info:BBxt.execute() - executing a dos command");
                Cutter.setLog(items2, 2);
                ProcessManager fp = new ProcessManager("Dos");
                fp.launch(items2, null, false, null, false);
                return;
            }
            if (tokens != null && tokens.length > 0 && EnvUtils.isWinEnvironment() && tokens[0].equalsIgnoreCase("quicktimeplayer")) {
                String[] items3 = new String[tokens.length == 2 ? 2 : 1];
                items3[0] = "\"C:\\Program Files\\QuickTime\\quicktimeplayer\"";
                if (items3.length == 2) {
                    items3[1] = tokens[1];
                }
                ProcessManager fp = new ProcessManager("Untitled");
                fp.launch(items3, null, false, null, false);
                return;
            }
            String[] paths = new String[]{Preferences.get(Preferences.PATH_USER_TEXTURES), FileUtils.getPWD(), window.getFile() == null ? "" : window.getFile().getPath()};
            File f = FileUtils.findInPaths(paths, str);
            if (f != null && GraphicsFileUtils.canOpen(f)) {
                GraphicsFileUtils.open(f);
                return;
            }
            if (RegExpUtils.split(str, "r", true) != null && RegExpUtils.split(str, "g", true) != null && RegExpUtils.split(str, "b", true) != null) {
                return;
            }
            String title = TextUtils.trimTrailingChar(window.getTitle(), '*');
            if (BBxt.getSelection().length() > 0 && (title.endsWith(".see") || title.endsWith(".mel") || title.endsWith(".py"))) {
                SyntaxListener l;
                SyntaxListener syntaxListener = l = textpane instanceof KTextPane ? ((KTextPane)textpane).getSyntaxListener() : null;
                if (l != null) {
                    if (l instanceof MelListener) {
                        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".mel");
                        if (handler == null) {
                            Cutter.setLog("    Error:BBxt.execute() - cannot get handlder for mel document");
                            return;
                        }
                        handler.execute(BBxt.getSelection());
                        BBxt.addToHistory();
                        return;
                    }
                    if (l instanceof PythonListener) {
                        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".py");
                        if (handler == null) {
                            Cutter.setLog("    Error:BBxt.execute() - cannot get handlder for python document");
                            return;
                        }
                        handler.execute(BBxt.getSelection());
                        BBxt.addToHistory();
                        return;
                    }
                    if (l instanceof SeeListener) {
                        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".see");
                        if (handler == null) {
                            Cutter.setLog("    Error:BBxt.execute() - cannot get handlder for Disney SeExpr document");
                            return;
                        }
                        handler.execute(BBxt.getSelection());
                        BBxt.addToHistory();
                        return;
                    }
                }
            }
            if ((items = TextUtils.tokenize(str)) != null && !items[0].equals("rm") && ((treatAsCommand = false) || LinuxCommands.isaCommand(items[0]))) {
                items = new String[]{"/bin/sh", "-c", str};
            }
            Cutter.setLog("    Debug:BBxt.execute() - executing the following selected text >" + str + "<");
            Cutter.setLog(items);
            Cutter.setLog("-------------");
            if (items != null && items.length > 0) {
                ProcessManager.kill(items[0]);
            }
            ProcessManager fp = items[0].equals("man") ? new ProcessManager("man") : new ProcessManager("Untitled");
            File parentFile = items[0].startsWith("./") ? BBxt.getWindowFile().getParentFile() : null;
            fp.launch(items, parentFile, true, new ProcListener(){

                @Override
                public void processStarted(String procName, String[] progarray, String procID) {
                }

                @Override
                public void processSentString(String procName, String output) {
                    if (Cutter.input.debug) {
                        Cutter.setLog("    Debug:BBxt.execute() - " + output);
                    }
                }

                @Override
                public void processFinished(String[] progarray) {
                    Monitor.finalizePanelText("Untitled", "Process completed.\n");
                }
            }, false);
            return;
        }
        if (window instanceof KTextHistoryWindow) {
            File file;
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:BBxt.execute() - execution of history window");
            }
            if ((file = ((KTextHistoryWindow)window).getOwnersFile()) == null) {
                Cutter.setLog("    Error:BBxt.execute() - cannot get KTextHistoryWindow owners file");
                return;
            }
            ScriptHandler handler = ScriptRegistry.getHandlerForFile(file);
            if (handler == null) {
                return;
            }
            handler.executeFromHistory((KTextHistoryWindow)window);
            return;
        }
        if (BBxt.isSlimTemplateDocument()) {
            ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".slim");
            if (handler == null) {
                Cutter.setLog("    Error:BBxt.execute() - cannot get handlder for slim document");
                return;
            }
            handler.execute(BBxt.getWindowText());
            BBxt.addToHistory();
            return;
        }
        boolean didsave = window.saveFile();
        final File file = window.getFile();
        if (file == null) {
            Cutter.setLog("    Error:BBxt.execute() - file is null");
            return;
        }
        if (file.getName().endsWith(".sh") && !EnvUtils.isWinEnvironment()) {
            Cutter.setLog("    Info:BBxt.execute() - executing a .sh file");
            String[] items = new String[]{"chmod", "777", file.getPath()};
            ProcessManager fp1 = new ProcessManager("untitled");
            fp1.launch(items, null, false, null, true);
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File envDir = file.getParentFile();
                        String[] item = new String[]{"./" + file.getName()};
                        ProcessManager fp2 = new ProcessManager("untitled");
                        fp2.launch(item, envDir, false, null, false);
                    }
                });
            }
            catch (Exception tokens) {
                // empty catch block
            }
            return;
        }
        ScriptHandler handler = null;
        handler = ScriptRegistry.getHandlerForFile(file);
        if (handler != null) {
            String scriptName = handler.getScriptName();
            if (scriptName.equals("PxrDevkit")) {
                // empty if block
            }
            handler.getStructure();
            handler.execute(file);
        } else if (!EnvUtils.isWinEnvironment()) {
            Cutter.setLog("    Info:BBxt.execute() - no script handler for this file.\n        Will attempt to execute the file directly.\n        Hovever, its assumed the file has execution permissions.");
            String[] item = new String[]{file.getPath()};
            ProcessManager fp2 = new ProcessManager("untitled");
            fp2.launch(item, null, false, null, true);
        } else {
            Cutter.setLog("    Error:BBxt.execute() - cannot complete BBxt.execute() because a script handler cannot be found.");
        }
    }

    public static boolean fileURL(String url, int n) {
        String slashes = "";
        for (int i = 0; i < n; ++i) {
            slashes = slashes + '/';
        }
        try {
            Cutter.htmlWindow.setPage("file:" + slashes + url, null);
        }
        catch (Exception e) {
            Cutter.setLog("Error trying to open file url using " + n + " slashes");
            return false;
        }
        return true;
    }

    public static void suspendSyntaxColoration() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null && textpane instanceof KTextPane) {
            ((KTextPane)textpane).suspendSyntaxColoration();
        }
    }

    public static void resumeSyntaxColoration() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane != null && textpane instanceof KTextPane) {
            ((KTextPane)textpane).resumeSyntaxColoration();
        }
    }

    public static void parseAll() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        if (textpane instanceof KTextPane) {
            ((KTextPane)textpane).parseAll();
        }
    }

    public static Syntax getExistingSyntaxAt(int begin, int end) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return null;
        }
        SyntaxListener listener = ((KTextPane)textpane).getSyntaxListener();
        Syntax syntax = listener.getExistingSyntax(begin, end);
        return syntax;
    }

    public static void suspendWordHiliter() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return;
        }
        KWordHiliter hiliter = ((KTextPane)textpane).wordHiliter;
        if (hiliter != null) {
            hiliter.hiliterDeActivate();
        }
    }

    public static void resumeWordHiliter() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return;
        }
        KWordHiliter hiliter = ((KTextPane)textpane).wordHiliter;
        if (hiliter != null) {
            hiliter.hiliterActivate();
        }
    }

    public static SyntaxListener getSyntaxListener() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            return null;
        }
        return ((KTextPane)textpane).getSyntaxListener();
    }

    public static void suspendColoration() {
        SyntaxListener sl = BBxt.getSyntaxListener();
        if (sl != null) {
            sl.suspendColoration();
        }
    }

    public static void resumeColoration() {
        SyntaxListener sl = BBxt.getSyntaxListener();
        if (sl != null) {
            sl.resumeColoration();
        }
    }

    public static boolean canUndo() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        Document doc = textpane.getDocument();
        if (textpane instanceof KTextPane) {
            try {
                return ((KDocument)doc).canUndo();
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: BBxt.canUndo()\n\t" + e.toString());
                return false;
            }
        }
        return false;
    }

    public static void undo() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:BBxt.undo() - textpane is null");
            }
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!BBxt.canUndo()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Document doc = textpane.getDocument();
        if (textpane instanceof KTextPane) {
            try {
                ((KDocument)doc).undo();
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
                Cutter.setLog("    Exception: BBxt.undo()\n\t" + e.toString());
            }
        }
    }

    public static String getUndoPresentationName() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return "";
        }
        if (textpane instanceof KTextPane) {
            Document doc = textpane.getDocument();
            try {
                return ((KDocument)doc).getUndoPresentationName();
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: BBxt.getUndoPresentationName()\n\t" + e.toString());
                return "";
            }
        }
        return "";
    }

    public static boolean canRedo() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (textpane instanceof KTextPane) {
            Document doc = textpane.getDocument();
            try {
                return ((KDocument)doc).canRedo();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void redo() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return;
        }
        if (textpane instanceof KTextPane) {
            Document doc = textpane.getDocument();
            try {
                ((KDocument)doc).redo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getRedoPresentationName() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return "";
        }
        if (textpane instanceof KTextPane) {
            Document doc = textpane.getDocument();
            try {
                return ((KDocument)doc).getRedoPresentationName();
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: BBxt.getRedoPresentationName()\n\t" + e.toString());
                return "";
            }
        }
        return "";
    }

    public static void setOutputFormat(int type) {
        KAbstractWindow window = BBxt.frontWindow();
        if (window == null) {
            return;
        }
        if (window instanceof KTextWindow) {
            ((KTextWindow)window).textOutputOSType = type;
        }
    }

    public static void setTouched(boolean flag) {
        KAbstractWindow window = BBxt.frontWindow();
        if (window != null) {
            window.setTouched(flag);
        }
    }

    public static boolean isMayaClient() {
        KAbstractWindow win = BBxt.frontWindow();
        if (win == null) {
            return false;
        }
        return win.isMayaClient();
    }

    public static boolean isHoudiniClient() {
        KAbstractWindow win = BBxt.frontWindow();
        if (win == null) {
            return false;
        }
        return win.isHoudiniClient();
    }

    public static boolean isPyRiDocument() {
        JEditorPane jep = BBxt.getTextPane();
        if (jep == null) {
            Cutter.setLog("    Error:BBxt.isPyRiDocument() - cannot obtain a reference to the docs editor pane!");
            return false;
        }
        if (!(jep instanceof KTextPane)) {
            Cutter.setLog("    Info:BBxt.isPyRiDocument() - doc is not using an instance of KTextPane.");
            return false;
        }
        SyntaxListener listener = ((KTextPane)jep).getSyntaxListener();
        if (!(listener instanceof PythonListener)) {
            Cutter.setLog("    Debug:BBxt.isPyRiDocument() - doc is not using an instance of PythonListener!");
            return false;
        }
        return BBxt.isPyRiDocument((PythonListener)listener);
    }

    public static boolean isPyMelDocument() {
        JEditorPane jep = BBxt.getTextPane();
        if (jep == null) {
            Cutter.setLog("    Error:BBxt.isPyMelDocument() - cannot obtain a reference to the docs editor pane!");
            return false;
        }
        if (!(jep instanceof KTextPane)) {
            Cutter.setLog("    Info:BBxt.isPyMelDocument() - doc is not using an instance of KTextPane.");
            return false;
        }
        SyntaxListener listener = ((KTextPane)jep).getSyntaxListener();
        if (!(listener instanceof PythonListener)) {
            Cutter.setLog("    Debug:BBxt.isPyMelDocument() - doc is not using an instance of PythonListener!");
            return false;
        }
        return BBxt.isPyMelDocument((PythonListener)listener);
    }

    public static boolean isPyMelDocument(PythonListener pythonListener) {
        if (pythonListener == null) {
            Cutter.setLog("    Warning:BBxt.isPyMelDocument(PythonListener) - pythonListener is null.");
            return false;
        }
        File file = BBxt.getFrontWindowFile();
        if (file == null) {
            Cutter.setLog("    Warning:BBxt.isPyMelDocument(PythonListener) - the doc has not been saved.");
            return false;
        }
        String[][] modules = pythonListener.getImports();
        if (modules == null || modules.length != 3 || modules[2] == null) {
            return false;
        }
        for (int n = 0; n < modules[2].length; ++n) {
            String[] tokens = TextUtils.tokenize(modules[2][n]);
            if (tokens == null) continue;
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (!token.equals("maya.cmds")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPySide2Document() {
        JEditorPane jep = BBxt.getTextPane();
        if (jep == null) {
            Cutter.setLog("    Error:BBxt.isPySide2Document() - cannot obtain a reference to the docs editor pane!");
            return false;
        }
        if (!(jep instanceof KTextPane)) {
            Cutter.setLog("    Info:BBxt.isPySide2Document() - doc is not using an instance of KTextPane.");
            return false;
        }
        SyntaxListener listener = ((KTextPane)jep).getSyntaxListener();
        if (!(listener instanceof PythonListener)) {
            Cutter.setLog("    Debug:BBxt.isPySide2Document() - doc is not using an instance of PythonListener!");
            return false;
        }
        return BBxt.isPyMelDocument((PythonListener)listener);
    }

    public static boolean isPySide2Document(PythonListener pythonListener) {
        if (pythonListener == null) {
            Cutter.setLog("    Warning:BBxt.isPySide2Document(PythonListener) - pythonListener is null.");
            return false;
        }
        File file = BBxt.getFrontWindowFile();
        if (file == null) {
            Cutter.setLog("    Warning:BBxt.isPySide2Document(PythonListener) - the doc has not been saved.");
            return false;
        }
        String[][] modules = pythonListener.getImports();
        if (modules == null || modules.length != 3 || modules[2] == null) {
            return false;
        }
        for (int n = 0; n < modules[2].length; ++n) {
            String[] tokens = TextUtils.tokenize(modules[2][n]);
            if (tokens == null) continue;
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (!token.equals("PySide2")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPyRiDocument(PythonListener pythonListener) {
        if (pythonListener == null) {
            Cutter.setLog("    Warning:BBxt.isPyRiDocument(PythonListener) - pythonListener is null.");
            return false;
        }
        File file = BBxt.getFrontWindowFile();
        if (file == null) {
            Cutter.setLog("    Warning:BBxt.isPyRiDocument(PythonListener) - the doc has not been saved.");
            return false;
        }
        String[][] modules = pythonListener.getImports();
        if (modules == null || modules.length != 3 || modules[2] == null) {
            return false;
        }
        for (int n = 0; n < modules[2].length; ++n) {
            String[] tokens = TextUtils.tokenize(modules[2][n]);
            if (tokens == null) continue;
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].equals("prman")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOSLDocument() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".osl") || copy.endsWith(".OSL")) {
            KDesktop.executeItem.setText("Compile Open Shader Language");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        KDesktop.executeItem.setEnabled(false);
        return false;
    }

    public static boolean isSLDocument() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".sl") || copy.endsWith(".SL")) {
            KDesktop.executeItem.setText("Compile RenderMan Shader");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        KDesktop.executeItem.setEnabled(false);
        return false;
    }

    public static boolean isItIceDocument() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (!copy.endsWith(".tcl") && !copy.endsWith(".TCL")) {
            return false;
        }
        return BBxt.isItIceDocument(BBxt.getWindowText());
    }

    public static boolean isItIceDocument(String text) {
        if (text == null) {
            return false;
        }
        TclTokenizer tok = new TclTokenizer();
        tok.getComments = false;
        tok.setBuffer(text);
        String str = tok.getNextStr();
        while (!str.equals("")) {
            if (tok.isItIceFunction(str)) {
                return true;
            }
            str = tok.getNextStr();
        }
        return false;
    }

    public static boolean isSlimTemplateDocument() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".slim") || copy.endsWith(".SLIM")) {
            return true;
        }
        KDesktop.executeItem.setEnabled(false);
        return false;
    }

    public static boolean isRibDocument() {
        KDesktop.executeItem.setEnabled(false);
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".rib") || copy.endsWith(".RIB")) {
            KDesktop.executeItem.setText("Render RIB");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean isIFDDocument() {
        KDesktop.executeItem.setEnabled(false);
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".ifd") || copy.endsWith(".IFD")) {
            KDesktop.executeItem.setText("Render Houdini script");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean isKeyframeDocument() {
        KDesktop.executeItem.setEnabled(false);
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        if (!(textpane instanceof KTextPane)) {
            return false;
        }
        String copy = TextUtils.remove(BBxt.frontWindow().getTitle(), '*');
        if (copy.endsWith(".key")) {
            KDesktop.executeItem.setText("Render KeyFrame Animation");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean isTextHistoryDocument() {
        if (BBxt.frontWindow() instanceof KTextHistoryWindow) {
            KDesktop.executeItem.setText("Execute History");
            KDesktop.executeItem.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean containsAppletTag() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return false;
        }
        String text = BBxt.getWindowText();
        if (text == null) {
            return false;
        }
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(text);
        return tok.charSearch("<applet", true) != null;
    }

    public static boolean containsAppletTag(String text) {
        if (text == null) {
            return false;
        }
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(text);
        return tok.charSearch("applet", true) != null;
    }

    public static String oslGetShaderName(String srcText) {
        if (srcText == null || srcText.trim().length() == 0) {
            return null;
        }
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(srcText);
        OslTokenizer.ShdTypeName stn = tok.getShaderTypeOffsets();
        if (stn == null) {
            return null;
        }
        String[] out = new String[]{stn.shaderType, stn.shaderName};
        return stn.shaderName;
    }

    public static String oslGetShaderName() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        if (!BBxt.isOSLDocument()) {
            return null;
        }
        Segment segment = BBxt.getWindowText(null);
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(segment);
        OslTokenizer.ShdTypeName stn = tok.getShaderTypeOffsets();
        if (stn == null) {
            return null;
        }
        String[] out = new String[]{stn.shaderType, stn.shaderName};
        return stn.shaderName;
    }

    public static JEditorPane addCaretListener(CaretListener listener) {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            return null;
        }
        if (textpane instanceof KTextPane) {
            textpane.addCaretListener(listener);
        }
        return textpane;
    }

    static {
        try {
            Field[] fields = new Field[]{BBxt.class.getDeclaredField("_JTextComp_pasteNoRemove"), BBxt.class.getDeclaredField("_JTextPane_replaceSelection")};
            Cutter.addDebug(BBxt.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: BBxt.static - " + ex.toString());
        }
        findReplaceTokenizer = new FindReplaceTokenizer();
    }
}

