/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.ButtonPopups;

import UI_Components.Dialog.DirPresetsPanel;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.MenuUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class DefaultMenuModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Vector<JMenuItem> listOfItems = new Vector();
    public Vector<JMenuItem> listOfAppendedItems = new Vector();
    public String label = "untitled";

    public JMenuItem[] getItems() {
        Vector<JMenuItem> temp = new Vector<JMenuItem>();
        for (int n = 0; n < this.listOfItems.size(); ++n) {
            JMenuItem item = this.listOfItems.elementAt(n);
            if (MenuUtils.itemIsValid(item)) {
                temp.addElement(item);
            }
            if (!item.getText().startsWith("_")) continue;
            temp.addElement(item);
        }
        this.listOfItems = temp;
        JMenuItem cutterHome = null;
        for (int n = 0; n < this.listOfItems.size(); ++n) {
            JMenuItem item = this.listOfItems.elementAt(n);
            if (!item.getText().equals(FileUtils.getPWD())) continue;
            item.setForeground(Color.blue);
            cutterHome = item;
        }
        if (cutterHome != null) {
            this.listOfItems.remove(cutterHome);
            this.listOfItems.add(0, cutterHome);
        }
        Vector<JMenuItem> all = new Vector<JMenuItem>();
        for (int n = 0; n < this.listOfItems.size(); ++n) {
            all.addElement(this.listOfItems.elementAt(n));
        }
        int maxchars = 0;
        for (int n = 0; n < this.listOfAppendedItems.size(); ++n) {
            JMenuItem item = this.listOfAppendedItems.elementAt(n);
            if (item.getText().length() <= maxchars) continue;
            maxchars = item.getText().length();
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < maxchars; ++n) {
            buf.append("_");
        }
        JMenuItem separator = new JMenuItem(buf.toString());
        separator.setEnabled(false);
        if (maxchars > 0) {
            all.addElement(separator);
        }
        if (this.listOfAppendedItems.size() > 0) {
            for (int n = 0; n < this.listOfAppendedItems.size(); ++n) {
                all.addElement(this.listOfAppendedItems.elementAt(n));
            }
        }
        return MenuUtils.toMenuItemArray(all);
    }

    public void setLabel(String name) {
        this.label = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void append(final File dir, Color color) {
        String path = dir.getPath();
        for (int n = 0; n < this.listOfAppendedItems.size(); ++n) {
            JMenuItem item = this.listOfAppendedItems.elementAt(n);
            if (!item.getText().equals(path)) continue;
            return;
        }
        JMenuItem item = new JMenuItem(path);
        if (color != null) {
            item.setForeground(color);
        }
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirPresetsPanel.currentChooser.setCurrentDirectory(dir.getParentFile());
                DirPresetsPanel.currentChooser.setSelectedFile(dir);
                DirPresetsPanel.currentChooser.setCurrentDirectory(dir);
            }
        };
        item.addActionListener(action);
        this.listOfAppendedItems.addElement(item);
    }

    public void addUnderscoredSeparator(String label) {
        JMenuItem separator = new JMenuItem(label);
        separator.setEnabled(false);
        this.listOfItems.addElement(separator);
    }

    public void add(File dir) {
        this.add(dir, null);
    }

    public void add(final File dir, Color color) {
        JMenuItem[] existingItems;
        String fullPathAsItemLabel = dir.getPath();
        String dirname = dir.getName();
        if (!dir.getPath().equals(FileUtils.getPWD()) && (existingItems = this.getItems()) != null) {
            for (int n = 0; n < existingItems.length; ++n) {
                String existingItemFullPath = existingItems[n].getText();
                String existingItemNameOnly = new File(existingItems[n].getText()).getName();
                if (existingItemNameOnly.equals(dirname) && existingItemFullPath.equals(fullPathAsItemLabel)) continue;
            }
        }
        String pathAsLowerCase = fullPathAsItemLabel.toLowerCase();
        JMenuItem item = this.get(fullPathAsItemLabel);
        if (item != null) {
            Cutter.setLog("    Debug: DefaultMenuModel exit 2  >" + fullPathAsItemLabel + "<");
            return;
        }
        item = new JMenuItem(fullPathAsItemLabel);
        if (color != null) {
            item.setForeground(color);
        }
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirPresetsPanel.currentChooser.setCurrentDirectory(dir.getParentFile());
                DirPresetsPanel.currentChooser.setSelectedFile(dir);
                DirPresetsPanel.currentChooser.setCurrentDirectory(dir);
            }
        };
        item.addActionListener(action);
        this.listOfItems.addElement(item);
    }

    public boolean remove(String path) {
        boolean foundItem = false;
        boolean foundAppended = false;
        for (int n = 0; n < this.listOfAppendedItems.size(); ++n) {
            JMenuItem item = this.listOfAppendedItems.elementAt(n);
            if (!item.getText().equals(path)) continue;
            this.listOfAppendedItems.remove(item);
            foundAppended = true;
            break;
        }
        return foundItem || foundAppended;
    }

    private JMenuItem get(String name) {
        for (int n = 0; n < this.listOfItems.size(); ++n) {
            if (!(this.listOfItems.elementAt(n) instanceof JMenuItem)) {
                this.listOfItems.removeElementAt(n);
                return this.get(name);
            }
            JMenuItem item = this.listOfItems.elementAt(n);
            if (!item.getText().equals(name)) continue;
            return item;
        }
        return null;
    }
}

