/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.ButtonPopups;

import UI_Components.ButtonPopups.DefaultMenuModel;
import Utilities.ResourceUtils;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KButtonPopup
extends JToggleButton
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Font menuFont = null;
    public Popup popup = new Popup();
    private ImageIcon upIcon = null;
    private ImageIcon downIcon = null;

    public KButtonPopup() {
        this.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((KButtonPopup)e.getSource()).isSelected()) {
                    if (KButtonPopup.this.downIcon != null) {
                        ((JToggleButton)e.getSource()).setIcon(KButtonPopup.this.downIcon);
                    }
                    KButtonPopup.this.popup.show(KButtonPopup.this, 10, 10);
                } else if (KButtonPopup.this.upIcon != null) {
                    ((JToggleButton)e.getSource()).setIcon(KButtonPopup.this.upIcon);
                }
            }
        });
    }

    public void setIcons(String upIconPath, String downIconPath) {
        this.upIcon = ResourceUtils.getIconResource(upIconPath);
        this.downIcon = ResourceUtils.getIconResource(downIconPath);
        this.setIcon(this.upIcon);
    }

    public void removeGroup(String name) {
    }

    public void addMenuToPopup(DefaultMenuModel listener) {
        this.popup.addGroupMenu(listener);
    }

    public void addItemsToPopup(DefaultMenuModel listener) {
        this.popup.addWithoutMenu(listener);
    }

    static {
        Font fb = (Font)UIManager.get("Button.font");
        menuFont = new Font(fb.getName(), 1, 11);
    }

    public class Popup
    extends JPopupMenu
    implements PopupMenuListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        DefaultMenuModel modelNotGrouped = null;
        Vector<DefaultMenuModel> listOfSubMenus = new Vector();

        public Popup() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            KButtonPopup.this.doClick();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JMenuItem[] items;
            int n;
            MenuElement[] elements = this.getSubElements();
            if (elements != null) {
                for (n = 0; n < elements.length; ++n) {
                    if (elements[n] instanceof GroupMenu) continue;
                    this.remove((JMenuItem)elements[n]);
                }
            }
            if (this.modelNotGrouped != null && (items = this.modelNotGrouped.getItems()) != null && items.length > 0) {
                for (int n2 = 0; n2 < items.length; ++n2) {
                    this.add(items[n2]);
                }
            }
            if (elements != null || elements.length == 0) {
                for (n = 0; n < elements.length; ++n) {
                    if (!(elements[n] instanceof GroupMenu)) continue;
                    GroupMenu groupMenu = (GroupMenu)elements[n];
                    int n3 = groupMenu.buildSubMenu();
                }
            }
        }

        private void addGroupMenu(DefaultMenuModel dmm) {
            GroupMenu groupMenu = new GroupMenu();
            groupMenu.setMenuModel(dmm);
            this.listOfSubMenus.addElement(dmm);
        }

        private void addWithoutMenu(DefaultMenuModel dmm) {
            this.modelNotGrouped = dmm;
        }

        public class GroupMenu
        extends JMenu {
            private static final long serialVersionUID = 1L;
            public DefaultMenuModel dmm = null;

            public void setMenuModel(DefaultMenuModel dmm) {
                this.setFont(menuFont);
                this.dmm = dmm;
                if (dmm == null || dmm.getLabel() == null) {
                    this.setText("more...");
                } else {
                    this.setText(dmm.getLabel());
                }
            }

            public int buildSubMenu() {
                this.setEnabled(true);
                if (this.dmm == null) {
                    return 0;
                }
                JMenuItem[] items = this.dmm.getItems();
                if (items != null) {
                    Object more = null;
                    for (int i = 0; i < items.length; ++i) {
                        JMenuItem item = items[i];
                        if (item == null) continue;
                        this.add(item);
                    }
                    this.setEnabled(true);
                    return items.length;
                }
                return 0;
            }
        }
    }
}

