/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import UI_BBXT.BBxt;
import UI_Components.Dialog.DirPresetsPanel;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Tools.KTools;
import Utilities.EnvUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AccessoryPanel
extends KTitledPanel {
    private static final long serialVersionUID = 1L;
    private static AccessoryPanel singleInstance = null;
    private JRadioButton unixButton = new JRadioButton("unix");
    private JRadioButton windButton = new JRadioButton("win");
    public KTitledPanel formatPanel = new KTitledPanel(" Format ");
    private DirPresetsPanel presetPanel;
    private JPanel padding = new JPanel();
    public JCheckBox showHidden = new JCheckBox("Show Hidden Items", false);
    public boolean fileHidingEnabled = true;

    public static AccessoryPanel getInstance(JFileChooser jfc) {
        if (singleInstance == null) {
            singleInstance = new AccessoryPanel(jfc);
        }
        AccessoryPanel.singleInstance.presetPanel = DirPresetsPanel.getInstance();
        AccessoryPanel.singleInstance.presetPanel.setFileChooser(jfc);
        AccessoryPanel.singleInstance.formatPanel.setEnabled(true);
        AccessoryPanel.singleInstance.presetPanel.setEnabled(true);
        return singleInstance;
    }

    public void enableFormatPanel(boolean flag) {
        this.formatPanel.setEnabled(flag);
    }

    public void enablePresetPanel(boolean flag) {
        this.presetPanel.setEnabled(flag);
    }

    private AccessoryPanel(final JFileChooser chooser) {
        super(" Extras ");
        this.presetPanel = DirPresetsPanel.getInstance();
        this.presetPanel.setFileChooser(chooser);
        this.formatPanel.add(this.windButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.formatPanel.add(this.unixButton, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.formatPanel.add(this.padding, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.windButton);
        radioButtonGroup.add(this.unixButton);
        boolean isWind = EnvUtils.isWinEnvironment();
        this.windButton.setSelected(isWind);
        this.unixButton.setSelected(!isWind);
        this.windButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BBxt.setOutputFormat(1);
            }
        });
        this.unixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BBxt.setOutputFormat(2);
            }
        });
        chooser.setFileHidingEnabled(true);
        this.showHidden.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccessoryPanel.this.fileHidingEnabled = !KTools.getCheckBoxState(e);
                chooser.setFileHidingEnabled(!KTools.getCheckBoxState(e));
                chooser.rescanCurrentDirectory();
            }
        });
        this.add(this.showHidden, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 5, 0)));
        this.add(this.formatPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 10, 0)));
        this.add(this.presetPanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
        this.add(this.padding, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
    }

    public void setFileChooser(JFileChooser jfc) {
        this.presetPanel.setFileChooser(jfc);
    }
}

