/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooserDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JColorChooser chooser;
    public int response = -2;
    private Color outColor = new Color(1.0f, 1.0f, 1.0f);
    private Color inColor = new Color(1.0f, 1.0f, 1.0f);
    private int startSelection;
    private int endSelection;
    private boolean colorStatement = false;
    private boolean openBracket = false;
    private boolean closeBracket = false;
    private boolean openParenthesis = false;
    private boolean closeParenthesis = false;
    private boolean openAngle = false;
    private boolean closeAngle = false;
    private boolean commaSeparated = false;
    private boolean semiColon = false;
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton(" OK ");

    public ColorChooserDialog(JFrame owner, String title) {
        super(owner, title, true);
        this.setVisible(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.chooser = new JColorChooser();
        KTitledPanel mainPanel = new KTitledPanel(" Select a Color ");
        contentPane.add((Component)mainPanel, "Center");
        mainPanel.add(this.chooser, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 10, 0, new Insets(10, 10, 10, 10)));
        this.cancelButton.addActionListener(this);
        mainPanel.add(this.cancelButton, new GBC(4, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 10, 10)));
        this.okButton.addActionListener(this);
        mainPanel.add(this.okButton, new GBC(5, 1, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(0, 0, 10, 10)));
        this.setTitle(title);
        this.pack();
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorChooserDialog.this.outColor = ColorChooserDialog.this.chooser.getColor();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String outColorStr = this.commaSeparated ? NumberUtils.clip((double)this.outColor.getRed() / 255.0) + "," + NumberUtils.clip((double)this.outColor.getGreen() / 255.0) + "," + NumberUtils.clip((double)this.outColor.getBlue() / 255.0) : NumberUtils.clip((double)this.outColor.getRed() / 255.0) + " " + NumberUtils.clip((double)this.outColor.getGreen() / 255.0) + " " + NumberUtils.clip((double)this.outColor.getBlue() / 255.0);
            JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
            if (textpane == null) {
                BBxt.newDocument("untitled");
            }
            if (this.startSelection != -1 && this.endSelection != -1) {
                if (this.colorStatement) {
                    outColorStr = "Color " + outColorStr;
                }
                if (this.openBracket) {
                    outColorStr = "[" + outColorStr;
                } else if (this.openAngle) {
                    outColorStr = "<" + outColorStr;
                } else if (this.openParenthesis) {
                    outColorStr = "(" + outColorStr;
                }
                if (this.closeBracket) {
                    outColorStr = outColorStr + "]";
                } else if (this.closeAngle) {
                    outColorStr = outColorStr + ">";
                } else if (this.closeParenthesis) {
                    outColorStr = outColorStr + ")";
                }
                if (this.semiColon) {
                    outColorStr = outColorStr + ";";
                }
                BBxt.replaceSelection(outColorStr);
            }
        }
        this.setVisible(false);
    }

    private Color extractColorFromSelection() {
        String[] rgbStr;
        double[] rgb = new double[]{1.0, 1.0, 1.0};
        this.startSelection = BBxt.getSelectionStart();
        this.endSelection = BBxt.getSelectionEnd();
        if (this.startSelection == -1 || this.endSelection == -1 || this.startSelection == this.endSelection) {
            return null;
        }
        String selection = BBxt.getSelection();
        if (selection != null && (rgbStr = TextUtils.tokenize(selection)) != null) {
            if (rgbStr[0].equalsIgnoreCase("Color") && rgbStr.length != 4) {
                JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The Color PIcker utility has found the statement\n\"Color\" but is unable to find 3 separate values.\n\nAn example of an acceptable statement would be,\nColor 1 1 1", "Error -  Color Picker", 0);
                return null;
            }
            if (rgbStr[0].equalsIgnoreCase("Color") && rgbStr.length >= 4) {
                try {
                    for (int n = 0; n < 3; ++n) {
                        rgb[n] = Double.valueOf(rgbStr[n + 1]);
                        if (!(rgb[n] > 1.0) && !(rgb[n] < 0.0)) continue;
                        ColorChooserDialog.showOutOfRangeError();
                        rgb[n] = rgb[n] > 1.0 ? 1.0 : rgb[n];
                        rgb[n] = rgb[n] < 0.0 ? 0.0 : rgb[n];
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "One of the items in the \"Color\" statement you have\nyou have selected is not a number!\n\nAn example of an acceptable statement would be,\nColor 1 1 1", "Error -  Color Picker", 0);
                    return null;
                }
                this.colorStatement = true;
            } else if (rgbStr.length >= 3) {
                int n;
                int numComponents = 0;
                for (n = 0; n < rgbStr.length; ++n) {
                    String temp = TextUtils.remove(rgbStr[n], '[');
                    if (!temp.equals(rgbStr[n])) {
                        this.openBracket = true;
                    }
                    rgbStr[n] = temp;
                    temp = TextUtils.remove(rgbStr[n], ']');
                    if (!temp.equals(rgbStr[n])) {
                        this.closeBracket = true;
                    }
                    rgbStr[n] = temp;
                }
                if (rgbStr.length != 3) {
                    ColorChooserDialog.showNumberError();
                    return null;
                }
                try {
                    for (n = 0; n < rgbStr.length; ++n) {
                        if (rgbStr[n].length() <= 0) continue;
                        rgb[n] = Double.valueOf(rgbStr[n]);
                        if (rgb[n] > 1.0 || rgb[n] < 0.0) {
                            ColorChooserDialog.showOutOfRangeError();
                            rgb[n] = rgb[n] > 1.0 ? 1.0 : rgb[n];
                            rgb[n] = rgb[n] < 0.0 ? 0.0 : rgb[n];
                        }
                        ++numComponents;
                        if (n <= 2) continue;
                        ColorChooserDialog.showNumberError();
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    ColorChooserDialog.showFormatError();
                    return null;
                }
                if (numComponents != 3) {
                    ColorChooserDialog.showNumberError();
                    return null;
                }
            } else {
                ColorChooserDialog.showNumberError();
                return null;
            }
        }
        return new Color((int)(rgb[0] * 255.0), (int)(rgb[1] * 255.0), (int)(rgb[2] * 255.0));
    }

    public void chooseColor() {
        this.colorStatement = false;
        this.openBracket = false;
        this.closeBracket = false;
        String str = BBxt.getSelection();
        if (str == null || str.trim().length() == 0) {
            this.inColor = new Color(255, 255, 255);
        } else if (str.indexOf(44) == -1) {
            this.inColor = this.extractColorFromSelection();
        } else {
            this.commaSeparated = true;
            if (str.indexOf(40) != -1) {
                this.openParenthesis = true;
            }
            if (str.indexOf(41) != -1) {
                this.closeParenthesis = true;
            }
            if (str.indexOf(60) != -1) {
                this.openAngle = true;
            }
            if (str.indexOf(62) != -1) {
                this.closeAngle = true;
            }
            if (str.indexOf(59) != -1) {
                this.semiColon = true;
            }
            this.inColor = this.extractColor(str);
        }
        if (this.inColor == null) {
            Cutter.setLog("    Warning:ColorChooserDialog.chooseColor() could not parse selected color");
            return;
        }
        this.chooser.setColor(this.inColor);
        this.setVisible(true);
    }

    private Color extractColor(String str) {
        String[] t = TextUtils.tokenize(str, " ,();");
        float r = -1.0f;
        float g = -1.0f;
        float b = -1.0f;
        if (t != null && t.length == 3) {
            try {
                r = Float.parseFloat(t[0]);
                g = Float.parseFloat(t[1]);
                b = Float.parseFloat(t[2]);
            }
            catch (NumberFormatException e) {
                return new Color(1.0f, 1.0f, 1.0f);
            }
            if (r < 0.0f || g < 0.0f || b < 0.0f || r > 1.0f || g > 1.0f || b > 1.0f) {
                return new Color(1.0f, 1.0f, 1.0f);
            }
            return new Color(r, g, b);
        }
        return new Color(1.0f, 1.0f, 1.0f);
    }

    private static void showFormatError() {
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "One of the items you have chosen is not a number!\n\nAn example of an acceptable statement would be,\n[1 1 1]", "Color Picker - Number Format Error", 0);
    }

    private static void showNumberError() {
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Color Picker requires three numbers in order\nto definde the rgb value of a color.\n", "Color Picker - Insufficient Values Error", 0);
    }

    private static void showOutOfRangeError() {
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "RGB values must be in the range 0 to 1.\nColor Picker will correct the error.", "Color Picker - RGB Format Error", 0);
    }
}

