/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import Preferences.Preferences;
import UI_Components.ButtonPopups.DefaultMenuModel;
import UI_Components.ButtonPopups.KButtonPopup;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RenderInfo;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DirPresetsPanel
extends KTitledPanel {
    public static JFileChooser currentChooser = null;
    private static DirPresetsPanel singleInstance = null;
    private static DefaultMenuModel sharedDMM = null;
    private String version = "";
    public KButtonPopup buttonPopup = null;
    private KButton addDirButton = new KButton();
    private KButton remDirButton = new KButton();
    private JPanel padding = new JPanel();
    private DefaultMenuModel dmm = null;
    private File[] listOfRecents = null;

    public static DirPresetsPanel getInstance() {
        if (singleInstance == null) {
            singleInstance = new DirPresetsPanel();
            DirPresetsPanel.addDefaultDirectories(singleInstance);
            singleInstance.addPopupMenuListener();
            return singleInstance;
        }
        return singleInstance;
    }

    private void addPopupMenuListener() {
        this.buttonPopup.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }

    public void saveSelf() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.dmm.listOfAppendedItems.size(); ++n) {
            JMenuItem item = this.dmm.listOfAppendedItems.elementAt(n);
            buf.append(item.getText()).append('\u0010');
        }
        Preferences.write(Preferences.UI_DIR_PRESETS_APPENDED_PATHS, buf.toString());
    }

    private static File getMayaDir() {
        File maya = new File(Cutter.MAYA_USER_DIR);
        if (maya.exists()) {
            return maya;
        }
        String usersPath = EnvUtils.getUsersHomeDir();
        if (EnvUtils.isOSXEnvironment()) {
            maya = new File(usersPath, "Documents");
            maya = new File(maya, "maya");
        } else if (EnvUtils.isWinEnvironment()) {
            String mayaPath;
            String s = EnvUtils.getUsersPWD();
            if (s != null && s.trim().length() > 0 && !(maya = new File(mayaPath = s.charAt(0) + ":/maya")).exists()) {
                maya = new File("C:/Documents and Settings/My Documents/maya");
                if (!maya.exists()) {
                    Cutter.setLog("    Warning: DirPresetsPanel.addDefaultDirectories() - cannot find maya at \"C:/Documents and Settings/My Documents/maya\".");
                    maya = new File("C:/Users/Documents/maya");
                }
                if (!maya.exists()) {
                    Cutter.setLog("    Warning: DirPresetsPanel.addDefaultDirectories() - cannot find maya at \"C:/Users/Documents/maya\".");
                }
            }
        } else {
            maya = new File(usersPath, "maya");
        }
        return maya.exists() ? maya : null;
    }

    private static void addDefaultDirectories(DirPresetsPanel panel) {
        File f;
        String arnold_devkit;
        File arnold_devkit_include;
        String arnold_cpp_src;
        File arnold_cpp_dir;
        String arnold_osl_src;
        File arnold_osl_dir;
        File f2;
        String path;
        File projects;
        File defalt;
        File renderman;
        File f3;
        String args;
        File f4;
        String str;
        File file;
        if (panel == null) {
            return;
        }
        if (Cutter.listOfDirPresets != null) {
            for (int n = 0; n < Cutter.listOfDirPresets.size(); ++n) {
                File f5 = Cutter.listOfDirPresets.elementAt(n);
                Cutter.setLog("    Info: DirPresetsPanel.addDefaultDirectories adding " + f5.getPath());
                if (!f5.exists()) continue;
                panel.dmm.add(f5);
            }
        }
        panel.dmm.add(FileUtils.getPWDFile(), Color.blue);
        File maya = DirPresetsPanel.getMayaDir();
        if (maya != null && maya.exists() && (file = RenderInfo.rfmMajorVersionNumber() < 22 ? DirPresetsPanel.getPre22Dirs(panel, maya) : DirPresetsPanel.getPost21Dirs(panel, maya)) != null) {
            panel.dmm.addUnderscoredSeparator("___________RenderMan__________");
            panel.dmm.add(file);
        }
        if ((str = Preferences.get(Preferences.PATH_USER_OSL_SOURCE)).trim().length() > 0 && (f4 = new File(str)).exists()) {
            panel.dmm.add(f4);
            File guess = new File(f4.getParent(), "src_c++");
            if (guess.exists()) {
                panel.dmm.add(guess);
            }
        }
        if ((args = Preferences.get(Preferences.PATH_USER_ARGS)).trim().length() > 0 && (f3 = new File(args)).exists()) {
            panel.dmm.add(f3);
        }
        if (maya != null && maya.exists() && (renderman = new File(defalt = new File(projects = new File(maya, "projects"), "default"), "renderman")).exists()) {
            panel.dmm.add(renderman);
        }
        if ((path = RenderInfo.getRPSPath()) != null && path.trim().length() > 0 && (f2 = new File(path).getParentFile()).exists()) {
            panel.dmm.add(f2);
        }
        if ((arnold_osl_dir = new File(arnold_osl_src = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SOURCE))) != null && arnold_osl_dir.exists()) {
            panel.dmm.addUnderscoredSeparator("_____________Anold_____________");
            panel.dmm.add(arnold_osl_dir);
        }
        if ((arnold_cpp_dir = new File(arnold_cpp_src = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_SRC))) != null && arnold_cpp_dir.exists()) {
            panel.dmm.add(arnold_cpp_dir);
        }
        if ((arnold_devkit_include = new File(arnold_devkit = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT), "include")) != null && arnold_devkit_include.exists()) {
            panel.dmm.add(arnold_devkit_include);
        }
        if ((str = Preferences.get(Preferences.HOUDINI_USER_VFL_SRC_PATH)).trim().length() > 0 && (f = new File(str)).exists()) {
            panel.dmm.add(f);
        }
    }

    private static File getPost21Dirs(DirPresetsPanel panel, File maya) {
        int n;
        File projects = new File(maya, "projects");
        Hashtable<String, String> lut = new Hashtable<String, String>();
        boolean rfm22ScriptsFound = false;
        File[] subs = FileUtils.getListOfSubDirs(maya);
        if (subs != null) {
            for (n = 0; n < subs.length; ++n) {
                if (!FileUtils.containsSubdirNamed(subs[n], "config")) continue;
                rfm22ScriptsFound = true;
                if (lut.containsKey(subs[n].getName())) continue;
                lut.put(subs[n].getName(), subs[n].getName());
                return subs[n];
            }
        }
        if (!rfm22ScriptsFound && (subs = FileUtils.getListOfSubDirs(projects)) != null) {
            for (n = 0; n < subs.length; ++n) {
                if (!FileUtils.containsSubdirNamed(subs[n], "config")) continue;
                rfm22ScriptsFound = true;
                if (lut.containsKey(subs[n].getName())) continue;
                lut.put(subs[n].getName(), subs[n].getName());
                return subs[n];
            }
        }
        return null;
    }

    private static File getPre22Dirs(DirPresetsPanel panel, File maya) {
        Hashtable<String, String> lut = new Hashtable<String, String>();
        File projects = new File(maya, "projects");
        boolean addPre22Dirs = false;
        String[] names = FileUtils.getListOfDirNames(projects);
        if (names != null) {
            for (int n = 0; n < names.length; ++n) {
                if (lut.containsKey(names[n])) continue;
                lut.put(names[n], names[n]);
                if (names[n].startsWith("RMS_")) {
                    return new File(projects, names[n]);
                }
                if (!names[n].startsWith("RfM_")) continue;
                File f = new File(projects, names[n]);
                return f;
            }
        }
        return null;
    }

    private DirPresetsPanel() {
        super(" Favorites & Recent ");
        String[] paths;
        ImageIcon plusIcon = ResourceUtils.getIconResource("/resources/plus.gif");
        this.addDirButton.setIcon(plusIcon);
        ImageIcon minusIcon = ResourceUtils.getIconResource("/resources/minus.gif");
        this.remDirButton.setIcon(minusIcon);
        this.dmm = new DefaultMenuModel();
        String rawInput = Preferences.get(Preferences.UI_DIR_PRESETS_APPENDED_PATHS);
        if (rawInput != null && rawInput.trim().length() > 0 && (paths = TextUtils.tokenize(rawInput, '\u0010')) != null && paths.length > 0) {
            for (int n = 0; n < paths.length; ++n) {
                File dir = new File(paths[n]);
                if (!dir.exists()) continue;
                this.dmm.append(dir, Color.DARK_GRAY);
            }
        }
        DirPresetsPanel.addDefaultDirectories(singleInstance);
        this.buttonPopup = new KButtonPopup();
        ImageIcon dirIcon = ResourceUtils.getIconResource("/resources/directories.gif");
        this.buttonPopup.setIcon(dirIcon);
        this.buttonPopup.addItemsToPopup(this.dmm);
        this.buttonPopup.setMargin(new Insets(-1, 2, 1, 2));
        this.addDirButton.setMargin(new Insets(-1, 5, 1, 5));
        this.remDirButton.setMargin(new Insets(-1, 5, 1, 5));
        this.add(this.buttonPopup, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, -1, 18, 0, new Insets(0, 5, 5, 0)));
        this.add(this.addDirButton, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, -1, 18, 0, new Insets(0, 10, 0, 0)));
        this.add(this.remDirButton, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, -1, 18, 0, new Insets(0, 10, 0, 5)));
        this.addDirButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir = currentChooser.getCurrentDirectory();
                DirPresetsPanel.this.dmm.append(dir, Color.DARK_GRAY);
            }
        });
        this.remDirButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String relative;
                File dir = currentChooser.getCurrentDirectory();
                String fullpath = dir.getPath();
                boolean result = DirPresetsPanel.this.dmm.remove(fullpath);
                if (!result && (relative = FileUtils.fullToRelative(FileUtils.getPWD(), fullpath, "")) != null && relative.trim().length() > 0) {
                    DirPresetsPanel.this.dmm.remove(relative);
                }
            }
        });
    }

    public void setFileChooser(JFileChooser jfc) {
        currentChooser = jfc;
        this.addDirButton.setToolTipText("Add the current directory to the list of preset locations.");
        this.remDirButton.setToolTipText("Remove the current directory from the list of preset locations.");
    }
}

