/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import UI_BBXT.BBxt;
import UI_Components.Dialog.AccessoryPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.ScriptRegistry;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileChooserDialog {
    private JFileChooser chooser = null;
    private int response = 1;
    private Component parent = null;
    private String approveButtonText = "Choose File";
    private boolean fileHiding = false;
    private int fileSelectionMode = 2;
    private static File prevFile = null;
    private boolean rescanDirectory = false;
    private AccessoryPanel accessoryPanel = null;

    public FileChooserDialog(Component parent) {
        this(parent, null);
    }

    public FileChooserDialog(Component parent, String approveText) {
        this.parent = parent;
        this.approveButtonText = approveText;
    }

    public void setFileHidingEnabled(boolean flag) {
        this.fileHiding = flag;
    }

    public void setApproveButtonText(String label) {
        this.approveButtonText = label;
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public void setCurrentDirectory(File dir) {
        prevFile = dir;
    }

    public void rescanCurrentDirectory(boolean flag) {
        this.rescanDirectory = flag;
    }

    public File[] getSelectedFiles(KFileFilter filter) {
        this.chooser = new JFileChooser();
        this.chooser.setMultiSelectionEnabled(true);
        this.accessoryPanel = AccessoryPanel.getInstance(this.chooser);
        this.chooser.setAccessory(this.accessoryPanel);
        this.accessoryPanel.setFileChooser(this.chooser);
        if (this.approveButtonText != null) {
            this.chooser.setApproveButtonText(this.approveButtonText);
        }
        if (prevFile == null) {
            File f = BBxt.getFrontWindowFile();
            prevFile = f == null ? new File(FileUtils.getPWD()) : f.getParentFile();
        }
        this.chooser.setFileSelectionMode(this.fileSelectionMode);
        prevFile = FileUtils.getExistingParent(prevFile);
        this.chooser.setCurrentDirectory(prevFile);
        FileFilter allFilter = this.chooser.getAcceptAllFileFilter();
        this.chooser.setFileHidingEnabled(this.fileHiding);
        if (!this.fileHiding) {
            FileFilter[] filters = this.chooser.getChoosableFileFilters();
            for (int i = 0; i < filters.length; ++i) {
                this.chooser.removeChoosableFileFilter(filters[i]);
            }
            KFileFilter[] allscripts = ScriptRegistry.getAllFileFilters();
            for (int n = 0; n < allscripts.length; ++n) {
                if (filter != null && allscripts[n].getDescription().equals(filter.getDescription())) continue;
                this.chooser.addChoosableFileFilter(allscripts[n]);
            }
            this.chooser.addChoosableFileFilter(allFilter);
            if (filter != null) {
                this.chooser.addChoosableFileFilter(filter);
            }
        }
        if (this.rescanDirectory) {
            this.chooser.rescanCurrentDirectory();
        }
        this.response = this.chooser.showOpenDialog(this.parent);
        this.chooser.setVisible(false);
        this.chooser.setAccessory(null);
        if (this.response == 1) {
            return null;
        }
        File[] files = this.chooser.getSelectedFiles();
        if (files == null) {
            return null;
        }
        if (files != null && files.length == 1 && KAbstractDesktop.windowExists(files[0])) {
            JOptionPane.showMessageDialog(Cutter.desktop, "The document \"" + files[0].getName() + "\" is already \nopen and will be brought to the front.", "Duplicate Document Warning", 0);
            KAbstractWindow window = KAbstractDesktop.getWindowWithTitle(files[0].getName());
            if (window != null) {
                KAbstractDesktop.toFront(window);
            }
            return null;
        }
        if (files != null && files.length == 1 && KAbstractDesktop.windowExists(files[0].getName())) {
            JOptionPane.showMessageDialog(Cutter.desktop, "A document with the same name but located\nin a different directory is already open.\n\nBe careful to edit the \"correct\" document!", "Duplicate Document Warning", 2);
        }
        prevFile = files[0];
        return files;
    }
}

