/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import UI_BBXT.BBxt;
import UI_Components.Dialog.AccessoryPanel;
import UI_Delegates.CutterLF;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.ScriptRegistry;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.ComponentUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class OpenFileDialog {
    private static OpenFileDialog ofd = null;
    public static JFileChooser chooser = new JFileChooser();
    public static File prevFile = null;
    private static boolean rescanDirectory = false;
    public static AccessoryPanel accessoryPanel = null;

    public static OpenFileDialog getInstance(JFrame frame) {
        if (ofd == null) {
            ofd = new OpenFileDialog();
        }
        return ofd;
    }

    private OpenFileDialog() {
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(true);
        accessoryPanel = AccessoryPanel.getInstance(chooser);
        chooser.setAccessory(accessoryPanel);
        chooser.setFileHidingEnabled(true);
        if (CutterLF.isUsingSlate()) {
            ComponentUtils tfUtil;
            ComponentUtils lUtil = new ComponentUtils(chooser, "javax.swing.JList");
            Component[] comps = lUtil.getAll();
            if (comps.length > 0 && comps[0] instanceof JList) {
                JList l = (JList)comps[0];
                l.setSelectionBackground(CutterLF.openFileSelectionBackground);
            }
            if ((comps = (tfUtil = new ComponentUtils(chooser, "javax.swing.JTextField")).getAll()).length > 0 && comps[0] instanceof JTextField) {
                JTextField tf = (JTextField)comps[0];
                tf.setSelectionColor(Color.YELLOW);
            }
        }
    }

    public File[] showSelf(KFileFilter infilter, String approveButtonLabel, int fileSelectionMode) {
        return this.showSelf(infilter, approveButtonLabel, fileSelectionMode, false);
    }

    public File[] showSelf(KFileFilter infilter, String approveButtonLabel, int fileSelectionMode, boolean filtersHaveBeenCulled) {
        accessoryPanel = AccessoryPanel.getInstance(chooser);
        chooser.setAccessory(accessoryPanel);
        accessoryPanel.setFileChooser(chooser);
        accessoryPanel.enableFormatPanel(false);
        prevFile = this.getPrevFile();
        chooser.setFileSelectionMode(fileSelectionMode);
        if (prevFile.exists()) {
            chooser.setCurrentDirectory(prevFile);
        }
        FileFilter allFilter = chooser.getAcceptAllFileFilter();
        if (fileSelectionMode != 1 && !filtersHaveBeenCulled) {
            FileFilter[] filters = chooser.getChoosableFileFilters();
            for (int i = 0; i < filters.length; ++i) {
                chooser.removeChoosableFileFilter(filters[i]);
            }
            KFileFilter[] allscripts = ScriptRegistry.getAllFileFilters();
            for (int n = 0; n < allscripts.length; ++n) {
                if (infilter != null && allscripts[n].getDescription().equals(infilter.getDescription())) continue;
                chooser.addChoosableFileFilter(allscripts[n]);
            }
            chooser.addChoosableFileFilter(allFilter);
            if (infilter != null) {
                chooser.addChoosableFileFilter(infilter);
                chooser.setFileFilter(infilter);
            } else {
                chooser.setFileFilter(allFilter);
            }
        }
        if (rescanDirectory) {
            chooser.rescanCurrentDirectory();
        }
        ComponentUtils cu = new ComponentUtils(chooser, "javax.swing.JComboBox");
        Component[] comps = cu.getAll();
        boolean done = false;
        for (int n = 0; n < comps.length; ++n) {
            if (!(comps[n] instanceof JComboBox)) continue;
            int count = ((JComboBox)comps[n]).getItemCount();
            for (int i = 0; i < count; ++i) {
                if (!(((JComboBox)comps[n]).getItemAt(i) instanceof FileFilter)) continue;
                ((JComboBox)comps[n]).setMaximumRowCount(25);
                done = true;
                break;
            }
            if (done) break;
        }
        int response = 1;
        try {
            response = chooser.showDialog(Cutter.desktop, approveButtonLabel);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: OpenFileDialog.showSelf() " + e.toString());
        }
        chooser.setAccessory(new JPanel());
        if (response == 1) {
            return null;
        }
        File[] files = chooser.getSelectedFiles();
        if (files == null) {
            return null;
        }
        if (files != null && files.length == 1 && KAbstractDesktop.windowExists(files[0])) {
            JOptionPane.showMessageDialog(Cutter.desktop, "The document \"" + files[0].getName() + "\" is already \nopen and will be brought to the front.", "Duplicate Document Warning", 0);
            KAbstractWindow window = KAbstractDesktop.getWindowWithTitle(files[0].getName());
            if (window != null) {
                KAbstractDesktop.toFront(window);
            }
            return null;
        }
        if (files != null && files.length == 1 && KAbstractDesktop.windowExists(files[0].getName())) {
            JOptionPane.showMessageDialog(Cutter.desktop, "A document with the same name but located\nin a different directory is already open.\n\nBe careful to edit the \"correct\" document!", "Duplicate Document Warning", 2);
        }
        if (files != null && files.length > 0) {
            prevFile = files[0];
        }
        return files;
    }

    public void setFileHidingEnabled(boolean flag) {
        chooser.setFileHidingEnabled(flag);
    }

    public void rescanCurrentDirectory(boolean flag) {
        rescanDirectory = flag;
    }

    public void setCurrentDirectory(File dir) {
        this.setPrevFile(dir);
    }

    public void setPrevFile(File f) {
        prevFile = f;
    }

    public File getPrevFile() {
        if (prevFile != null && !prevFile.exists()) {
            return FileUtils.getExistingParent(prevFile);
        }
        if (prevFile == null) {
            File f = BBxt.getFrontWindowFile();
            prevFile = f == null ? new File(FileUtils.getPWD()) : (f.exists() && f.getParentFile() != null && f.getParentFile().exists() ? f.getParentFile() : new File(FileUtils.getPWD()));
        }
        return prevFile;
    }
}

