/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import UI_BBXT.BBxt;
import UI_Components.Dialog.AccessoryPanel;
import UI_Delegates.CutterLF;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.ComponentUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveFileDialog {
    private static final int CANCEL = 0;
    private static final int REPLACE = 1;
    private static final String[] options = new String[]{"Cancel", "Replace"};
    public static JFileChooser chooser = new JFileChooser();
    public static AccessoryPanel accessoryPanel = null;
    public static int response = -2;
    public static File prevDir = null;
    public static String title = "";
    private static SaveFileDialog sfd = null;

    public static SaveFileDialog getInstance(JFrame frame, String title) {
        if (sfd == null) {
            sfd = new SaveFileDialog(title);
        }
        SaveFileDialog.title = title;
        return sfd;
    }

    private SaveFileDialog(String title) {
        chooser.setDialogType(1);
        accessoryPanel = AccessoryPanel.getInstance(chooser);
        chooser.setAccessory(accessoryPanel);
        accessoryPanel.setFileChooser(chooser);
        if (CutterLF.isUsingSlate()) {
            ComponentUtils lUtil;
            ComponentUtils tfUtil = new ComponentUtils(chooser, "javax.swing.JTextField");
            Component[] comps = tfUtil.getAll();
            if (comps.length > 0 && comps[0] instanceof JTextField) {
                JTextField tf = (JTextField)comps[0];
                tf.setSelectionColor(Color.YELLOW);
            }
            if ((comps = (lUtil = new ComponentUtils(chooser, "javax.swing.JList")).getAll()).length > 0 && comps[0] instanceof JList) {
                JList l = (JList)comps[0];
                l.setSelectionBackground(CutterLF.saveFileSelectionBackground);
            }
        }
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                File file = chooser.getSelectedFile();
                if (file == null || state.equals("CancelSelection")) {
                    response = -2;
                } else if (state.equals("ApproveSelection")) {
                    if (file.exists()) {
                        int result = JOptionPane.showOptionDialog(KAbstractDesktop.desktopPane, "A document named\n    \"" + file.getName() + "\"\nalready exists. Are you sure you want to\nreplace the existing document with this one?", "Warning", -1, 2, null, options, options[0]);
                        switch (result) {
                            case 0: {
                                response = -2;
                                break;
                            }
                            case 1: {
                                response = 0;
                            }
                        }
                        if (result == 1 && BBxt.frontWindow() instanceof KAbstractTextWindow) {
                            KAbstractTextWindow window = (KAbstractTextWindow)BBxt.frontWindow();
                            window.resolveHistoryZipClash(file);
                        }
                    } else if (KAbstractDesktop.windowExists(file)) {
                        int result = JOptionPane.showOptionDialog(KAbstractDesktop.desktopPane, "A document called \"" + file.getName() + "\"\nis already open. Choose another name or location for the document", "Warning", -1, 2, null, options, options[0]);
                        switch (result) {
                            case 0: {
                                response = -2;
                            }
                            case 1: {
                                response = 0;
                            }
                        }
                    } else {
                        response = 0;
                    }
                    prevDir = file;
                }
            }
        });
    }

    public void setFileFilter(KFileFilter filter) {
        chooser.setFileFilter(filter);
    }

    public synchronized int showSelf(String title) {
        if (prevDir == null) {
            prevDir = new File(FileUtils.getPWD());
        }
        chooser.setSelectedFile(prevDir);
        accessoryPanel = AccessoryPanel.getInstance(chooser);
        chooser.setAccessory(accessoryPanel);
        accessoryPanel.setFileChooser(chooser);
        accessoryPanel.enableFormatPanel(true);
        SaveFileDialog.accessoryPanel.showHidden.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                chooser.setFileHidingEnabled(!KTools.getCheckBoxState(e));
                chooser.rescanCurrentDirectory();
            }
        });
        int response = chooser.showDialog(Cutter.desktop, title);
        chooser.setAccessory(new JPanel());
        chooser.resetChoosableFileFilters();
        return response;
    }

    public void setSelectedFile(File f) {
        chooser.setSelectedFile(f);
        prevDir = f;
    }

    public File getSelectedFile() {
        return chooser.getSelectedFile();
    }

    public File getPrevFile() {
        if (prevDir != null && !prevDir.exists()) {
            return FileUtils.getExistingParent(prevDir);
        }
        if (prevDir == null) {
            prevDir = new File(FileUtils.getPWD());
        }
        return prevDir;
    }

    public void setFile(File file) {
    }

    public boolean saveFile(int mode) {
        return true;
    }
}

