/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.Dialog;

import ClientServer.ClientServer.client.Client;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Components.LabelledTextField;
import UI_Desktop.Desktop.KAbstractDesktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SelectServerDialog
extends JDialog
implements ActionListener {
    public static final String CANCEL = "cancel";
    public static final String OK = "ok";
    private JFrame owner;
    public String response = "cancel";
    static String serverIP = "";
    static int serverPort = 1024;
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton(" OK ");
    private KTitledComboBox serverCombo = new KTitledComboBox("IP Address");
    private LabelledTextField portTextfield = new LabelledTextField("Port", " " + serverPort + " ", 2, 46);

    public SelectServerDialog(JFrame owner, String title) {
        super(owner, title, true);
        this.setVisible(false);
        this.owner = owner;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        KTitledPanel serverPanel = new KTitledPanel(" Server ");
        this.serverCombo.comboWidth = 100;
        this.serverCombo.addItem(Client.getLocalIP());
        this.serverCombo.combo.setEditable(true);
        serverPanel.add(this.serverCombo);
        serverPanel.add(this.portTextfield);
        this.portTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectServerDialog.this.setPortID(((JTextField)e.getSource()).getText());
                ((JTextField)e.getSource()).setText("" + serverPort);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.gridwidth = 4;
        contentPane.add((Component)serverPanel, gbc);
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 2);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.cancelButton.addActionListener(this);
        contentPane.add((Component)this.cancelButton, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(10, 2, 10, 15);
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.okButton.addActionListener(this);
        contentPane.add((Component)this.okButton, gbc);
        this.setTitle(title);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (!this.setPortID(this.portTextfield.textfield.getText())) {
                this.response = "";
                return;
            }
            serverIP = this.serverCombo.getSelectedItem();
            this.response = OK;
        } else if (e.getSource() == this.cancelButton) {
            this.response = CANCEL;
        }
        this.setVisible(false);
    }

    private boolean setPortID(String str) {
        int id;
        str = str.trim();
        try {
            id = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "A port number cannot contain letters", "Port Error", 0);
            this.portTextfield.textfield.setText("" + serverPort);
            return false;
        }
        if (id < 1024) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cutter uses port numbers of 1024 and greater", "Port Error", 0);
            this.portTextfield.textfield.setText("" + serverPort);
            return false;
        }
        serverPort = id > 1024 ? id : 1024;
        return true;
    }

    public String showSelf() {
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        Dimension dialogSize = this.getSize();
        Rectangle bounds = this.getBounds();
        this.setBounds(bounds.x - dialogSize.width / 2, bounds.y - dialogSize.height / 2, dialogSize.width, dialogSize.height);
        return this.response;
    }
}

