/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KButton;

import UI_Components.ToolTip.MultiLineToolTip;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolTip;

public class KButton
extends JButton
implements Serializable {
    private MultiLineToolTip tip = null;

    public KButton() {
    }

    public KButton(String label) {
        this();
        this.setText(label);
    }

    public KButton(String label, Color bg, Color tx) {
        this(label);
        this.setBackground(bg);
        this.setForeground(tx);
        this.setFocusPainted(false);
    }

    public KButton(String label, Color bg, Color tx, Color hilite, Color shadow) {
        this(label);
        this.setBackground(bg);
        this.setForeground(tx);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEtchedBorder(0, hilite, shadow));
    }

    public KButton(String label, Insets in) {
        this();
        this.setText(label);
        this.setMargin(in);
    }

    public KButton(String label, Icon icon) {
        super(label, icon);
    }

    @Override
    public void setToolTipText(String tipText) {
        super.setToolTipText(tipText);
        tipText = TextUtils.format(tipText, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
        this.tip = new MultiLineToolTip(tipText);
    }

    @Override
    public JToolTip createToolTip() {
        return this.tip;
    }
}

