/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KButton;

import UI_Components.KButton.KButtonCommentManager;
import UI_Components.KButton.KButtonCommentUI;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DesktopManager;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KButtonComment
extends JInternalFrame
implements MouseListener,
MouseMotionListener,
ComponentListener {
    public static int DEFAULT_SHEET_TEXT_WIDTH = 40;
    public static int DEFAULT_SHEET_TEXT_LENGTH = 100;
    public static final int DEFAULT_X_OFFSET = 25;
    public static final int DEFAULT_Y_OFFSET = 0;
    public Point lastPosition = new Point(25, 0);
    private Point mouseOffset = null;
    private Dimension dimension;
    static int id = 1;
    private int ID;
    private DesktopManager manager;

    public KButtonComment(String text, DesktopManager manager) {
        this.manager = manager;
        text = TextUtils.format(text, DEFAULT_SHEET_TEXT_WIDTH);
        this.ID = id++;
        this.getContentPane().setLayout(new GridBagLayout());
        this.ui = new KButtonCommentUI(this, text + this.ID);
        this.setUI(this.ui);
        this.setForeground((Color)UIManager.get("ToolTip.foreground"));
        this.setBackground((Color)UIManager.get("ToolTip.background"));
        this.setBorder((Border)UIManager.get("ToolTip.border"));
        this.addComponentListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setEnabled(true);
        this.requestFocus();
        System.out.println("KButtonComment.mouseEntered");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setEnabled(false);
        System.out.println("KButtonComment.mouseExited");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.getBounds().contains(e.getPoint())) {
            return;
        }
        int offsetX = e.getX() - this.getLocation().x;
        int offsetY = e.getY() - this.getLocation().y;
        this.mouseOffset = new Point(offsetX, offsetY);
        System.out.println("mousePressed " + this.ID + "  mouseOffset   " + this.mouseOffset);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseOffset = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseOffset == null) {
            return;
        }
        this.manager.setBoundsForFrame(this, e.getX() - this.mouseOffset.x, e.getY() - this.mouseOffset.y, this.dimension.width, this.dimension.height);
        System.out.println("mouseDragged");
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.lastPosition = this.getLocation();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.lastPosition = this.getLocation();
        System.out.println("componentHidden " + this.ID + "  lastPosition   " + this.lastPosition);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        System.out.println("componentShown " + this.ID + "  lastPosition   " + this.lastPosition);
        this.setLocation(this.lastPosition);
        KButtonCommentManager.setActive(this);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
    }
}

