/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KButton;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalInternalFrameUI;

public class KButtonCommentUI
extends MetalInternalFrameUI {
    public static final FontMetrics metrics;
    public static final Font font;
    private static int hmargin;
    private static int vmargin;
    private String[] strs = null;
    private int maxWidth = 0;
    private int maxHeight = 0;
    public boolean ignoreFirstPaint = true;

    public KButtonCommentUI(JInternalFrame f, String text) {
        super(f);
        this.initLinesOfText(text);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(this.maxWidth + hmargin, this.maxHeight + vmargin);
    }

    private Graphics setClip(Graphics inGraphics) {
        Graphics g = inGraphics;
        g.setClip(0, 0, this.maxWidth + hmargin, this.maxHeight + vmargin);
        return g;
    }

    private void initLinesOfText(String text) {
        BufferedReader br = new BufferedReader(new StringReader(text));
        int maxWidth = 0;
        Vector<String> v = new Vector<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int width = SwingUtilities.computeStringWidth(metrics, line);
                maxWidth = maxWidth < width ? width : maxWidth;
                v.addElement(line);
            }
        }
        catch (IOException ex) {
            System.out.println("    Exception: MultiLineToolTip.ex.initLinesOfText() " + ex.toString());
        }
        int lines = v.size();
        if (lines < 1) {
            this.strs = null;
            lines = 1;
        } else {
            this.strs = new String[lines];
            int i = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.strs[i] = (String)e.nextElement();
                ++i;
            }
        }
        int height = metrics.getHeight() * lines;
        this.maxWidth = maxWidth + 6;
        this.maxHeight = height + 4;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics gg = g;
        Dimension size = c.getSize();
        gg.setColor(c.getBackground());
        gg.fillRect(0, 0, size.width, size.height);
        gg.setColor(c.getForeground());
        gg.setFont(font);
        if (this.strs != null) {
            for (int i = 0; i < this.strs.length; ++i) {
                gg.drawString(this.strs[i], 3, metrics.getHeight() * (i + 1));
            }
        }
    }

    static {
        font = (Font)UIManager.get("ToolTip.font");
        metrics = new JInternalFrame().getFontMetrics(font);
        hmargin = 7;
        vmargin = 0;
    }
}

