/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KButton;

import UI_Components.ToolTip.MultiLineToolTip;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KInfoButton
extends JToggleButton
implements Serializable {
    public static ImageIcon upIcon = ResourceUtils.getIconResource("/resources/help_up.gif");
    private static ImageIcon downIcon = ResourceUtils.getIconResource("/resources/help_down.gif");
    private MultiLineToolTip helptip = null;
    private Popup helpPopup = null;
    private String infoText = "";
    private static final String uiClassID = "KInfoButtonUI";

    public KInfoButton() {
        this.setIcon(upIcon);
        this.setMargin(new Insets(-1, -1, -1, -1));
        this.helpPopup = new Popup();
        this.helpPopup.setBorder(BorderFactory.createEmptyBorder());
        this.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modifiers = e.getModifiers();
                if (((KInfoButton)e.getSource()).isSelected()) {
                    if (downIcon != null) {
                        ((JToggleButton)e.getSource()).setIcon(downIcon);
                    }
                    KInfoButton.this.helpPopup.show(KInfoButton.this, 10, 10);
                } else if (upIcon != null) {
                    ((JToggleButton)e.getSource()).setIcon(upIcon);
                }
            }
        });
    }

    public void setHelpText(String helpText, int width) {
        this.infoText = helpText = TextUtils.format(helpText, width, 200, null);
        this.helptip = new MultiLineToolTip(helpText);
        this.helpPopup.add(this.helptip);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void _modifiedClickHappened(MouseEvent e) {
    }

    public class Popup
    extends JPopupMenu
    implements PopupMenuListener,
    Serializable {
        public Popup() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            KInfoButton.this.doClick();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

