/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KButton;

import UI_Components.Dialog.OpenFileDialog;
import UI_Components.KButton.PathSearchListener;
import UI_Components.KLabelledField;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTextField.KTextField;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class PathSearchButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private OpenFileDialog openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
    private File prevFile = FileUtils.getPWDFile();
    private String prompt;
    private JComponent prefTextField;
    private int fileChooserMode = 2;
    private int filePathMode = 7;
    private int setTextMode = 0;
    private FileFilter wildCardFilter = null;
    private FileFilter[] allFilters = null;
    private String userPreferredFilter = "";
    private Vector<PathSearchListener> listOfPathSearchListeners = new Vector();

    public void addPathSearchListener(PathSearchListener item) {
        this.listOfPathSearchListeners.add(item);
    }

    public PathSearchButton(PrefTextField ptf, String title, int selectionMode) {
        this(ptf, title, selectionMode, 7, 0);
    }

    public PathSearchButton(PrefTextField ptf, String title, int selectionMode, int pathMode, int replaceMode) {
        this(ptf, title, "Choose Path", selectionMode, pathMode, replaceMode);
    }

    public PathSearchButton(PrefTextField ptf, String title, String prompt, int selectionMode) {
        this(ptf, title, prompt, selectionMode, 7, 0);
    }

    public PathSearchButton(PrefTextField ptf, String title, String prompt, int selectionMode, int pathMode, int replaceMode) {
        super(title);
        this.setMargin(new Insets(-1, 5, -2, 5));
        this.prompt = prompt;
        this.prefTextField = ptf;
        this.addActionListener(this);
        this.setFileSelectionMode(selectionMode);
        this.filePathMode = pathMode;
        this.setTextMode = replaceMode;
    }

    public PathSearchButton(KLabelledField ptf, Icon icon, String prompt, int selectionMode) {
        this(ptf, icon, prompt, selectionMode, 7, 0);
    }

    public PathSearchButton(KLabelledField ptf, Icon icon, String prompt, int selectionMode, int pathMode, int replaceMode) {
        super(icon);
        this.setMargin(new Insets(-1, 0, 0, 2));
        this.prompt = prompt;
        this.prefTextField = ptf;
        this.addActionListener(this);
        this.setFileSelectionMode(selectionMode);
        this.filePathMode = pathMode;
        this.setTextMode = replaceMode;
    }

    public PathSearchButton(KSerialTextField ptf, Icon icon, String prompt, int selectionMode) {
        this(ptf, icon, prompt, selectionMode, 7, 0);
    }

    public PathSearchButton(KSerialTextField ptf, Icon icon, String prompt, int selectionMode, int pathMode, int replaceMode) {
        super(icon);
        this.setMargin(new Insets(-1, 0, 0, 2));
        this.prompt = prompt;
        this.prefTextField = ptf;
        this.addActionListener(this);
        this.setFileSelectionMode(selectionMode);
        this.filePathMode = pathMode;
        this.setTextMode = replaceMode;
    }

    public PathSearchButton(KLabelledField ptf, String title, String prompt, int selectionMode) {
        this(ptf, title, prompt, selectionMode, 7, 0);
    }

    public PathSearchButton(KLabelledField ptf, String title, String prompt, int fileChooserMode, int pathMode, int replaceMode) {
        super(title);
        this.setMargin(new Insets(-1, 5, -1, 5));
        this.prompt = prompt;
        this.prefTextField = ptf;
        this.addActionListener(this);
        this.setFileSelectionMode(fileChooserMode);
        this.filePathMode = pathMode;
        this.setTextMode = replaceMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fieldText;
        KTextField jfield;
        if (this.prefTextField instanceof PrefTextField) {
            jfield = ((PrefTextField)this.prefTextField).field;
            fieldText = ((PrefTextField)this.prefTextField).getTextFromField();
        } else if (this.prefTextField instanceof KLabelledField) {
            jfield = ((KLabelledField)this.prefTextField).field;
            fieldText = ((JTextComponent)jfield).getText();
        } else if (this.prefTextField instanceof KSerialTextField) {
            jfield = (KSerialTextField)this.prefTextField;
            fieldText = ((JTextComponent)jfield).getText();
        } else {
            Cutter.setLog("    Error: PathSearchButton.actionPerformed() prefTextField is not correct class");
            return;
        }
        File tmp = FileUtils.getParentDirFromPath(fieldText);
        this.prevFile = fieldText.trim().length() == 0 ? FileUtils.getPWDFile() : (tmp != null && tmp.exists() ? tmp : FileUtils.getExistingParent(tmp));
        if (this.prevFile == null) {
            this.prevFile = FileUtils.getPWDFile();
        }
        File f = this.openFileDialog.getPrevFile();
        this.openFileDialog.setCurrentDirectory(this.prevFile);
        boolean filtersHaveBeenCulled = this.setChooseableFileFilter();
        File[] files = this.openFileDialog.showSelf(null, this.prompt, this.fileChooserMode, filtersHaveBeenCulled);
        this.resetChooseableFileFilter();
        if (files == null) {
            this.openFileDialog.setPrevFile(f);
            for (int n = 0; n < this.listOfPathSearchListeners.size(); ++n) {
                PathSearchListener l = this.listOfPathSearchListeners.elementAt(n);
                l.pathSearchCancelled();
            }
            return;
        }
        if (this.setTextMode == 1) {
            fieldText = TextUtils.trimLeadingChar(fieldText.trim(), ',');
            if ((fieldText = TextUtils.trimTrailingChar(fieldText, ',')).trim().length() != 0) {
                fieldText = fieldText + ",";
            }
        } else {
            fieldText = "";
        }
        this.prevFile = FileUtils.getExistingParent(files[0]);
        if (this.filePathMode == 3) {
            ((JTextComponent)jfield).setText(FileUtils.applyFileSeparator(fieldText + this.prevFile.getName()));
        } else if (this.filePathMode == 7) {
            ((JTextComponent)jfield).setText(FileUtils.applyFileSeparator(fieldText + this.prevFile.getPath()));
        } else if (this.filePathMode == 1) {
            ((JTextComponent)jfield).setText(FileUtils.applyFileSeparator(fieldText + this.prevFile.getParentFile().getPath()));
        }
        this.openFileDialog.setPrevFile(f);
        for (int n = 0; n < this.listOfPathSearchListeners.size(); ++n) {
            PathSearchListener l = this.listOfPathSearchListeners.elementAt(n);
            l.pathSearchCompleted();
        }
    }

    private void setFileSelectionMode(int flag) {
        this.fileChooserMode = flag;
    }

    public void setPreferredFileFilter(String name) {
        this.userPreferredFilter = name;
    }

    private boolean setChooseableFileFilter() {
        if (this.userPreferredFilter.equals("")) {
            Cutter.setLog("    Debug:PathSearchButton.setChooseableFileFilter() - userPreferredFilter has not been set.");
            return false;
        }
        KFileFilter filter = new KFileFilter(this.userPreferredFilter);
        if (filter == null || this.userPreferredFilter.equals("")) {
            return false;
        }
        JFileChooser chooser = OpenFileDialog.chooser;
        this.wildCardFilter = chooser.getAcceptAllFileFilter();
        this.allFilters = chooser.getChoosableFileFilters();
        for (int i = 0; i < this.allFilters.length; ++i) {
            chooser.removeChoosableFileFilter(this.allFilters[i]);
        }
        chooser.addChoosableFileFilter(filter);
        chooser.addChoosableFileFilter(this.wildCardFilter);
        chooser.setFileFilter(filter);
        return true;
    }

    private void resetChooseableFileFilter() {
        if (this.allFilters == null) {
            Cutter.setLog("    Debug:PathSearchButton.resetChooseableFileFilter() - allFilters is null.");
            return;
        }
        JFileChooser chooser = OpenFileDialog.chooser;
        for (int i = 0; i < this.allFilters.length; ++i) {
            chooser.addChoosableFileFilter(this.allFilters[i]);
        }
    }
}

