/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_BBXT.BBxt;
import UI_Components.KFileSelectable;
import UI_Components.KTextArea;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.Find.FindTool;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.CerealUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class KFileTextArea
extends KTextArea
implements ClipboardOwner {
    private Karet caret;
    public final int MAX_ENTRIES = 16;
    private EntriesPopup popup = new EntriesPopup();
    EntriesDataBase entriesDataBase;
    private Vector STFListeners = new Vector();
    private boolean shiftIsDown = false;
    public String serialName = null;
    private int caretOffset = 0;
    private KFileSelectable owner = null;

    public KFileTextArea(int rows, int columns, KFileSelectable owner, String serialName) {
        super(rows, columns);
        this.caret = new Karet(this);
        this.caret.setBlinkRate(((DefaultCaret)this.getCaret()).getBlinkRate());
        this.setCaret(this.caret);
        this.owner = owner;
        this.serialName = serialName;
        Object obj = CerealUtils.readFromFile(serialName);
        this.entriesDataBase = obj != null && obj instanceof EntriesDataBase ? (EntriesDataBase)obj : new EntriesDataBase();
        if (this.entriesDataBase.size() > 0) {
            this.setText(this.entriesDataBase.textAt(0));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KFileTextArea.this.handlePopupTrigger(e);
                }
                super.mouseReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.isAltDown() || e.isMetaDown()) {
                    KFileTextArea.this.handlePopupTrigger(e);
                }
                super.mousePressed(e);
            }
        });
    }

    private void handlePopupTrigger(MouseEvent e) {
        this.shiftIsDown = e.isShiftDown();
        this.caretOffset = this.getSelectionStart();
        this.popup.show(this, 10, 10);
    }

    public void addToList() {
        File dir;
        String text = this.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        String label = FindTool.getFindText();
        if (label == null || label.length() == 0) {
            return;
        }
        if (this.entriesDataBase == null) {
            this.entriesDataBase = new EntriesDataBase();
        }
        if (this.entriesDataBase.contains(label, text, dir = this.owner.getRootDirectory()) == null) {
            if (this.entriesDataBase.size() >= 16) {
                for (int n = 16; n < this.entriesDataBase.size(); ++n) {
                    this.entriesDataBase.removeItemAt(n);
                }
            }
            this.entriesDataBase.addAt(label, text, 0);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public class EntriesPopup
    extends JPopupMenu
    implements PopupMenuListener {
        public EntriesPopup() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            super.removeAll();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            AbstractAction action;
            JMenuItem item;
            KFileTextArea.this.addToList();
            for (int n = 0; n < KFileTextArea.this.entriesDataBase.size(); ++n) {
                String label = KFileTextArea.this.entriesDataBase.labelAt(n);
                String text = KFileTextArea.this.entriesDataBase.textAt(n);
                File dir = KFileTextArea.this.entriesDataBase.rootDirAt(n);
                if (label == null || label.trim().length() == 0 || text == null || text.trim().length() == 0 || dir == null) continue;
                final EntryMenuItem item2 = new EntryMenuItem(label, text, dir);
                item2.setToolTipText(dir.getPath());
                this.add(item2);
                AbstractAction action2 = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String oldText = KFileTextArea.this.getText();
                        KFileTextArea.this.setText(item2.getResultStr());
                        KFileTextArea.this.owner.setRootDirectory(item2.getRootDir());
                        if (!oldText.equals(item2.getResultStr())) {
                            for (int i = 0; i < KFileTextArea.this.STFListeners.size(); ++i) {
                                STFListener l = (STFListener)KFileTextArea.this.STFListeners.elementAt(i);
                                l.textChanged();
                            }
                        }
                    }
                };
                item2.addActionListener(action2);
            }
            this.addSeparator();
            if (KFileTextArea.this.shiftIsDown) {
                item = new JMenuItem("Remove All Entries");
                action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KFileTextArea.this.entriesDataBase.removeAll();
                        KFileTextArea.this.setText("");
                    }
                };
            } else {
                item = new JMenuItem("Remove Entry");
                action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String label = FindTool.getFindText();
                        String text = KFileTextArea.this.getText();
                        if (label == null || label.trim().length() == 0 || text == null || text.trim().length() == 0) {
                            return;
                        }
                        KFileTextArea.this.entriesDataBase.remove(label, text);
                        KFileTextArea.this.setText("");
                    }
                };
            }
            this.add(item);
            item.addActionListener(action);
            this.addSeparator();
            JMenuItem clipitem = new JMenuItem("Copy Entries to Clipboard");
            AbstractAction clipaction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuffer b = new StringBuffer();
                    for (int n = 0; n < KFileTextArea.this.entriesDataBase.size(); ++n) {
                        String l = KFileTextArea.this.entriesDataBase.labelAt(n);
                        String t = KFileTextArea.this.entriesDataBase.textAt(n);
                        File f = KFileTextArea.this.entriesDataBase.rootDirAt(n);
                        b.append("Search string: \"" + l + "\"\n");
                        b.append("Search directory: " + f.getPath() + "\n");
                        b.append("Results:\n");
                        b.append(t + "----------------------------\n");
                    }
                    BBxt.copyToClipboard(b.toString(), KFileTextArea.this);
                }
            };
            this.add(clipitem);
            clipitem.addActionListener(clipaction);
            if (KFileTextArea.this.entriesDataBase.list.size() == 0) {
                item.setEnabled(false);
                clipitem.setEnabled(false);
            }
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }

        private class EntryMenuItem
        extends JMenuItem {
            String label = "";
            String text = "";
            File rootdir = null;

            public EntryMenuItem(String label, String text, File dir) {
                this.label = label;
                this.text = text;
                this.rootdir = dir;
                this.setText(label);
            }

            @Override
            public String getText() {
                if (this.text == null || this.text.trim().equals("No matches found.")) {
                    return "\"" + this.label + "\" - no matches";
                }
                String[] lines = TextUtils.tokenize(this.text.trim());
                String postscript = "";
                if (lines != null) {
                    postscript = " - " + lines.length + " matches";
                }
                return "\"" + this.label + "\"" + postscript;
            }

            public String getResultStr() {
                return this.text;
            }

            public File getRootDir() {
                return this.rootdir;
            }
        }
    }

    private class Karet
    extends DefaultCaret {
        private KTextArea textArea;

        public Karet(KTextArea ta) {
            this.textArea = ta;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.getClickCount() == 2) {
                this.selectWord(this.getMark());
            }
        }

        private void selectWord(int offset) {
            try {
                int line = this.textArea.getLineOfOffset(offset);
                int begin = this.textArea.getLineStartOffset(line);
                int end = this.textArea.getLineEndOffset(line);
                this.textArea.setSelectionStart(begin);
                this.textArea.setSelectionEnd(end);
                String str = this.textArea.getSelectedText();
                if (str == null) {
                    Cutter.setLog("    Info:KFileTextArea.selectWord() no text to select");
                    return;
                }
                if (str.endsWith("\n")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.trim().startsWith("=")) {
                    this.textArea.setSelectionStart(offset);
                    this.textArea.setSelectionEnd(offset);
                    return;
                }
                Cutter.setLog("    Debug: BatchFindPanel.Karet.selectWord() >" + str + "<");
                this.openDoc(str);
            }
            catch (BadLocationException e) {
                Cutter.setLog("HTMLSearchTool.Karet" + e.toString());
            }
        }

        private void openDoc(String path) {
            if (path == null) {
                return;
            }
            File root = KFileTextArea.this.owner.getRootDirectory();
            File file = new File(root, path);
            if (KAbstractDesktop.windowExists(file)) {
                KAbstractWindow window = KAbstractDesktop.getWindowWithFile(file);
                if (window == null) {
                    return;
                }
                KAbstractDesktop.toFront(window);
            } else {
                BBxt.newDocument(file);
            }
        }
    }

    private class EntriesDataBase {
        Vector<EntryData> list = new Vector();

        public void add(String label, String text) {
            File root = KFileTextArea.this.owner.getRootDirectory();
            if (this.contains(label, text, root) == null) {
                this.list.addElement(new EntryData(label, text, root));
            }
        }

        public void addAt(String label, String text, int index) {
            if (label.trim().length() == 0 || text.trim().length() == 0) {
                return;
            }
            File root = KFileTextArea.this.owner.getRootDirectory();
            this.list.insertElementAt(new EntryData(label, text, root), index);
        }

        public int size() {
            return this.list.size();
        }

        public String labelAt(int index) {
            return index >= this.list.size() ? "" : this.list.elementAt((int)index).label;
        }

        public String textAt(int index) {
            return index >= this.list.size() ? "" : this.list.elementAt((int)index).text;
        }

        public EntryData itemAt(int index) {
            return index >= this.list.size() ? null : this.list.elementAt(index);
        }

        public File rootDirAt(int index) {
            return index >= this.list.size() ? null : this.list.elementAt((int)index).rootdir;
        }

        public EntryData contains(String label, String text, File dir) {
            for (int n = 0; n < this.list.size(); ++n) {
                EntryData item = this.itemAt(n);
                if (!item.label.equals(label) || !item.rootdir.getPath().equals(dir.getPath())) continue;
                return item;
            }
            return null;
        }

        public void remove(String label, String text) {
            EntryData item = this.contains(label, text, KFileTextArea.this.owner.getRootDirectory());
            if (item != null) {
                this.list.removeElement(item);
            }
        }

        public void removeItemAt(int index) {
            this.list.removeElementAt(index);
        }

        public void removeAll() {
            this.list.removeAllElements();
        }
    }

    private class EntryData {
        public String label = "";
        public String text = "";
        File rootdir = null;

        public EntryData(String label, String text, File dir) {
            this.label = label;
            this.text = text;
            this.rootdir = dir;
        }
    }

    public static interface STFListener {
        public void textChanged();
    }
}

