/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolTip;

public class KMenu
extends JMenu {
    private MultiLineToolTip tip = null;

    public KMenu(String title) {
        super(title);
    }

    public KMenu() {
    }

    @Override
    public void setToolTipText(String tipText) {
        super.setToolTipText(tipText);
        tipText = TextUtils.format(tipText, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
        this.tip = new MultiLineToolTip(tipText);
    }

    @Override
    public JToolTip createToolTip() {
        return this.tip;
    }

    public JMenuItem getMenuItemWithName(String name) {
        int count = this.getMenuComponentCount();
        for (int n = 0; n < count; ++n) {
            Component comp = this.getMenuComponent(n);
            if (!(comp instanceof JMenuItem) || !((JMenuItem)comp).getText().equalsIgnoreCase(name)) continue;
            return (JMenuItem)comp;
        }
        return null;
    }

    public Point getOrigin() {
        Point point;
        Rectangle rect;
        Container comp;
        if (!this.isVisible() && (comp = this.getParent()) instanceof JMenuItem) {
            ((JMenuItem)comp).doClick();
        }
        try {
            rect = this.getBounds();
            JPopupMenu jpm = this.getPopupMenu();
            if (!jpm.isVisible()) {
                this.doClick();
            }
            point = this.getPopupMenuOrigin();
        }
        catch (Exception e) {
            Cutter.setLog("KMenu.getOrigin()\n\t" + e.toString());
            Cutter.setLog(this.getText() + "  isVisible = " + this.isVisible());
            JPopupMenu jpm = this.getPopupMenu();
            Cutter.setLog("jpm  isVisible = " + jpm.isVisible());
            return null;
        }
        return new Point(rect.x + point.x, rect.y + point.y);
    }

    public String[] getAllMenuItemNames() {
        int count = this.getMenuComponentCount();
        if (count <= 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < count; ++n) {
            String name;
            Component comp = this.getMenuComponent(n);
            if (comp == null || !(comp instanceof JMenuItem) || comp instanceof JSeparator || (name = ((JMenuItem)comp).getText()) == null) continue;
            v.addElement(name);
        }
        return VectorUtils.toStringArray(v);
    }

    public void reload() {
        Cutter.setLog("KMenu.reload()");
    }
}

