/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import Utilities.NumberUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private KMenuBarPopup popup = new KMenuBarPopup();
    private int defaultFontSize = 12;
    private int currentFontSize = 12;

    public KMenuBar() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KMenuBar.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KMenuBar.this.handlePopupTrigger(e);
                }
            }
        });
        int count = this.getMenuCount();
        for (int n = 0; n < this.getMenuCount(); ++n) {
            JMenu menu = this.getMenu(n);
            if (menu == null) continue;
            Font f = menu.getFont();
            this.defaultFontSize = f.getSize();
        }
        this.currentFontSize = this.defaultFontSize;
    }

    private void handlePopupTrigger(MouseEvent e) {
        this.popup.setRequestFocusEnabled(false);
        if (this.popup != null) {
            try {
                this.popup.show(this, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractHelp.popupOnlineHelp()\n        " + ex.toString());
            }
        }
    }

    public void initFontSize() {
        String str = Preferences.get(Preferences.UI_MENUBAR_SIZE);
        int prefSize = this.defaultFontSize;
        try {
            prefSize = NumberUtils.strToInt(str);
        }
        catch (NumberFormatException e) {
            prefSize = this.defaultFontSize;
        }
        if (prefSize < this.defaultFontSize) {
            return;
        }
        for (int n = 0; n < this.getMenuCount(); ++n) {
            JMenu menu = this.getMenu(n);
            if (menu == null) continue;
            Font f = menu.getFont();
            f = new Font(f.getName(), f.getStyle(), prefSize);
            menu.setFont(f);
        }
        this.currentFontSize = prefSize;
    }

    private void incrFontSize(int incr) {
        int old = this.currentFontSize;
        for (int n = 0; n < this.getMenuCount(); ++n) {
            JMenu menu = this.getMenu(n);
            if (menu == null) continue;
            Font f = menu.getFont();
            this.currentFontSize = f.getSize() + incr;
            f = new Font(f.getName(), f.getStyle(), this.currentFontSize);
            menu.setFont(f);
        }
        Preferences.write(Preferences.UI_MENUBAR_SIZE, this.currentFontSize);
    }

    private void restoreFontSize() {
        int count = this.getMenuCount();
        for (int n = 0; n < this.getMenuCount(); ++n) {
            JMenu menu = this.getMenu(n);
            if (menu == null) continue;
            Font f = menu.getFont();
            f = new Font(f.getName(), f.getStyle(), this.defaultFontSize);
            menu.setFont(f);
        }
        this.currentFontSize = this.defaultFontSize;
        Preferences.write(Preferences.UI_MENUBAR_SIZE, this.currentFontSize);
    }

    private class KMenuBarPopup
    extends JPopupMenu
    implements PopupMenuListener {
        private static final long serialVersionUID = 1L;
        private JMenuItem increaseFontItem = new JMenuItem("Increase Font Size");
        private JMenuItem decreaseFontItem = new JMenuItem("Decrease Font Size");
        private JMenuItem restoreFontItem = new JMenuItem("Restore Default Size");

        public KMenuBarPopup() {
            this.addPopupMenuListener(this);
            this.increaseFontItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KMenuBar.this.incrFontSize(1);
                }
            });
            this.decreaseFontItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KMenuBar.this.incrFontSize(-1);
                }
            });
            this.restoreFontItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KMenuBar.this.restoreFontSize();
                }
            });
            this.add(this.increaseFontItem);
            this.add(this.decreaseFontItem);
            this.add(this.restoreFontItem);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.increaseFontItem.setEnabled(true);
            this.decreaseFontItem.setEnabled(true);
            this.restoreFontItem.setEnabled(true);
            if (KMenuBar.this.currentFontSize == KMenuBar.this.defaultFontSize) {
                this.decreaseFontItem.setEnabled(false);
                this.restoreFontItem.setEnabled(false);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            try {
                super.show(invoker, x + 5, y);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KMenuBar.KMenuBarPopup.show() \n          " + ex.toString());
            }
            MenuElement[] element = this.getSubElements();
            if (element == null) {
                return;
            }
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }
    }
}

