/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import java.awt.Insets;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class KProgressPanel
extends KTitledPanel {
    private static final long serialVersionUID = 1L;
    protected JProgressBar bar = new JProgressBar();
    private int max = 0;

    public KProgressPanel(String title) {
        super(title);
        this.add(this.bar, new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 1, 17, 1, new Insets(3, 10, 10, 10)));
    }

    public void initBar(final int max) {
        this.max = max;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KProgressPanel.this.bar.setMinimum(0);
                    KProgressPanel.this.bar.setMaximum(max);
                }
            });
        }
        catch (Exception ex) {
            Cutter.setLog("KProgressPanel.updateProgress() exception" + ex.toString());
        }
    }

    public void setMin() {
        this.bar.setMinimum(0);
    }

    public void setMax() {
        this.bar.setMaximum(this.max);
    }

    public int getValue() {
        return this.bar.getValue();
    }

    public void updateBar(final int val) {
        if (val % 2 != 0) {
            return;
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KProgressPanel.this.bar.setValue(val);
                }
            });
        }
        catch (Exception ex) {
            Cutter.setLog("KProgressPanel.updateProgress() exception" + ex.toString());
            return;
        }
    }
}

