/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTabbedPane;

import UI_Components.KTabbedPane.KTabbedPane;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KTabGroup
implements ChangeListener {
    private Vector<TabPane> listOfTabPanes = new Vector();
    private JInternalFrame frame;
    private KTabbedPane parent;
    private boolean simpleResizing = true;
    int nestedDepth = 0;

    public KTabGroup(JInternalFrame frame, KTabbedPane parent) {
        this.frame = frame;
        this.parent = parent;
        this.listenTo(parent);
    }

    private void listenTo(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof JPanel) {
            KTabbedPane tab = (KTabbedPane)((JPanel)comp).getParent();
            TabPane tabpane = new TabPane(tab, (JPanel)comp);
            this.listOfTabPanes.addElement(tabpane);
            return;
        }
        if (comp instanceof KTabbedPane) {
            ++this.nestedDepth;
            if (this.nestedDepth >= 2) {
                this.simpleResizing = false;
            }
            ((KTabbedPane)comp).addChangeListener(this);
            for (int i = 0; i < ((KTabbedPane)comp).getTabCount(); ++i) {
                Component c = ((KTabbedPane)comp).getComponentAt(i);
                this.listenTo(c);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        KTabbedPane tab = (KTabbedPane)e.getSource();
        if (tab == null) {
            return;
        }
        int index = tab.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (tab.getComponentAt(index) instanceof KTabbedPane) {
            tab = (KTabbedPane)tab.getComponentAt(tab.getSelectedIndex());
        }
        this.adjustUI(tab);
    }

    public void adjustUI(KTabbedPane parent) {
        TabPane tabpane;
        int n;
        int selectedIndex = parent.getSelectedIndex();
        for (n = 0; n < this.listOfTabPanes.size(); ++n) {
            tabpane = this.listOfTabPanes.elementAt(n);
            tabpane.parentKTabbedPane.saveDefaultFocusField();
            JPanel proxy = new JPanel();
            proxy.setName("proxy");
            tabpane.parentKTabbedPane.setComponentAt(tabpane.index, proxy);
        }
        for (n = 0; n < this.listOfTabPanes.size(); ++n) {
            tabpane = this.listOfTabPanes.elementAt(n);
            if (tabpane.parentKTabbedPane != parent) continue;
            if (this.simpleResizing) {
                if (tabpane.index != selectedIndex) continue;
                tabpane.parentKTabbedPane.setComponentAt(tabpane.index, tabpane.panel);
                continue;
            }
            tabpane.parentKTabbedPane.setComponentAt(tabpane.index, tabpane.panel);
        }
        parent.validate();
        this.frame.pack();
    }

    public class TabPane {
        public KTabbedPane parentKTabbedPane;
        public JPanel panel;
        public int index;

        public TabPane(KTabbedPane parentKTabbedPane, JPanel panel) {
            this.parentKTabbedPane = parentKTabbedPane;
            this.panel = panel;
            this.index = parentKTabbedPane.indexOfComponent(panel);
        }
    }
}

