/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTabbedPane;

import UI_Components.KTabbedPane.KTabPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import Utilities.ComponentUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class KTabbedPane
extends JTabbedPane {
    private Vector<Component> listOfTabs = new Vector();

    public KTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KTabbedPane.this.listOfTabs.removeAllElements();
                KTabbedPane.this.getTabs(KTabbedPane.this);
                for (int n = 0; n < KTabbedPane.this.listOfTabs.size(); ++n) {
                    Component c = (Component)KTabbedPane.this.listOfTabs.elementAt(n);
                    if (!(c instanceof PrefsPanel) || !c.isVisible()) continue;
                    ((PrefsPanel)c).focusDefaultField();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PrefsPanel pp = KTabbedPane.this.getVisiblePrefsPanel();
                if (pp != null) {
                    JTextComponent jt = pp.getDefaultFocusField();
                    if (jt != null && !jt.isFocusOwner()) {
                        pp.focusDefaultField();
                    }
                } else {
                    ComponentUtils utils = new ComponentUtils(KTabbedPane.this, "UI_Components.KTabbedPane.KTabPanel");
                    Component[] panels = utils.getAll();
                    if (panels != null && panels.length > 0 && panels[0] instanceof KTabPanel) {
                        ((KTabPanel)panels[0]).focusDefaultField();
                    }
                }
            }
        });
    }

    public void saveDefaultFocusField() {
        this.listOfTabs.removeAllElements();
        this.getTabs(this);
        for (int n = 0; n < this.listOfTabs.size(); ++n) {
            Component c = this.listOfTabs.elementAt(n);
            if (!(c instanceof PrefsPanel) || !c.isVisible()) continue;
            ((PrefsPanel)c).saveDefaultFocusField();
        }
    }

    public PrefsPanel getVisiblePrefsPanel() {
        this.listOfTabs.removeAllElements();
        this.getTabs(this);
        for (int n = 0; n < this.listOfTabs.size(); ++n) {
            Component c = this.listOfTabs.elementAt(n);
            if (!(c instanceof PrefsPanel) || !c.isVisible()) continue;
            return (PrefsPanel)c;
        }
        return null;
    }

    private void getTabs(JTabbedPane tp) {
        for (int n = 0; n < tp.getTabCount(); ++n) {
            Component c = tp.getComponentAt(n);
            if (c instanceof JTabbedPane) {
                this.getTabs((JTabbedPane)c);
                continue;
            }
            this.listOfTabs.addElement(c);
        }
    }

    public boolean bringToFront(JTabbedPane tp, JPanel target) {
        for (int n = 0; n < tp.getTabCount(); ++n) {
            Component c = tp.getComponentAt(n);
            if (c instanceof JTabbedPane) {
                this.bringToFront((JTabbedPane)c, target);
                continue;
            }
            if (!(c instanceof JPanel) || c != target) continue;
            this.setSelectedComponent(c);
            return true;
        }
        return false;
    }
}

