/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Tools.KTools;
import Utilities.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.Keymap;

public class KTextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private static Action copyAction = null;
    private static Action cutAction = null;
    private static Action pasteAction = null;
    private static Action selectAllAction = null;

    public KTextArea() {
        this.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        this.initKeyMaps();
    }

    public KTextArea(int rows, int columns) {
        super(rows, columns);
        this.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        this.initKeyMaps();
    }

    public KTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        this.initKeyMaps();
    }

    private void initKeyMaps() {
        Keymap keymap = this.getKeymap();
        if (copyAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 512), copyAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 256), copyAction);
        }
        if (cutAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 512), cutAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 256), cutAction);
        }
        if (pasteAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 512), pasteAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 256), pasteAction);
        }
        if (selectAllAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 512), selectAllAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 256), selectAllAction);
        }
        this.setKeymap(keymap);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Component comp;
        if (e.getID() == 1005 && (comp = ComponentUtils.getParentOfClass(this, "Tools")) != null) {
            ((KTools)comp).childHasLostFocus(this);
        }
        super.processFocusEvent(e);
    }

    static {
        Action[] action = new JTextArea().getActions();
        for (int n = 0; n < action.length; ++n) {
            if (action[n].getValue("Name").equals("copy-to-clipboard")) {
                copyAction = action[n];
                continue;
            }
            if (action[n].getValue("Name").equals("cut-to-clipboard")) {
                cutAction = action[n];
                continue;
            }
            if (action[n].getValue("Name").equals("paste-from-clipboard")) {
                pasteAction = action[n];
                continue;
            }
            if (!action[n].getValue("Name").equals("select-all")) continue;
            selectAllAction = action[n];
        }
    }
}

