/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTextField;

import UI_Components.KTextField.KTextField;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class KEscapeEncodedField
extends KTextField {
    private static final long serialVersionUID = 1L;
    public static Color VERIFICATION_FAILURE_COLOR = Color.orange;

    public KEscapeEncodedField(String text, int width) {
        super(width);
        this.addSingleClick();
    }

    public KEscapeEncodedField(int width) {
        super(width);
        this.addSingleClick();
    }

    public KEscapeEncodedField() {
        this.addSingleClick();
    }

    public KEscapeEncodedField(String text) {
        this.addSingleClick();
    }

    private void addSingleClick() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && KEscapeEncodedField.this.getBackground().equals(VERIFICATION_FAILURE_COLOR)) {
                    KEscapeEncodedField.this.setBackground(Color.white);
                }
            }
        });
    }

    @Override
    protected Document createDefaultModel() {
        return new UpperCaseDocument();
    }

    @Override
    public void setTextFromLineEditor(String text) {
        this.setText(KEscapeEncodedField.decode(text));
    }

    @Override
    public boolean verify(String encodedStr) {
        char nextChar = '\u0000';
        boolean isVerifield = true;
        for (int n = 0; n < encodedStr.length(); ++n) {
            nextChar = n + 1 < encodedStr.length() ? encodedStr.charAt(n + 1) : (char)'\u0000';
            char currChar = encodedStr.charAt(n);
            if (currChar != '\\') continue;
            if (nextChar == '\\') {
                ++n;
                continue;
            }
            if (nextChar == 'n') {
                ++n;
                continue;
            }
            if (nextChar == 't') {
                ++n;
                continue;
            }
            isVerifield = false;
        }
        return isVerifield;
    }

    public static String decode(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        char nextChar = '\u0000';
        for (int n = 0; n < str.length(); ++n) {
            nextChar = n + 1 < str.length() ? str.charAt(n + 1) : (char)'\u0000';
            char currChar = str.charAt(n);
            if (currChar == '\\') {
                if (nextChar == '\\') {
                    out.append('\\');
                    ++n;
                    continue;
                }
                if (nextChar == 'n') {
                    out.append("\n");
                    ++n;
                    continue;
                }
                if (nextChar == 't') {
                    out.append("\t");
                    ++n;
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                continue;
            }
            out.append(currChar);
        }
        return out.toString();
    }

    public static String encode(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        char nextChar = '\u0000';
        block4: for (int n = 0; n < str.length(); ++n) {
            nextChar = n + 1 < str.length() ? str.charAt(n + 1) : (char)'\u0000';
            char currChar = str.charAt(n);
            switch (currChar) {
                case '\n': {
                    out.append('\\').append('n');
                    continue block4;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block4;
                }
                default: {
                    if (currChar == '\\' && n == str.length() - 1) {
                        out.append('\\');
                        continue block4;
                    }
                    if (currChar == '\\' && nextChar != '\\') {
                        out.append('\\').append('\\');
                        Toolkit.getDefaultToolkit().beep();
                        continue block4;
                    }
                    out.append(currChar);
                }
            }
        }
        return out.toString();
    }

    static class UpperCaseDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        UpperCaseDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            super.insertString(offs, KEscapeEncodedField.encode(str), a);
        }
    }
}

