/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTextField;

import UI_Desktop.Cutter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class KFloatTextField
extends JTextField {
    private static final long serialVersionUID = 1L;

    public KFloatTextField(int col) {
        super(col);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KFloatTextField.this.selectAll();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KFloatTextField.this.selectAll();
                }
            }
        });
    }

    public KFloatTextField(String str, int col) {
        super(str, col);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KFloatTextField.this.selectAll();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KFloatTextField.this.selectAll();
                }
            }
        });
    }

    public Float getFloat() {
        try {
            float value = Float.parseFloat(this.getText());
            return Float.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    static class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String currText = this.getText(0, this.getLength());
            super.insertString(offs, str, a);
            if (currText.length() == 0 && (str.trim().equals(".") || str.trim().equals("-"))) {
                return;
            }
            if (currText.length() == 1 && currText.equals("-") && str.trim().equals(".")) {
                return;
            }
            String newText = this.getText(0, this.getLength());
            try {
                Float.parseFloat(newText);
            }
            catch (Exception e) {
                try {
                    super.replace(0, this.getLength(), currText, a);
                }
                catch (BadLocationException ex) {
                    Cutter.setLog("    Exception:KFloatTextField.insertString()");
                    Cutter.setLog("      before insertion text was >" + currText + "<");
                    Cutter.setLog("      text inserted was >" + str + "<");
                    Cutter.setLog("      " + ex.toString() + "\n");
                }
                return;
            }
        }
    }
}

