/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTextField;

import UI_BBXT.BBxt;
import UI_Components.KTextField.KTextField;
import UI_Components.KTextField.STFListener;
import Utilities.CerealUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class KSerialTextField
extends KTextField {
    private static final long serialVersionUID = 1L;
    public final int MAX_ENTRIES = 16;
    public final int MAX_CHARS_IN_ENTRY = 35;
    public String serialName = null;
    private Vector<String> listOfEntries = new Vector();
    private Vector<STFListener> STFListeners = new Vector();
    protected EntriesPopup popup = new EntriesPopup();
    private boolean shiftIsDown = false;
    private int caretOffset = 0;

    public KSerialTextField(String serialName, String text, int width) {
        super(text, width);
        this.serialName = serialName;
        super.setText("");
        this.initGUI("");
    }

    public KSerialTextField(String serialName) {
        this.serialName = serialName;
        super.setText("");
        this.initGUI("");
    }

    private void initGUI(String text) {
        Object obj = CerealUtils.readFromFile(this.serialName);
        if (obj != null && obj instanceof Vector) {
            this.listOfEntries = (Vector)obj;
        } else if (text != null && text.length() > 0) {
            this.listOfEntries.addElement(text);
        }
        Vector<String> temp = new Vector<String>();
        for (int n = 0; n < this.listOfEntries.size(); ++n) {
            String entry = this.listOfEntries.elementAt(n);
            if (entry.equals("\u0010")) {
                temp.addElement("");
                continue;
            }
            if (entry.length() == 0 || temp.contains(entry)) continue;
            temp.addElement(this.listOfEntries.elementAt(n));
        }
        this.listOfEntries = temp;
        if (this.listOfEntries.size() > 0) {
            this.setText(this.listOfEntries.elementAt(0));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KSerialTextField.this.handlePopupTrigger(e);
                }
                super.mouseReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.isAltDown() || e.isMetaDown()) {
                    KSerialTextField.this.handlePopupTrigger(e);
                }
                super.mousePressed(e);
            }
        });
    }

    private void handlePopupTrigger(MouseEvent e) {
        this.shiftIsDown = e.isShiftDown();
        this.caretOffset = this.getSelectionStart();
        this.popup.show(this, 10, 10);
    }

    public void addSTFListener(STFListener l) {
        this.STFListeners.addElement(l);
    }

    @Override
    protected Document createDefaultModel() {
        return new EscapeEncodedDocument();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005) {
            this.caretOffset = this.getSelectionStart();
            this.addToList();
        }
        super.processFocusEvent(e);
    }

    @Override
    public void setText(String str) {
        super.setText(str);
        this.addToList();
    }

    private void addToList() {
        String text = this.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.listOfEntries == null) {
            this.listOfEntries = new Vector();
        }
        if (!this.listOfEntries.contains(text)) {
            if (this.listOfEntries.size() >= 16) {
                for (int n = 16; n < this.listOfEntries.size(); ++n) {
                    this.listOfEntries.removeElementAt(n);
                }
            }
            this.listOfEntries.insertElementAt(text, 0);
        }
    }

    private void removeFromList(String text) {
        this.listOfEntries.removeElement(text);
    }

    private void removeAllFromList() {
        this.listOfEntries.removeAllElements();
    }

    public void saveSelf() {
        if (this.getText().trim().length() == 0) {
            this.listOfEntries.insertElementAt("\u0010", 0);
        } else {
            this.removeFromList(this.getText());
            this.addToList();
        }
        CerealUtils.writeToFile(this.listOfEntries, this.serialName);
    }

    public class EntriesPopup
    extends JPopupMenu
    implements PopupMenuListener {
        public EntriesPopup() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            super.removeAll();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            AbstractAction action;
            JMenuItem item;
            KSerialTextField.this.addToList();
            for (int n = 0; n < KSerialTextField.this.listOfEntries.size(); ++n) {
                String entry = (String)KSerialTextField.this.listOfEntries.elementAt(n);
                if (entry == null || entry.length() == 0) continue;
                final EntryMenuItem item2 = new EntryMenuItem(entry);
                this.add(item2);
                AbstractAction action2 = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String oldText = KSerialTextField.this.getText();
                        KSerialTextField.this.setText(item2.getText());
                        if (!oldText.equals(item2.getText())) {
                            for (int i = 0; i < KSerialTextField.this.STFListeners.size(); ++i) {
                                STFListener l = (STFListener)KSerialTextField.this.STFListeners.elementAt(i);
                                l.textChanged();
                            }
                        }
                    }
                };
                item2.addActionListener(action2);
            }
            this.addSeparator();
            if (KSerialTextField.this.shiftIsDown) {
                item = new JMenuItem("Remove All Entries");
                action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KSerialTextField.this.removeAllFromList();
                        KSerialTextField.this.setText("");
                    }
                };
            } else {
                item = new JMenuItem("Remove Entry");
                action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KSerialTextField.this.removeFromList(KSerialTextField.this.getText());
                        KSerialTextField.this.setText("");
                    }
                };
            }
            this.add(item);
            item.addActionListener(action);
            this.addSeparator();
            JMenuItem clipitem = new JMenuItem("Copy Entries to Clipboard");
            AbstractAction clipaction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuffer b = new StringBuffer();
                    for (int n = 0; n < KSerialTextField.this.listOfEntries.size(); ++n) {
                        b.append((String)KSerialTextField.this.listOfEntries.elementAt(n)).append("\n");
                    }
                    BBxt.copyToClipboard(b.toString(), KSerialTextField.this);
                }
            };
            this.add(clipitem);
            clipitem.addActionListener(clipaction);
            if (KSerialTextField.this.listOfEntries.size() == 0) {
                item.setEnabled(false);
                clipitem.setEnabled(false);
            }
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }

        private class EntryMenuItem
        extends JMenuItem {
            String shortStr;
            String longStr;

            public EntryMenuItem(String str) {
                this.longStr = str;
                this.shortStr = str;
                this.setText(this.longStr);
            }

            @Override
            public String getText() {
                return this.longStr;
            }
        }
    }

    private class EscapeEncodedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private EscapeEncodedDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = TextUtils.replace(str, '\n', "\\n");
            str = TextUtils.replace(str, '\t', "\\t");
            super.insertString(offs, str, a);
        }
    }
}

