/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.KTextField;

import Preferences.Preferences;
import Preferences.PreferencesReadWriter;
import UI_Components.KTextField.NewlineListener;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import UI_Window.KWindow.KLineEditorWindow;
import Utilities.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.text.Keymap;

public class KTextField
extends JTextField
implements PreferencesReadWriter,
MouseListener,
Serializable,
ClipboardOwner {
    public static final String KEY_PRESSED = "pressed";
    public static final String KEY_RELEASED = "released";
    public static final String KEY_TYPED = "typed";
    private static Action copyAction = null;
    private static Action cutAction = null;
    private static Action pasteAction = null;
    private static Action selectAllAction = null;
    public boolean usesModelDialog = false;
    public String modelDialogPanelText = null;
    private String defaultText = "";
    private int prefID = -1;
    private boolean desktopDeactivation = true;
    public KLineEditorWindow popupLineEditor = null;
    private Vector<NewlineListener> listOfNewlineListeners = new Vector();
    private DefaultMetalTheme metal = new DefaultMetalTheme();
    private Color lite = this.metal.getPrimaryControl();
    private Color dark = this.metal.getPrimaryControlDarkShadow();
    private Color gray = this.metal.getMenuBackground();

    public KTextField(String text, int width) {
        super(width);
        this.commonInit(text);
    }

    public KTextField(int width) {
        super(width);
        this.commonInit(null);
    }

    public KTextField() {
        this.commonInit(null);
    }

    public KTextField(String text) {
        this.commonInit(text);
    }

    private void commonInit(String text) {
        this.modelDialogPanelText = text;
        this.setText(text);
        Keymap keymap = this.getKeymap();
        if (copyAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 512), copyAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 256), copyAction);
        }
        if (cutAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 512), cutAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 256), cutAction);
        }
        if (pasteAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 512), pasteAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 256), pasteAction);
        }
        if (selectAllAction != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 512), selectAllAction);
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 256), selectAllAction);
        }
        this.setKeymap(keymap);
        this.setEditable(true);
        this.addMouseListener(this);
        this.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
    }

    public void lineEditorDeactivatesDesktop(boolean flag) {
        this.desktopDeactivation = flag;
    }

    public void setUsesModelDialog(boolean f) {
        this.usesModelDialog = f;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        String text = this.getText();
        if (this.usesModelDialog && e.getClickCount() == 2 && text != null) {
            this.selectAll();
            if (this.getText().length() == 0 || KLineEditorWindow.isInUse) {
                return;
            }
            this.popupLineEditor = new KLineEditorWindow(this, this.desktopDeactivation);
        }
    }

    @Override
    public String getText() {
        if (this.popupLineEditor != null && this.popupLineEditor.isVisible()) {
            return this.popupLineEditor.textfield.getText();
        }
        return super.getText();
    }

    public boolean verify(String str) {
        return true;
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.setActionCommand(KEY_PRESSED);
        } else if (e.getID() == 402) {
            this.setActionCommand(KEY_RELEASED);
        } else if (e.getID() == 400) {
            this.setActionCommand(KEY_TYPED);
        }
        if (e.getID() == 401 && e.getKeyCode() == 10) {
            this.notifyNewlineListeners();
        }
        this.fireActionPerformed();
        super.processComponentKeyEvent(e);
    }

    private void notifyNewlineListeners() {
        for (int n = 0; n < this.listOfNewlineListeners.size(); ++n) {
            NewlineListener l = this.listOfNewlineListeners.elementAt(n);
            l.newlineHappened();
        }
    }

    public void addNewlineListener(NewlineListener l) {
        this.listOfNewlineListeners.addElement(l);
    }

    public void removeNewlineListener(NewlineListener l) {
        this.listOfNewlineListeners.removeElement(l);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBackground(this.isEnabled() ? Color.white : Color.lightGray);
    }

    public void setBold(boolean flag) {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), flag ? 1 : 0, f.getSize()));
    }

    public void setText(int prefID, String defaultText) {
        this.defaultText = defaultText;
        this.prefID = prefID;
        this.readFromPrefs();
    }

    @Override
    public void setText(String text) {
        this.defaultText = text;
        super.setText(text);
    }

    public void setTextFromLineEditor(String text) {
        this.setText(text);
        this.fireActionPerformed();
    }

    public void setGrayMetalBackground() {
        this.setBackground(this.gray);
    }

    public void setDarkControlForeground() {
        this.setBackground(this.dark);
    }

    @Override
    public void writeToPrefs() {
        if (this.prefID > 0) {
            Preferences.write(this.prefID, this.getText());
        }
    }

    @Override
    public void readFromPrefs() {
        if (this.prefID <= 0) {
            this.setText(this.defaultText);
            return;
        }
        String str = Preferences.get(this.prefID);
        if (str.trim().length() > 0) {
            this.setText(str);
        } else {
            this.setText(this.defaultText);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        try {
            super.processFocusEvent(e);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:KTextField.processFocusEvent()\n" + ex.toString());
            return;
        }
        if (e.getID() == 1005) {
            int len = this.getText().length();
            super.setSelectionStart(len);
            super.setSelectionEnd(len);
            Component comp = ComponentUtils.getParentOfClass(this, "KTools");
            if (comp != null) {
                ((KTools)comp).childHasLostFocus(this);
            }
        }
    }

    static {
        Action[] action = new JTextField().getActions();
        for (int n = 0; n < action.length; ++n) {
            if (action[n].getValue("Name").equals("copy-to-clipboard")) {
                copyAction = action[n];
                continue;
            }
            if (action[n].getValue("Name").equals("cut-to-clipboard")) {
                cutAction = action[n];
                continue;
            }
            if (action[n].getValue("Name").equals("paste-from-clipboard")) {
                pasteAction = action[n];
                continue;
            }
            if (!action[n].getValue("Name").equals("select-all")) continue;
            selectAllAction = action[n];
        }
    }
}

