/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Desktop.Cutter;
import Utilities.GraphicsFileUtils;
import Utilities.JPEGUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class KTile
extends JComponent {
    private BufferedImage bi = null;
    private Color fillColor = Color.blue;
    private String text = null;
    private static int counter = 1;
    private File srcFile = null;

    public KTile(File src) throws Exception {
        this.bi = GraphicsFileUtils.readImageFile(src);
        if (this.bi == null) {
            Cutter.setLog("KTile exception ");
            throw new Exception();
        }
        this.srcFile = src;
    }

    public String overlay(File over, int xoffset, int yoffset) {
        BufferedImage over_bi = GraphicsFileUtils.readImageFile(over);
        if (over_bi == null) {
            return this.srcFile.getName();
        }
        for (int x = 0; x < over_bi.getWidth(); ++x) {
            for (int y = 0; y < over_bi.getHeight(); ++y) {
                this.bi.setRGB(xoffset + x, yoffset + y, over_bi.getRGB(x, y));
            }
        }
        return this.srcFile.getName();
    }

    public void fill(Color c, Rectangle rect) {
        this.fillColor = c;
        for (int x = rect.x; x < rect.width; ++x) {
            for (int y = rect.y; y < rect.height; ++y) {
                this.bi.setRGB(x, y, this.fillColor.getRGB());
            }
        }
    }

    public void setText(String str, Rectangle rect, int fontHt) {
        this.setText(str, rect, fontHt, 14);
    }

    public void setText(String str, Rectangle rect, int fontHt, int baseLineHt) {
        this.setText(str, rect, fontHt, baseLineHt, new Color(42, 42, 42));
    }

    public void setText(String str, Rectangle rect, int fontHt, int baseLineHt, Color bkcolor) {
        this.text = str;
        Graphics2D g2 = this.bi.createGraphics();
        this.fill(bkcolor, rect);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font f = Cutter.getKButtonFont();
        Font font = new Font(f.getFontName(), 1, fontHt);
        g2.setFont(font);
        g2.setPaint(new Color(191, 196, 199));
        g2.setClip(0, 0, rect.width, rect.height);
        g2.drawString(str, rect.x + 2, baseLineHt);
    }

    public String colorToOuputName() {
        String tag = "" + counter++;
        String r = "_" + this.fillColor.getRed();
        String g = "_" + this.fillColor.getGreen();
        String b = "_" + this.fillColor.getBlue();
        return tag + r + g + b;
    }

    public String textToOuputName() {
        String tag = counter + "_";
        ++counter;
        return this.text == null ? "unknown" : tag + this.text;
    }

    public boolean write(File dst, String formatName) {
        if (formatName.equals("jpg")) {
            return JPEGUtils.saveJPEGFile(this.bi, dst);
        }
        try {
            ImageIO.write((RenderedImage)this.bi, formatName, dst);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Dimension getDimension() {
        int w = this.bi.getWidth();
        int h = this.bi.getHeight();
        return new Dimension(w, h);
    }
}

