/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_BBXT.BBxt;
import UI_Components.KComboItem;
import UI_Components.KLabel;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RmanTool;
import Utilities.EnvUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class KTitledComboBox
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public int RIGHT = 4;
    public int LEFT = 2;
    public int CENTER = 0;
    public KLabel label;
    public JComboBox<String> combo = new JComboBox();
    public int defaultWidth = 120;
    public int defaultHeight = 20;
    public int comboWidth = this.defaultWidth;
    public int comboHeight = this.defaultHeight;
    public boolean ignoreActionEvent = false;

    public void addToolTips(String[] tips) {
        String[] formatted = new String[tips.length];
        for (int n = 0; n < tips.length; ++n) {
            formatted[n] = TextUtils.formatAsHtml(tips[n], 40, 100);
        }
        this.combo.setRenderer(new ComboBoxRenderer(formatted));
    }

    public KTitledComboBox(String title) {
        this.label = new KLabel(title + "  ", 2);
        JPanel labelHolder = new JPanel();
        labelHolder.setLayout(new GridLayout(1, 1));
        labelHolder.add(this.label);
        GridBagConstraints c = new GridBagConstraints();
        this.combo.setFont(Cutter.defaultFont.font);
        this.combo.setRequestFocusEnabled(false);
        this.combo.addPopupMenuListener(new PopupMenuListener(){
            int index = 0;

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.index = KTitledComboBox.this.combo.getSelectedIndex();
                KTitledComboBox.this.ignoreActionEvent = true;
                if (this.index != 0) {
                    KTitledComboBox.this.combo.setSelectedIndex(0);
                } else if (this.index != KTitledComboBox.this.combo.getItemCount() - 1) {
                    KTitledComboBox.this.combo.setSelectedIndex(KTitledComboBox.this.combo.getItemCount() - 1);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        c.gridwidth = -1;
        c.gridheight = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.7;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 4, 0, 0);
        this.add((Component)labelHolder, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        this.combo.setPreferredSize(new Dimension(this.defaultWidth, this.defaultHeight));
        c.ipadx = this.defaultWidth - this.comboWidth;
        c.ipady = this.defaultHeight - this.comboHeight;
        c.fill = 0;
        this.add(this.combo, c);
    }

    public KTitledComboBox(String title, int alignment) {
        this(title, alignment, 0, 0);
    }

    public KTitledComboBox(String title, int alignment, int iPadxCombo, int iPadyCombo) {
        JPanel panel = new JPanel();
        this.label = new KLabel(title, 2);
        this.combo.setFont(Cutter.defaultFont.font);
        this.combo.setRequestFocusEnabled(false);
        this.combo.addPopupMenuListener(new PopupMenuListener(){
            int index = 0;

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (EnvUtils.isLinuxEnvironment()) {
                    this.index = KTitledComboBox.this.combo.getSelectedIndex();
                    KTitledComboBox.this.ignoreActionEvent = true;
                    if (this.index != 0) {
                        KTitledComboBox.this.combo.setSelectedIndex(0);
                    } else if (this.index != KTitledComboBox.this.combo.getItemCount() - 1) {
                        KTitledComboBox.this.combo.setSelectedIndex(KTitledComboBox.this.combo.getItemCount() - 1);
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        switch (alignment) {
            case 2: {
                gbc.weightx = 1.0;
                gbc.gridy = 0;
                gbc.gridx = 0;
                this.add((Component)this.label, gbc);
                gbc.weightx = 6.0;
                gbc.gridx = 1;
                gbc.ipadx = iPadxCombo;
                gbc.ipady = iPadyCombo;
                this.add(this.combo, gbc);
                break;
            }
            case 4: {
                gbc.weightx = 1.0;
                gbc.gridy = 0;
                gbc.gridx = 0;
                this.add(this.combo, gbc);
                gbc.ipadx = iPadxCombo;
                gbc.ipady = iPadyCombo;
                gbc.weightx = 6.0;
                gbc.gridx = 1;
                this.add((Component)this.label, gbc);
            }
        }
    }

    public void addItem(String item) {
        this.combo.addItem(item);
    }

    public void addItem(String[] item) {
        for (int i = 0; i < item.length; ++i) {
            this.combo.addItem(item[i]);
        }
    }

    public void removeItem(String item) {
        this.combo.removeItem(item);
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public void addActionListener(ActionListener l) {
        this.combo.addActionListener(l);
    }

    public void addItemListener(ItemListener l) {
        this.combo.addItemListener(l);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.combo.addPopupMenuListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.combo.addMouseListener(l);
    }

    public void setSelectedItem(String str) {
        this.combo.setSelectedItem(str);
    }

    public void setSelectedIndex(int index) {
        this.combo.setSelectedIndex(index);
    }

    public String getSelectedItem() {
        Object item = this.combo.getSelectedItem();
        return item == null ? "" : this.combo.getSelectedItem().toString();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.combo.setEnabled(flag);
    }

    @Override
    public String toString() {
        return "KTitledComboBox: label = " + this.label + ", combo = " + this.combo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreActionEvent) {
            this.ignoreActionEvent = false;
            return;
        }
        if (!RmanTool.init) {
            return;
        }
        JComboBox combo = (JComboBox)e.getSource();
        if (combo.getSelectedItem() instanceof KComboItem) {
            KComboItem item = (KComboItem)combo.getSelectedItem();
            if (item.action == null && item.tiptext != null) {
                BBxt.paste(item.tiptext);
            } else if (item.action != null) {
                Cutter.setLog("    Info:KLabelledComboBox.actionPerformed() - passing event to selected item\n        item text = " + item.text);
                item.action.actionPerformed(new ActionEvent(item, 0, null));
            }
        }
    }

    public void setMaximumRowCount(int n) {
        this.combo.setMaximumRowCount(n);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Cutter.setLog("    Info:KLabelledComboBox.itemStateChanged() " + e.toString());
        if (!RmanTool.init) {
            return;
        }
    }

    class ComboBoxRenderer
    extends BasicComboBoxRenderer {
        private String[] tooltips = null;

        public ComboBoxRenderer(String[] tips) {
            this.tooltips = new String[tips.length];
            for (int n = 0; n < tips.length; ++n) {
                this.tooltips[n] = tips[n];
            }
        }

        public JToolTip _createToolTip() {
            Cutter.setLog("ComboBoxRenderer.createToolTip");
            return new MultiLineToolTip();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(this.tooltips[index]);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

