/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Components.GBC;
import UI_Components.KButton.KInfoButton;
import UI_Components.ToolTip.MultiLineToolTip;
import Utilities.ComponentUtils;
import Utilities.ResourceUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class KTitledPanel
extends JPanel
implements Serializable {
    public String title = null;
    private JPanel helpPanel = new JPanel();
    protected JPanel mainPanel = new JPanel();
    private KInfoButton helpButton = new KInfoButton();
    private Border border = BorderFactory.createEtchedBorder();
    public TitledBorder titledBorder = null;

    public KTitledPanel(String title, String infoResItem) {
        this(title, infoResItem, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH + 5);
    }

    public KTitledPanel(String title, String infoResItem, int textWidth) {
        this(title);
        this.title = title;
        if (infoResItem != null) {
            String info = ResourceUtils.getInfoString(infoResItem);
            if (info != null) {
                this.helpButton.setMargin(new Insets(-3, -4, -2, -3));
                this.helpPanel.add((Component)this.helpButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(0, 0, 0, 0)));
                this.helpButton.setHelpText(info, textWidth);
            } else {
                System.out.println("KTitledPanel cannot get resource for " + infoResItem);
            }
        }
    }

    public KTitledPanel(String infoResItem, Insets margin, Insets insets) {
        this();
        String info = ResourceUtils.getInfoString(infoResItem);
        if (info != null) {
            KInfoButton helpButton = new KInfoButton();
            helpButton.setMargin(margin == null ? new Insets(-3, -4, -2, -3) : margin);
            this.helpPanel.add((Component)helpButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 0, insets == null ? new Insets(0, 0, 0, 0) : insets));
            helpButton.setHelpText(info, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH + 5);
        }
    }

    public KTitledPanel(String title, int justification) {
        this();
        this.title = title;
        if (title != null && title.length() > 0) {
            this.titledBorder = BorderFactory.createTitledBorder(this.border, title, justification, 2);
            this.setBorder(this.titledBorder);
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public KTitledPanel(String title) {
        this(title, new Color(0, 0, 0));
    }

    public KTitledPanel(String title, Color bg) {
        this();
        this.title = title;
        if (title != null && title.length() > 0) {
            this.titledBorder = BorderFactory.createTitledBorder(this.border, title, 1, 2);
            this.setBorder(this.titledBorder);
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public KTitledPanel(String title, Color bg, Color fc) {
        this();
        this.title = title;
        this.setBackground(bg);
        Font font = UIManager.getDefaults().getFont("JComboBox.font");
        if (title != null && title.length() > 0) {
            this.titledBorder = BorderFactory.createTitledBorder(this.border, title, 1, 2, font, fc);
            this.setBorder(this.titledBorder);
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public KTitledPanel() {
        super.setLayout(new GridBagLayout());
        this.helpPanel.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.setOpaque(true);
        super.add((Component)this.helpPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 0, new Insets(-11, 0, 0, -2)));
        super.add((Component)this.mainPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(2, 0, 0, 0)));
    }

    public void setTitleColor(Color c) {
        if (this.titledBorder == null) {
            return;
        }
        this.titledBorder.setTitleColor(c);
        this.setBorder(this.titledBorder);
        this.repaint();
    }

    public void setEtchedBorderColors() {
    }

    public void removeHelpPanel() {
        this.remove(this.helpPanel);
    }

    public void setHelpPanelVisibility(boolean f) {
        this.helpPanel.setVisible(f);
    }

    public void _addHelp(String infoResItem) {
        String info = ResourceUtils.getInfoString(infoResItem);
        if (info != null) {
            if (this.helpButton == null) {
                this.helpButton = new KInfoButton();
                this.helpButton.setMargin(new Insets(-3, -4, -2, -3));
                this.helpPanel.add((Component)this.helpButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(0, 0, 0, 0)));
            }
            this.helpButton.setHelpText(info, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH + 5);
        }
    }

    public void add(JComponent comp, GridBagConstraints gbc) {
        this.mainPanel.add((Component)comp, gbc);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setEnabled(boolean flag) {
        ComponentUtils cu = new ComponentUtils(this, null);
        Component[] comps = cu.getAll();
        if (comps != null) {
            for (int n = 0; n < comps.length; ++n) {
                comps[n].setEnabled(flag);
            }
        }
        if (this.titledBorder != null) {
            this.titledBorder.setTitleColor(flag ? Color.black : Color.gray);
        }
        this.repaint();
    }
}

