/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_BBXT.BBxt;
import UI_Components.KTextArea;
import UI_Desktop.Cutter;
import java.awt.event.MouseEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import kernal.Tokenizers.Tokenizer;

public class KWindowTextArea
extends KTextArea {
    private static final long serialVersionUID = 1L;
    private Karet caret = new Karet(this);

    public KWindowTextArea(int rows, int columns) {
        super(rows, columns);
        this.caret.setBlinkRate(((DefaultCaret)this.getCaret()).getBlinkRate());
        this.setCaret(this.caret);
    }

    private class Karet
    extends DefaultCaret {
        private static final long serialVersionUID = 1L;
        private KTextArea textArea;

        public Karet(KTextArea ta) {
            this.textArea = ta;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.getClickCount() == 2) {
                this.selectWord(this.getMark());
            }
        }

        private void selectWord(int offset) {
            try {
                int line = this.textArea.getLineOfOffset(offset);
                int begin = this.textArea.getLineStartOffset(line);
                int end = this.textArea.getLineEndOffset(line);
                this.textArea.setSelectionStart(begin);
                this.textArea.setSelectionEnd(end - 1);
                int ln = this.getLineErrorNumber();
                if (ln == -1) {
                    return;
                }
                BBxt.hilitLineNumber(ln);
                this.textArea.setSelectionStart(begin);
                this.textArea.setSelectionEnd(begin);
            }
            catch (BadLocationException e) {
                Cutter.setLog("KTextArea.Karet" + e.toString());
            }
        }

        private int getLineErrorNumber() {
            int errorNumber = -1;
            String line = KWindowTextArea.this.getSelectedText();
            if (line == null || line.trim().length() == 0) {
                return -1;
            }
            Tokenizer tok = new Tokenizer();
            tok.setBuffer(line);
            tok.setDelimitor("\n\t :;,.[]{}<>()");
            tok.getNextStr_return_delimitor = true;
            String str = tok.getNextStr();
            String prevStr = "";
            while (!str.equals("")) {
                try {
                    errorNumber = Integer.parseInt(str);
                    return errorNumber;
                }
                catch (NumberFormatException numberFormatException) {
                    prevStr = str;
                    str = tok.getNextStr();
                }
            }
            return errorNumber;
        }
    }
}

