/*
 * Decompiled with CFR 0.152.
 */
package UI_Components;

import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RmanTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LabelledTextField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public int RIGHT = 4;
    public int LEFT = 2;
    public int CENTER = 0;
    public JLabel label;
    public KTextField textfield = new KTextField();
    private boolean alwaysDisabled = false;

    public LabelledTextField(String title, String text) {
        this(title, text, 2);
    }

    public LabelledTextField(String title, String text, int alignment) {
        this(title, text, alignment, 0);
    }

    public LabelledTextField(String title, int charWidth) {
        this(title, charWidth, 0);
    }

    public LabelledTextField(String title, int charWidth, int spaceBetween) {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel(title, 2);
        this.label.setFont(Cutter.defaultFont.font);
        this.textfield.setFont(Cutter.defaultFont.font);
        this.textfield = new KTextField(this.label.toString(), charWidth);
        this.add((Component)this.label, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, spaceBetween)));
        this.add((Component)this.textfield, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
    }

    public LabelledTextField(String title, int charWidth, boolean flag, Color color, ActionListener listener) {
        this(title, charWidth, flag, color, listener, true);
    }

    public LabelledTextField(String title, int charWidth, boolean flag, Color color, ActionListener listener, boolean alwaysDisabled) {
        this(title, charWidth);
        this.setEnabled(true);
        this.setEditable(flag);
        if (listener != null) {
            this.addActionListener(listener);
        }
        this.alwaysDisabled = alwaysDisabled;
    }

    public LabelledTextField(String title, String text, int alignment, int x) {
        this.label = new JLabel(title, 2);
        this.label.setFont(Cutter.defaultFont.font);
        this.textfield.setFont(Cutter.defaultFont.font);
        this.textfield.setText(text);
        this.setLayout(new GridBagLayout());
        switch (alignment) {
            case 2: {
                this.add((Component)this.label, new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 1, 17, 0, new Insets(0, 0, 0, 0)));
                this.add((Component)this.textfield, new GBC(1, 0, 1, 1, 1.0, 1.0, 6, 1, 17, 0, new Insets(0, x, 0, 0)));
                break;
            }
            case 4: {
                this.add((Component)this.textfield, new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 1, 17, 0, new Insets(0, 0, 0, 0)));
                this.add((Component)this.label, new GBC(1, 0, 1, 1, 1.0, 1.0, 6, 1, 17, 0, new Insets(0, 0, 0, 0)));
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.textfield.addActionListener(l);
    }

    public String getText() {
        return this.textfield.getText();
    }

    public void setText(String text) {
        if (this.textfield != null) {
            this.setText(text, false);
        }
    }

    public void setText(String text, boolean warning) {
        if (this.textfield != null) {
            this.textfield.setForeground(warning ? Color.red : Color.black);
            this.textfield.setText(text);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabel(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public void setBold(boolean flag) {
        if (this.textfield != null) {
            this.textfield.setBold(flag);
        }
    }

    public void setColor(Color c) {
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.textfield == null) {
            return;
        }
        this.textfield.setEnabled(b);
        if (this.alwaysDisabled) {
            this.textfield.setEditable(false);
        }
    }

    public void setEditable(boolean flag) {
        if (this.textfield != null) {
            this.textfield.setEditable(flag);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!RmanTool.init) {
            return;
        }
        JTextField source = (JTextField)e.getSource();
        if (source == this.textfield) {
            // empty if block
        }
    }
}

