/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.PrefsReadWriters;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KColorField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static KColorChooser colorDialog = new KColorChooser();

    public KColorField(int charWidth) {
        super(charWidth);
        this.setEditable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    colorDialog.setColor(KColorField.textToColor(KColorField.this.getText()));
                    colorDialog.setVisible(true);
                    Color c = colorDialog.outColor;
                    if (c == null) {
                        return;
                    }
                    KColorField.this.setText(c.getRed() + " " + c.getGreen() + " " + c.getBlue());
                }
            }
        });
    }

    @Override
    public void setText(String string) {
        Color color = KColorField.textToColor(string);
        this.setForeground(color);
        this.setBackground(color);
        this.setSelectedTextColor(color);
        this.setSelectionColor(color);
        super.setText(string);
    }

    private static Color textToColor(String str) {
        if (str == null || str.length() == 0) {
            return Cutter.defaultBackground;
        }
        String[] comp = TextUtils.tokenize(str);
        if (comp == null) {
            return Cutter.defaultBackground;
        }
        Color color = Color.white;
        if (comp.length == 3) {
            return new Color(Integer.parseInt(comp[0]), Integer.parseInt(comp[1]), Integer.parseInt(comp[2]));
        }
        return Cutter.defaultBackground;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
    }

    private void getColorFromChooser() {
    }

    private static class KColorChooser
    extends JDialog {
        private static final long serialVersionUID = 1L;
        public JColorChooser chooser = new JColorChooser();
        private JButton cancelButton = new JButton("Cancel");
        private JButton okButton = new JButton(" OK ");
        public Color outColor = null;

        private KColorChooser() {
            super(Cutter.desktop, "Color Chooser", true);
            this.setVisible(false);
            this.removeSwatchPanel();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            contentPane.add((Component)this.chooser, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 10, 0, new Insets(2, 2, 2, 2)));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    outColor = null;
                    this.setVisible(false);
                }
            });
            contentPane.add((Component)this.cancelButton, new GBC(4, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 5, 10)));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            contentPane.add((Component)this.okButton, new GBC(5, 1, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(0, 0, 5, 10)));
            this.pack();
            this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    outColor = chooser.getColor();
                }
            });
        }

        public void setColor(Color color) {
            this.chooser.setColor(color);
            AbstractColorChooserPanel[] p = this.chooser.getChooserPanels();
            for (int n = 0; n < p.length; ++n) {
                if (p[n] == null) continue;
                p[n].updateChooser();
            }
            JComponent c = this.chooser.getPreviewPanel();
            Graphics g = c.getGraphics();
            g.setColor(color);
            c.update(g);
        }

        private void removeSwatchPanel() {
            AbstractColorChooserPanel[] oldPanel = this.chooser.getChooserPanels();
            AbstractColorChooserPanel[] newPanel = new AbstractColorChooserPanel[oldPanel.length - 1];
            for (int n = 0; n < newPanel.length; ++n) {
                newPanel[n] = oldPanel[n + 1];
            }
            this.chooser.setChooserPanels(newPanel);
        }
    }
}

