/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.PrefsReadWriters;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTextField.NewlineListener;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Desktop.Cutter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PrefCBTextField
extends PrefTextField
implements ActionListener {
    JCheckBox cb = new JCheckBox();
    JPanel top = new JPanel();
    JPanel low = new JPanel();
    int prefCheckBoxID = -1;
    int prefPathFieldID = -1;

    public PrefCBTextField() {
        this.displayMode = 1;
        this.setLayout(new GridBagLayout());
        this.top.setLayout(new GridBagLayout());
        this.low.setLayout(new GridBagLayout());
        this.cb.addActionListener(this);
    }

    public PrefCBTextField(String title, int titlewidth, int prefCbID, int prefPathID, int charWidth) {
        this();
        this.prefCheckBoxID = prefCbID;
        this.prefPathFieldID = prefPathID;
        this.label.setText(title);
        Dimension preferredSize = this.label.getPreferredSize();
        preferredSize.width = titlewidth;
        this.label.setPreferredSize(preferredSize);
        String cerealName = title.replace(' ', '_');
        this.field = new KSerialTextField(cerealName, "", charWidth);
        this.field.usesModelDialog = true;
        this.field.setFont(Cutter.defaultFont.font);
        this.field.setBold(false);
        this.button = new PathSearchButton(this, "?", "Choose Directory", 1, 7, 0);
        String b = Preferences.get(prefCbID);
        this.cb.setSelected(b.equals("true"));
        String[] singleKey = new String[]{"user"};
        int[] prefIDs = new int[]{prefPathID};
        this.originalKeys = singleKey;
        this.originalPrefIDs = prefIDs;
        this.readFromPrefs();
        this.field.setEnabled(this.cb.isSelected());
        this.field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                PrefCBTextField.this.pathIsValid();
                PrefCBTextField.this.writeToPrefs();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PrefCBTextField.this.pathIsValid();
                PrefCBTextField.this.writeToPrefs();
            }
        });
        this.field.addNewlineListener(new NewlineListener(){

            @Override
            public void newlineHappened() {
                PrefCBTextField.this.pathIsValid();
                PrefCBTextField.this.writeToPrefs();
            }
        });
    }

    public void addToParent(JPanel parent, int row) {
        this.top.add((Component)this.cb, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 2)));
        this.top.add((Component)this.label, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        this.low.add((Component)this.field, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
        this.low.add((Component)this.button, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 0, 0)));
        JPanel all = new JPanel();
        all.setLayout(new GridBagLayout());
        all.add((Component)this.label, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 4, 0)));
        all.add((Component)this.cb, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 4, 0)));
        all.add((Component)this.field, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 4, 0)));
        all.add((Component)this.button, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 4, 0)));
        parent.add((Component)all, new GBC(0, row, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
    }

    public void _addToParent(JPanel parent, int row) {
        this.top.add((Component)this.cb, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 2)));
        this.top.add((Component)this.label, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        this.low.add((Component)this.field, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
        this.low.add((Component)this.button, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 0, 0)));
        JPanel all = new JPanel();
        all.setLayout(new GridBagLayout());
        all.add((Component)this.top, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        all.add((Component)this.low, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 4, 0)));
        parent.add((Component)all, new GBC(0, row, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox) {
            this.field.setEnabled(this.cbIsActive());
            this.pathIsValid();
            this.writeToPrefs();
        }
    }

    public boolean cbIsActive() {
        return this.cb.isSelected();
    }

    public boolean pathIsValid() {
        if (this.field.getText().trim().length() == 0) {
            return false;
        }
        File f = new File(this.field.getText());
        boolean isValid = f.exists() && f.isDirectory();
        this.field.setForeground(isValid ? Color.black : Color.red);
        return isValid;
    }

    @Override
    public void readFromPrefs() {
        super.readFromPrefs();
    }

    @Override
    public void writeToPrefs() {
        String boolStr = this.cbIsActive() ? "true" : "false";
        Preferences.write(this.prefCheckBoxID, boolStr);
        Preferences.write(this.prefPathFieldID, this.getTextFromField());
    }
}

