/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.PrefsReadWriters;

import Preferences.Preferences;
import Preferences.PreferencesReadWriter;
import UI_Components.GBC;
import UI_Components.PrefsReadWriters.KColorField;
import UI_Desktop.Cutter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefColorFields
extends JPanel
implements ItemListener,
PreferencesReadWriter {
    private static final long serialVersionUID = 1L;
    static final int COLUMNS = 2;
    private JComboBox<String> popup = null;
    private int y = 0;
    private Vector<PrefColorField> listOfFields = new Vector();

    public PrefColorFields() {
        this.setLayout(new GridBagLayout());
    }

    public void addPopup(String title, String[] items) {
        this.popup = new JComboBox<String>(items);
        this.popup.setPreferredSize(new Dimension(65, 20));
        this.popup.addItemListener(this);
        this.add(this.popup, new GBC(0, this.y++, 2, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 5, 0)));
    }

    public void addField(String title, String[] keys, int[] prefIDs, int charWidth, String[] altTitles) {
        PrefColorField field = new PrefColorField(title, keys, prefIDs, charWidth, altTitles);
        field.addToParent(this, this.y++);
        this.listOfFields.addElement(field);
    }

    public String getColorStrForItem(String itemLabel) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField pcf = this.listOfFields.elementAt(n);
            if (!pcf.label.getText().trim().equals(itemLabel)) continue;
            return pcf.field.getText();
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JComboBox combo = (JComboBox)e.getSource();
        if (e.getStateChange() == 2) {
            return;
        }
        String key = combo.getSelectedItem().toString();
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField field = this.listOfFields.elementAt(n);
            field.setTextTableUsingKey(key);
        }
    }

    public void setAllFieldsNamed(String name, String rgbStr) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField pcf = this.listOfFields.elementAt(n);
            if (!pcf.label.getText().trim().equals(name)) continue;
            Hashtable table = pcf.textTable;
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                table.put(key, rgbStr);
            }
            pcf.field.setText(rgbStr);
        }
    }

    @Override
    public void writeToPrefs() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField field = this.listOfFields.elementAt(n);
            field.writeToPrefs();
        }
    }

    @Override
    public void readFromPrefs() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField field = this.listOfFields.elementAt(n);
            field.readFromPrefs();
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefColorField field = this.listOfFields.elementAt(n);
            field.setEnabled(flag);
        }
    }

    public class PrefColorField
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Hashtable<String, String> textTable;
        private Hashtable<String, Integer> prefTable;
        private Hashtable<String, String> altTitleTable;
        private JLabel label = new JLabel();
        private KColorField field;
        private String currentKey;
        private String[] originalKeys = null;
        private int[] originalPrefIDs = null;

        public PrefColorField(String title, String[] key, int[] prefID, int charWidth, String[] altTitles) {
            this.setLayout(new GridBagLayout());
            this.label.setFont(Cutter.defaultFont.font);
            this.label.setText(title);
            this.field = new KColorField(charWidth);
            this.originalKeys = key;
            this.originalPrefIDs = prefID;
            this.readFromPrefs();
            this.altTitleTable = new Hashtable(altTitles.length);
            for (int n = 0; n < this.originalPrefIDs.length; ++n) {
                this.altTitleTable.put(key[n], altTitles[n]);
            }
        }

        public void addToParent(JPanel host, int row) {
            host.add((Component)this.label, new GBC(0, row, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 2, 0)));
            host.add((Component)this.field, new GBC(1, row, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 2, 5)));
        }

        public void setTextTableUsingKey(String key) {
            this.textTable.remove(this.currentKey);
            this.textTable.put(this.currentKey, this.field.getText());
            this.currentKey = key;
            this.field.setText(this.textTable.get(key));
            this.label.setText(this.altTitleTable.get(key));
        }

        public void readFromPrefs() {
            this.textTable = new Hashtable(this.originalPrefIDs.length);
            this.prefTable = new Hashtable(this.originalPrefIDs.length);
            for (int n = 0; n < this.originalPrefIDs.length; ++n) {
                this.textTable.put(this.originalKeys[n], Preferences.get(this.originalPrefIDs[n]));
                this.prefTable.put(this.originalKeys[n], this.originalPrefIDs[n]);
            }
            this.currentKey = this.originalKeys[0];
            String text = this.textTable.get(this.currentKey);
            this.field.setText(text);
        }

        public void writeToPrefs() {
            this.setTextTableUsingKey(this.currentKey);
            Enumeration<String> e = this.textTable.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                int prefID = this.prefTable.get(key);
                Preferences.write(prefID, this.textTable.get(key));
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            this.label.setEnabled(flag);
            this.field.setEnabled(flag);
        }
    }
}

