/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.PrefsReadWriters;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KTextField.KTextField;
import UI_Desktop.Cutter;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PrefTextField
extends JPanel {
    public static final int IGNORE = 0;
    public static final int DIRPATH = 1;
    public static final int FILENAME = 3;
    public static final int FILEEXT = 5;
    public static final int FILEPATH = 7;
    public static final int FIELD_TEXT_REPLACE = 0;
    public static final int FIELD_TEXT_ADD = 1;
    static final int COLUMNS = 3;
    protected int displayMode = 1;
    protected Hashtable<String, String> textTable;
    protected Hashtable<String, Integer> prefTable;
    protected JLabel label = new JLabel();
    public KTextField field;
    protected PathSearchButton button;
    protected String currentKey;
    protected String[] originalKeys = null;
    protected int[] originalPrefIDs = null;

    public PrefTextField() {
    }

    public PrefTextField(String title, String[] key, int[] prefID, int charWidth, int mode, boolean modelPopUP) {
        this(title, key, prefID, charWidth, mode, modelPopUP, 7, 0);
    }

    public PrefTextField(String title, String[] key, int[] prefID, int charWidth, int mode, boolean modelPopUP, final int pathMode, int replaceMode) {
        this.displayMode = mode;
        this.setLayout(new GridBagLayout());
        this.label.setFont(Cutter.defaultFont.font);
        this.label.setText(title);
        this.field = new KTextField(title, charWidth);
        this.field.usesModelDialog = modelPopUP;
        this.field.setFont(Cutter.defaultFont.font);
        this.field.setBold(false);
        this.button = mode == 7 ? new PathSearchButton(this, "?", "Choose File", 2, pathMode, replaceMode) : (mode == 3 ? new PathSearchButton(this, "?", "Choose File", 2, pathMode, replaceMode) : (mode == 0 ? null : new PathSearchButton(this, "?", "Choose Directory", 1, pathMode, replaceMode)));
        this.originalKeys = key;
        this.originalPrefIDs = prefID;
        this.readFromPrefs();
        this.field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                if (pathMode != 3) {
                    PrefTextField.this.checkPathValidity();
                }
            }

            @Override
            public void focusLost(FocusEvent evt) {
                if (pathMode != 3) {
                    PrefTextField.this.checkPathValidity();
                }
            }
        });
    }

    public void checkPathValidity() {
        if (this.field.getText().trim().length() == 0) {
            return;
        }
        if (this.field.getText().startsWith("http")) {
            this.field.setForeground(Color.black);
            return;
        }
        if (this.button != null && this.displayMode != 3 && this.displayMode != 5) {
            String path = this.field.getText().trim();
            File f = new File(TextUtils.replace_USER_HOME(path));
            if (f.exists()) {
                this.field.setForeground(Color.black);
            } else {
                this.field.setForeground(Color.red);
            }
        }
    }

    public String getTextFromField() {
        String path = this.field.getText().trim();
        return TextUtils.replace_USER_HOME(path);
    }

    public JPanel addToParent(JPanel host, int row, boolean addButton) {
        int columns = addButton ? 3 : 2;
        host.add((Component)this.label, new GBC(0, row, 1, 1, 0.0, 1.0, 0, 0, 13, 2, new Insets(0, 0, 2, 0)));
        if (addButton) {
            host.add((Component)this.field, new GBC(1, row, 1, 1, 0.0, 1.0, 0, 0, 13, 2, new Insets(0, 0, 2, 5)));
            host.add((Component)this.button, new GBC(2, row, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 2, 0)));
        } else {
            host.add((Component)this.field, new GBC(1, row, 1, 1, 1.0, 1.0, 0, 0, 13, 2, new Insets(0, 0, 2, 5)));
            this.button = null;
        }
        return host;
    }

    public JPanel addSeparatorToParent(JPanel host, int row, JSeparator separator) {
        host.add((Component)separator, new GBC(0, row, 0, 1, 1.0, 1.0, 0, 0, 13, 2, new Insets(3, 0, 5, 0)));
        return host;
    }

    public void setTextUsingKey(String key) {
        this.textTable.remove(this.currentKey);
        this.textTable.put(this.currentKey, this.field.getText());
        this.currentKey = key;
        this.field.setText(this.textTable.get(key));
    }

    public void setTextFromPath(File file) {
        switch (this.displayMode) {
            case 1: {
                if (file.isDirectory()) {
                    this.field.setText(file.getPath());
                    break;
                }
                this.field.setText(file.getParent());
                break;
            }
            case 7: {
                if (!EnvUtils.isOSXEnvironment()) {
                    if (!file.isFile()) break;
                    this.field.setText(file.getPath());
                    break;
                }
                this.field.setText(file.getPath());
                break;
            }
            case 3: {
                if (!EnvUtils.isOSXEnvironment()) {
                    if (!file.isFile()) break;
                    this.field.setText(file.getName());
                    break;
                }
                this.field.setText(file.getName());
                break;
            }
            case 5: {
                if (file.isDirectory()) {
                    return;
                }
                String ext = FileUtils.getExtension(file.getName());
                if (ext == null) break;
                this.field.setText(ext);
            }
        }
    }

    public void readFromPrefs() {
        this.textTable = new Hashtable(this.originalPrefIDs.length);
        this.prefTable = new Hashtable(this.originalPrefIDs.length);
        for (int n = 0; n < this.originalPrefIDs.length; ++n) {
            if (this.originalPrefIDs[n] == -1) continue;
            this.textTable.put(this.originalKeys[n], Preferences.get(this.originalPrefIDs[n]));
            this.prefTable.put(this.originalKeys[n], this.originalPrefIDs[n]);
        }
        if (this.originalPrefIDs[0] == 0) {
            this.field.setText("");
            this.currentKey = "";
        } else {
            this.currentKey = this.originalKeys[0];
            String text = this.textTable.get(this.currentKey);
            this.field.setText(text);
        }
    }

    public void convertToUnix() {
        if (this.displayMode == 1 || this.displayMode == 7) {
            String originalText = this.getTextFromField();
            String unixedText = FileUtils.toUnixPath(originalText);
            Cutter.setLog("PrefTextField originalText >" + originalText + "<");
            Cutter.setLog("PrefTextField unixedText >" + unixedText + "<");
            this.field.setText(unixedText);
            return;
        }
        Cutter.setLog("    Warning:PrefTextField.convertToUnix() - ignore request on field with label:\n         \"" + this.label.getText() + "\"");
    }

    public void writeToPrefs() {
        if (this.currentKey == null) {
            Cutter.setLog("    Error: PrefTextField.writeToPrefs() - currentKey is null");
            return;
        }
        this.setTextUsingKey(this.currentKey);
        Enumeration<String> e = this.textTable.keys();
        while (e.hasMoreElements()) {
            if (e == null) {
                Cutter.setLog("    Error: PrefTextFields.PrefTextField.writeToPrefs() - Enumeration is null");
                return;
            }
            String key = e.nextElement();
            if (key == null) {
                Cutter.setLog("    Error: PrefTextFields.PrefTextField.writeToPrefs() - key is null");
                return;
            }
            Integer integer = this.prefTable.get(key);
            if (integer == null) {
                Cutter.setLog("    Error: PrefTextFields.PrefTextField.writeToPrefs() - integer is null");
                return;
            }
            int prefID = integer;
            Preferences.write(prefID, this.textTable.get(key));
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        this.label.setEnabled(flag);
        this.field.setEnabled(flag);
        if (this.button != null) {
            this.button.setEnabled(flag);
        }
    }

    public void setVisibility(boolean flag) {
        this.label.setVisible(flag);
        this.field.setVisible(flag);
        if (this.button != null) {
            this.button.setVisible(flag);
        }
    }

    public void setLabelStyle(int style) {
        Font f = this.label.getFont();
        this.label.setFont(new Font(f.getName(), style, f.getSize()));
    }
}

