/*
 * Decompiled with CFR 0.152.
 */
package UI_Components.PrefsReadWriters;

import Preferences.PreferencesReadWriter;
import UI_Components.GBC;
import UI_Components.PrefsReadWriters.PrefCBTextField;
import UI_Components.PrefsReadWriters.PrefTextField;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;

public class PrefTextFields
extends JPanel
implements ItemListener,
PreferencesReadWriter {
    static final int COLUMNS = 3;
    private JComboBox popup = null;
    private int y = 0;
    private Vector<PrefTextField> listOfFields = new Vector();
    private String popupTitle = null;
    private String fieldTitle = null;

    public PrefTextFields() {
        this.setLayout(new GridBagLayout());
    }

    public void addActionListenerTo(String fieldName, ActionListener listener) {
        JTextField tf = this.getFieldTitled(fieldName);
        if (tf != null) {
            tf.addActionListener(listener);
        }
    }

    public void addCaretListenerTo(String fieldName, CaretListener listener) {
        JTextField tf = this.getFieldTitled(fieldName);
        if (tf != null) {
            tf.addCaretListener(listener);
        }
    }

    public JComboBox addPopup(String title, String[] items) {
        this.popup = new JComboBox<String>(VectorUtils.toVector(items));
        this.popup.setPreferredSize(new Dimension(65, 20));
        this.popup.addItemListener(this);
        this.add((Component)this.popup, new GBC(0, this.y++, 3, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 5, 0)));
        this.popupTitle = title;
        return this.popup;
    }

    public PrefTextField addField(String title, String[] keys, int[] prefIDs, int charWidth, int mode, boolean addButton, boolean modelPopUP) {
        PrefTextField field = new PrefTextField(title, keys, prefIDs, charWidth, mode, modelPopUP, 7, 0);
        field.addToParent(this, this.y++, addButton);
        this.listOfFields.addElement(field);
        return field;
    }

    public PrefTextField addField(String title, String[] keys, int[] prefIDs, int charWidth, int mode, boolean addButton, boolean modelPopUP, int pathMode, int replaceMode) {
        PrefTextField field = new PrefTextField(title, keys, prefIDs, charWidth, mode, modelPopUP, pathMode, replaceMode);
        field.addToParent(this, this.y++, addButton);
        this.listOfFields.addElement(field);
        return field;
    }

    public PrefTextField addCheckboxField(String title, int titlewidth, int prefCbID, int prefPathID, int charWidth) {
        PrefCBTextField field = new PrefCBTextField(title, titlewidth, prefCbID, prefPathID, charWidth);
        field.addToParent(this, this.y++);
        this.listOfFields.addElement(field);
        return field;
    }

    public void addSeparator() {
        PrefTextField field = new PrefTextField();
        field.addSeparatorToParent(this, this.y++, new JSeparator());
    }

    public String getFieldText(String title) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField item = this.listOfFields.elementAt(n);
            if (!item.label.getText().trim().equals(title.trim())) continue;
            return item.field.getText().trim();
        }
        return "";
    }

    public JTextField getFieldTitled(String title) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField item = this.listOfFields.elementAt(n);
            if (!item.label.getText().trim().equals(title.trim())) continue;
            return item.field;
        }
        return null;
    }

    public void setFieldTitledVisibility(String title, boolean f) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField item = this.listOfFields.elementAt(n);
            if (!item.label.getText().trim().equals(title.trim())) continue;
            item.setVisibility(f);
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JComboBox combo = (JComboBox)e.getSource();
        if (e.getStateChange() == 2) {
            return;
        }
        String key = combo.getSelectedItem().toString();
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.setTextUsingKey(key);
        }
    }

    public void convertToUnix() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.convertToUnix();
        }
    }

    @Override
    public void writeToPrefs() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.writeToPrefs();
        }
    }

    @Override
    public void readFromPrefs() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.readFromPrefs();
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.setEnabled(flag);
        }
    }

    public void checkPathValidity() {
        for (int n = 0; n < this.listOfFields.size(); ++n) {
            PrefTextField field = this.listOfFields.elementAt(n);
            field.checkPathValidity();
        }
    }
}

