/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript;

import UI_CutletScript.send.CutletExecutor;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.Zipper.FileQuery;
import UI_Tools.Zipper.ZipOutput;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;

public class CutletCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CUTLET_DISTRIBUTION_FILENAME = "cutlet_distribution.txt";
    private static String CUTTINGS_DIR_NAME = "Cuttings";
    private static File CUTTINGS_DIR = new File(FileUtils.getPWD(), CUTTINGS_DIR_NAME);
    public static int BYTES_SEND_LIMIT = 0x3200000;
    private static int MAX_CUTTINGS_DIR_SIZE = 0x3200000;
    public String noun = null;
    public String verb = null;
    public CutletArg[] args = new CutletArg[0];
    public boolean srcIsDirectory = false;
    public byte[] dataBytes = null;
    public int permission = 0;

    public static CutletCmd[] toCmdArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        CutletCmd[] out = new CutletCmd[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (CutletCmd)v.elementAt(n);
        }
        return out;
    }

    public static CutletArg[] toArgArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        CutletArg[] out = new CutletArg[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (CutletArg)v.elementAt(n);
        }
        return out;
    }

    public static File getOutFile(CutletCmd cmd) {
        File f;
        CutletArg nameArg = cmd.getArgWithName("-name");
        if (nameArg == null) {
            return null;
        }
        File file = f = nameArg.value.startsWith(".") ? FileUtils.resolveRelativePath(CUTTINGS_DIR, nameArg.value) : new File(CUTTINGS_DIR, nameArg.value);
        if (cmd.permission == 1) {
            if (CutletCmd.cuttingsDirSizeOK()) {
                f = new File(CUTTINGS_DIR, f.getName());
            } else {
                return null;
            }
        }
        if (cmd.srcIsDirectory) {
            f = new File(f.getParentFile(), f.getName() + ".zip");
        }
        if (!FileUtils.makeDirectories(f.getParentFile())) {
            Cutter.setLog("    Error: CutletCmd.getOutFile() - returned null for -\n           " + f.getPath());
            return null;
        }
        return f;
    }

    public static boolean cuttingsDirSizeOK() {
        long size = FileUtils.getTotalSize(CUTTINGS_DIR);
        return size < (long)MAX_CUTTINGS_DIR_SIZE;
    }

    public static File getSrcFile(CutletCmd cmd) {
        CutletArg srcArg = cmd.getArgWithName("-src");
        if (srcArg == null) {
            return null;
        }
        File f = srcArg.value.startsWith(".") ? FileUtils.resolveRelativePath(FileUtils.getPWDFile(), srcArg.value) : new File(FileUtils.getPWDFile(), srcArg.value);
        if (f != null && f.exists()) {
            return f;
        }
        f = new File(srcArg.value);
        return f;
    }

    public static File writeDataToFile(CutletCmd cmd) {
        File outFile = CutletCmd.getOutFile(cmd);
        if (outFile.exists()) {
            Cutter.setLog("    Info:CutletCmd.writeDataToFile() - deleting >" + outFile + "<");
            FileUtils.deleteAll(outFile);
        }
        if (cmd.dataBytes != null) {
            FileUtils.writeAsBinary(outFile, cmd.dataBytes);
            Cutter.setLog("    Info:CutletCmd.writeDataToFile() - Successfully written file \"" + outFile.getPath() + "\"");
            return outFile;
        }
        return null;
    }

    public CutletCmd(String line) throws Exception {
        if (line == null || line.trim().length() == 0) {
            throw new Exception("    Error: CutletCmd.constructor() - input string is empty or null");
        }
        Vector v = this.parse(line);
        if (v != null) {
            this.args = CutletCmd.toArgArray(v);
        }
    }

    private Vector parse(String line) throws Exception {
        String remainder = this.parseNounVerb(line);
        if (remainder.length() == 0) {
            return null;
        }
        String[] tokens = CutletCmd.parseArgName(remainder.trim());
        Vector<CutletArg> listOfArgs = new Vector<CutletArg>();
        while (tokens != null) {
            String argValue;
            String argName = tokens[0];
            if (argName.equals("-data")) {
                argValue = tokens[1].trim();
                listOfArgs.addElement(new CutletArg(argName, argValue));
                return listOfArgs;
            }
            if ((tokens = CutletCmd.parseArgValue(tokens[1])) == null) break;
            argValue = tokens[0];
            listOfArgs.addElement(new CutletArg(argName, argValue));
            if ((tokens = CutletCmd.parseArgName(tokens[1])) != null) continue;
            break;
        }
        return listOfArgs;
    }

    public static String[] parseArgValue(String input) throws Exception {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        if ((input = input.trim()).charAt(0) != '\"') {
            throw new Exception("Badly formed argument value\n    " + input + "\nThe first word should begin with a quotation.\nThe error may have been caused by the first \ntwo words of the command not being \nseparated by a dot.\n");
        }
        for (int n = 1; n < input.length(); ++n) {
            if (input.charAt(n) != '\"') continue;
            String[] out = new String[]{input.substring(0, n + 1), input.substring(n + 1)};
            return out;
        }
        throw new Exception("Badly formed quoted string: " + input);
    }

    public static String[] parseArgName(String input) throws Exception {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        if (!(input = input.trim()).startsWith("-")) {
            throw new Exception("This input does not begin with the name of an argument\n    " + input + "\nArgument names must begin with a dash. This error can\nbe caused by mistakenly omitting the dot between the \nfirst and second words of a cutlet command.\n");
        }
        int spaceIndex = input.indexOf(32);
        if (spaceIndex == -1) {
            return null;
        }
        String[] out = new String[]{input.substring(0, spaceIndex).trim(), input.substring(spaceIndex + 1).trim()};
        return out;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.noun).append(".").append(this.verb);
        if (this.args != null) {
            for (int n = 0; n < this.args.length; ++n) {
                b.append(" " + this.args[n].toString());
            }
        }
        return b.toString();
    }

    public boolean addArg(String name, String value) {
        Vector<CutletArg> v = new Vector<CutletArg>();
        boolean doAdd = false;
        for (int n = 0; n < this.args.length; ++n) {
            if (this.args[n].name.equals(name)) {
                return false;
            }
            v.addElement(this.args[n]);
        }
        try {
            v.addElement(new CutletArg(name, "\"" + value + "\""));
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: CutletCmd.addArg(" + name + ", " + value + ")\n\t" + e.toString());
            return false;
        }
        this.args = CutletCmd.toArgArray(v);
        return true;
    }

    public int prepareData() throws Exception {
        if (!this.noun.equals("file") && !this.noun.equals("build")) {
            return 0;
        }
        if (this.noun.equals("message")) {
            return 0;
        }
        CutletArg dataArg = this.getArgWithName("-data");
        CutletArg srcArg = this.getArgWithName("-src");
        if (dataArg != null || srcArg == null || srcArg.value.trim().length() == 0) {
            Cutter.setLog("    Info: CutletCmd.prepareData() - none prepared");
            return 0;
        }
        if (this.dataBytes != null) {
            return 0;
        }
        File srcFile = CutletCmd.getSrcFile(this);
        if (srcFile == null || !srcFile.exists()) {
            throw new Exception("Cannot find the following source file for,\n     " + this.toString());
        }
        Object zipFile = null;
        String dataStr = "";
        if (srcFile.isDirectory()) {
            String[] folders;
            File srcParent;
            FileQuery query = new FileQuery(srcFile);
            String[] rawPaths = query.getAllPaths();
            String[] trimmedPaths = query.trim(rawPaths, srcParent = srcFile.getParentFile(), folders = new String[]{"cutter_history"}, null, 0, null);
            if (trimmedPaths.length == 0) {
                return 0;
            }
            ZipOutput zipout = new ZipOutput(srcFile, trimmedPaths, null, null);
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            zipout.writeZipDataTo(bstream, true);
            this.srcIsDirectory = true;
            this.dataBytes = bstream.toByteArray();
            return this.dataBytes.length;
        }
        this.dataBytes = FileUtils.readAsBinary(srcFile.getPath());
        if (this.dataBytes == null) {
            Cutter.setLog("    Error:CutletCmd.prepareData() - cannot read data file \"" + srcFile.getPath() + "\"");
            return 0;
        }
        if (this.noun.equals("build")) {
            CutletArg targetIP = this.getArgWithName("-recipientIP");
            Cutter.setLog("    Info:CutletCmd.prepareData() prepared " + this.dataBytes.length + " bytes.");
        } else {
            Cutter.setLog("    Info:CutletCmd.prepareData() prepared " + this.dataBytes.length + " bytes.");
        }
        return this.dataBytes.length;
    }

    public String parseNounVerb(String input) throws Exception {
        int spaceIndex = input.indexOf(32);
        int dotIndex = input.indexOf(46);
        if (dotIndex == -1 || dotIndex + 1 == input.length()) {
            throw new Exception("Badly formed noun.verb command >" + input + "<");
        }
        this.noun = input.substring(0, dotIndex).trim();
        if (this.noun.indexOf(32) != -1) {
            throw new Exception("Badly formed noun - cannot include a space");
        }
        if (spaceIndex == -1) {
            this.verb = input.substring(dotIndex + 1).trim();
            return "";
        }
        this.verb = input.substring(dotIndex + 1, spaceIndex).trim();
        return input.substring(spaceIndex + 1);
    }

    public boolean hasArgNamed(String name) {
        for (int n = 0; n < this.args.length; ++n) {
            if (!this.args[n].name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public CutletArg getArgWithName(String name) {
        for (int n = 0; n < this.args.length; ++n) {
            if (!this.args[n].name.equals(name)) continue;
            return this.args[n];
        }
        return null;
    }

    public static String[] tokenize(String input, String delim) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, delim);
        while (t.hasMoreTokens()) {
            String str = t.nextToken();
            v.addElement(str);
        }
        return VectorUtils.toStringArray(v);
    }

    public static int getDirSize(CutletCmd cmd) {
        File srcFile = CutletCmd.getSrcFile(cmd);
        if (srcFile == null || !srcFile.isDirectory()) {
            return 0;
        }
        FileQuery query = new FileQuery(srcFile);
        String[] rawPaths = query.getAllPaths();
        File srcParent = srcFile.getParentFile();
        String[] folders = new String[]{"cutter_history"};
        String[] trimmedPaths = query.trim(rawPaths, srcFile.getParentFile(), folders, null, 0, null);
        if (trimmedPaths.length == 0) {
            return 0;
        }
        int total = 0;
        for (int n = 0; n < trimmedPaths.length; ++n) {
            total = (int)((long)total + new File(srcParent, trimmedPaths[n]).length());
        }
        return total;
    }

    public class CutletArg
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name = "";
        public String value = null;

        public CutletArg(String name, String value) throws Exception {
            if (!name.startsWith("-")) {
                throw new Exception("Error: CutletArg() improper name, missing flag >" + name + "<");
            }
            this.name = name;
            if (!value.startsWith("\"")) {
                throw new Exception("Error: CutletArg() improper value, missing quote at start >" + (value.length() > 8 ? value.substring(0, 8) : value) + "<");
            }
            if (!value.endsWith("\"")) {
                this.value = value.substring(1);
                throw new Exception("Error: CutletArg() improper value, missing quote at end >" + (value.length() > 8 ? value.substring(value.length() - 7) : value) + "<");
            }
            this.value = value.substring(1, value.length() - 1);
        }

        public String toString() {
            return this.name + " \"" + this.value + "\" ";
        }
    }

    public static class SendFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            KAbstractWindow win = KAbstractDesktop.getFrontWindow();
            if (!(win instanceof KTextWindow)) {
                Cutter.setLog("    Info:CutletCmd.SendFileAction.actionPerformed()\n");
                Cutter.setLog("       Cannot find a front window.");
                return;
            }
            File winFile = win.getFile();
            if (winFile == null) {
                Cutter.setLog("    Info:CutletCmd.SendFileAction.actionPerformed()\n");
                Cutter.setLog("       Front window has not been saved.");
                return;
            }
            File pwd = FileUtils.getPWDFile();
            File dist = new File(pwd, CutletCmd.CUTLET_DISTRIBUTION_FILENAME);
            if (!dist.exists()) {
                Cutter.setLog("    Info:CutletCmd.SendFileAction.actionPerformed()\n");
                Cutter.setLog("       Cannot find \"cutlet_distribution.txt\"");
                return;
            }
            String ips = FileUtils.read(dist.getPath());
            StringBuffer buff = new StringBuffer();
            buff.append("file.save -src \"" + winFile.getPath() + "\" -name \"" + winFile.getName() + "\"\n");
            buff.append(ips);
            CutletExecutor ce = new CutletExecutor();
            ce.execute(buff.toString());
        }
    }
}

